/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMUserConfig;
import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.bean.UserConfig;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTUserConfig;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMUserConfigService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserConfigServlet
extends OKMRemoteServiceServlet
implements OKMUserConfigService {
    private static Logger log = LoggerFactory.getLogger(UserConfigServlet.class);
    private static final long serialVersionUID = 1L;

    @Override
    public void setUserHome(String path) throws OKMException {
        log.debug("setUserHome({})", (Object)path);
        this.updateSessionManager();
        try {
            OKMUserConfig.getInstance().setHome(null, path);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("019", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("019", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("019", "006"), e.getMessage());
        }
        log.debug("setUserHome: void");
    }

    @Override
    public GWTUserConfig getUserHome() throws OKMException {
        log.debug("getUserHome()");
        this.updateSessionManager();
        try {
            UserConfig config = OKMUserConfig.getInstance().getConfig(null);
            if (!config.getHomePath().startsWith("/okm:root")) {
                OKMUserConfig.getInstance().setHome(null, "/okm:root");
                config = OKMUserConfig.getInstance().getConfig(null);
            }
            return GWTUtil.copy(config);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("019", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("019", "024"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("019", "006"), e.getMessage());
        }
    }
}

