/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMWorkflow;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.workflow.ProcessDefinition;
import com.openkm.bean.workflow.TaskInstance;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.RepositoryException;
import com.openkm.core.WorkflowException;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTProcessDefinition;
import com.openkm.frontend.client.bean.GWTTaskInstance;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMWorkflowService;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowServlet
extends OKMRemoteServiceServlet
implements OKMWorkflowService {
    private static Logger log = LoggerFactory.getLogger(WorkflowServlet.class);
    private static final long serialVersionUID = 1L;

    @Override
    public List<GWTProcessDefinition> findLatestProcessDefinitions() throws OKMException {
        log.debug("findLatestProcessDefinitions()");
        ArrayList<GWTProcessDefinition> processDefinitionList = new ArrayList<GWTProcessDefinition>();
        this.updateSessionManager();
        try {
            Iterator<ProcessDefinition> it = OKMWorkflow.getInstance().findLatestProcessDefinitions(null).iterator();
            while (it.hasNext()) {
                processDefinitionList.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("findLatestProcessDefinitions: {}", processDefinitionList);
        return processDefinitionList;
    }

    @Override
    public void runProcessDefinition(String UUID2, String name, List<GWTFormElement> formElements) throws OKMException {
        log.debug("runProcessDefinition()");
        this.updateSessionManager();
        try {
            ArrayList<FormElement> formElementList = new ArrayList<FormElement>();
            Iterator<GWTFormElement> it = formElements.iterator();
            while (it.hasNext()) {
                formElementList.add(GWTUtil.copy(it.next()));
            }
            ProcessDefinition pd = OKMWorkflow.getInstance().findLastProcessDefinition(null, name);
            OKMWorkflow.getInstance().runProcessDefinition(null, pd.getId(), UUID2, formElementList);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("runProcessDefinition: void");
    }

    @Override
    public List<GWTTaskInstance> findUserTaskInstances() throws OKMException {
        log.debug("findUserTaskInstances()");
        ArrayList<GWTTaskInstance> taskInstances = new ArrayList<GWTTaskInstance>();
        this.updateSessionManager();
        try {
            for (TaskInstance taskInstance : OKMWorkflow.getInstance().findUserTaskInstances(null)) {
                taskInstances.add(GWTUtil.copy(taskInstance));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("findUserTaskInstances: {}", taskInstances);
        return taskInstances;
    }

    @Override
    public List<GWTTaskInstance> findPooledTaskInstances() throws OKMException {
        log.debug("findPooledTaskInstances()");
        ArrayList<GWTTaskInstance> taskInstances = new ArrayList<GWTTaskInstance>();
        this.updateSessionManager();
        try {
            Iterator<TaskInstance> it = OKMWorkflow.getInstance().findPooledTaskInstances(null).iterator();
            while (it.hasNext()) {
                taskInstances.add(GWTUtil.copy(it.next()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("findPooledTaskInstances: {}", taskInstances);
        return taskInstances;
    }

    @Override
    public Map<String, List<GWTFormElement>> getProcessDefinitionForms(double id) throws OKMException {
        log.debug("getProcessDefinitionForms()");
        HashMap<String, List<GWTFormElement>> formElementList = new HashMap<String, List<GWTFormElement>>();
        this.updateSessionManager();
        try {
            Map<String, List<FormElement>> list = OKMWorkflow.getInstance().getProcessDefinitionForms(null, new Double(id).longValue());
            for (String key : list.keySet()) {
                List<FormElement> col = list.get(key);
                ArrayList<GWTFormElement> gwtCol = new ArrayList<GWTFormElement>();
                Iterator<FormElement> itf = col.iterator();
                while (itf.hasNext()) {
                    gwtCol.add(GWTUtil.copy(itf.next()));
                }
                formElementList.put(key, gwtCol);
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "019"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("getProcessDefinitionForms: {}", formElementList);
        return formElementList;
    }

    @Override
    public Map<String, List<GWTFormElement>> getProcessDefinitionFormsByName(String name) throws OKMException {
        log.debug("getProcessDefinitionFormsByName()");
        HashMap<String, List<GWTFormElement>> formElementList = new HashMap<String, List<GWTFormElement>>();
        this.updateSessionManager();
        try {
            ProcessDefinition pd = OKMWorkflow.getInstance().findLastProcessDefinition(null, name);
            Map<String, List<FormElement>> list = OKMWorkflow.getInstance().getProcessDefinitionForms(null, pd.getId());
            for (String key : list.keySet()) {
                List<FormElement> col = list.get(key);
                ArrayList<GWTFormElement> gwtCol = new ArrayList<GWTFormElement>();
                Iterator<FormElement> itf = col.iterator();
                while (itf.hasNext()) {
                    gwtCol.add(GWTUtil.copy(itf.next()));
                }
                formElementList.put(key, gwtCol);
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "019"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("getProcessDefinitionFormsByName: {}", formElementList);
        return formElementList;
    }

    @Override
    public void setTaskInstanceValues(double id, String transitionName, List<GWTFormElement> formElements) throws OKMException {
        log.debug("setTaskInstanceValues()");
        this.updateSessionManager();
        try {
            ArrayList<FormElement> formElementList = new ArrayList<FormElement>();
            Iterator<GWTFormElement> it = formElements.iterator();
            while (it.hasNext()) {
                formElementList.add(GWTUtil.copy(it.next()));
            }
            OKMWorkflow.getInstance().setTaskInstanceValues(null, new Double(id).longValue(), transitionName, formElementList);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("setTaskInstanceValues: void");
    }

    @Override
    public void addComment(double tokenId, String message) throws OKMException {
        log.debug("addComment({}, {})", (Object)tokenId, (Object)message);
        this.updateSessionManager();
        try {
            OKMWorkflow.getInstance().addTokenComment(null, new Double(tokenId).longValue(), message);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("addComment: void");
    }

    @Override
    public void setTaskInstanceActorId(double id) throws OKMException {
        log.debug("setTaskInstanceActorId({})", (Object)id);
        this.updateSessionManager();
        try {
            OKMWorkflow.getInstance().setTaskInstanceActorId(null, new Double(id).longValue(), this.getThreadLocalRequest().getRemoteUser());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("setTaskInstanceActorId: void");
    }

    @Override
    public void startTaskInstance(double id) throws OKMException {
        log.debug("startTaskInstance({})", (Object)id);
        this.updateSessionManager();
        try {
            OKMWorkflow okmWorkflow = OKMWorkflow.getInstance();
            long taskInstanceId = new Double(id).longValue();
            TaskInstance ti = okmWorkflow.getTaskInstance(null, taskInstanceId);
            if (ti.getStart() == null) {
                okmWorkflow.startTaskInstance(null, taskInstanceId);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("startTaskInstance: void");
    }

    @Override
    public GWTTaskInstance getUserTaskInstance(long taskInstanceId) throws OKMException {
        log.debug("getUserTaskInstance(taskInstanceId={})", (Object)taskInstanceId);
        this.updateSessionManager();
        try {
            for (TaskInstance taskInstance : OKMWorkflow.getInstance().findUserTaskInstances(null)) {
                if (taskInstance.getId() != taskInstanceId) continue;
                log.debug("getUserTaskInstance: " + taskInstance);
                return GWTUtil.copy(OKMWorkflow.getInstance().getTaskInstance(null, taskInstanceId));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "024"), e.getMessage());
        }
        catch (WorkflowException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "026"), e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("015", "006"), e.getMessage());
        }
        log.debug("getUserTaskInstance: null");
        return null;
    }
}

