/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend;

import com.openkm.api.OKMAuth;
import com.openkm.api.OKMDashboard;
import com.openkm.api.OKMPropertyGroup;
import com.openkm.bean.PropertyGroup;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.AuthDAO;
import com.openkm.dao.LanguageDAO;
import com.openkm.dao.MailAccountDAO;
import com.openkm.dao.ReportDAO;
import com.openkm.dao.UserConfigDAO;
import com.openkm.dao.bean.Language;
import com.openkm.dao.bean.MailAccount;
import com.openkm.dao.bean.Profile;
import com.openkm.dao.bean.Report;
import com.openkm.dao.bean.User;
import com.openkm.dao.bean.UserConfig;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.GWTAvailableOption;
import com.openkm.frontend.client.bean.GWTLanguage;
import com.openkm.frontend.client.bean.GWTProfileToolbar;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.bean.GWTWorkspace;
import com.openkm.frontend.client.contants.service.ErrorCode;
import com.openkm.frontend.client.service.OKMWorkspaceService;
import com.openkm.jcr.JCRUtils;
import com.openkm.principal.DatabasePrincipalAdapter;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.servlet.frontend.OKMRemoteServiceServlet;
import com.openkm.util.GWTUtil;
import com.openkm.util.ReportUtils;
import com.openkm.util.WarUtils;
import com.openkm.validator.ValidatorException;
import com.openkm.validator.ValidatorFactory;
import com.openkm.validator.password.PasswordValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.LoginException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceServlet
extends OKMRemoteServiceServlet
implements OKMWorkspaceService {
    private static Logger log = LoggerFactory.getLogger(WorkspaceServlet.class);
    private static final long serialVersionUID = 8673521252684830906L;

    @Override
    public GWTWorkspace getUserWorkspace() throws OKMException {
        log.debug("getUserWorkspace()");
        this.updateSessionManager();
        GWTWorkspace workspace = new GWTWorkspace();
        workspace.setApplicationURL(Config.APPLICATION_URL);
        workspace.setUser(this.getThreadLocalRequest().getRemoteUser());
        workspace.setAppVersion(WarUtils.getAppVersion().toString());
        workspace.setWorkflowRunConfigForm(Config.WORKFLOW_RUN_CONFIG_FORM);
        workspace.setWorkflowProcessIntanceVariableUUID(Config.WORKFLOW_PROCESS_INSTANCE_VARIABLE_UUID);
        workspace.setWorkflowProcessIntanceVariablePath(Config.WORKFLOW_PROCESS_INSTANCE_VARIABLE_PATH);
        workspace.setToken(this.getThreadLocalRequest().getSession().getId());
        workspace.setKeepAliveSchedule(Config.SCHEDULE_SESSION_KEEPALIVE);
        workspace.setDashboardSchedule(Config.SCHEDULE_DASHBOARD_REFRESH);
        ArrayList<GWTPropertyGroup> wizardPropGrpLst = new ArrayList<GWTPropertyGroup>();
        ArrayList<String> wizardWorkflowLst = new ArrayList<String>();
        ArrayList<String> miscWorkflowLst = new ArrayList<String>();
        Profile up = new Profile();
        Session session = null;
        try {
            session = JCRUtils.getSession();
            UserConfig uc = UserConfigDAO.findByPk(session, session.getUserID());
            up = uc.getProfile();
            block12: for (String pgroup : up.getWizard().getPropertyGroups()) {
                for (PropertyGroup pg : OKMPropertyGroup.getInstance().getAllGroups(null)) {
                    if (!pg.getName().equals(pgroup) || !pg.isVisible()) continue;
                    wizardPropGrpLst.add(GWTUtil.copy(pg));
                    continue block12;
                }
            }
            for (String workflow : up.getWizard().getWorkflows()) {
                wizardWorkflowLst.add(workflow);
            }
            for (String workflow : up.getMisc().getWorkflows()) {
                miscWorkflowLst.add(workflow);
            }
            HashMap<String, String> userNames = new HashMap<String, String>();
            List<String> users = OKMAuth.getInstance().getUsers(null);
            for (String key : users) {
                if (key.contentEquals("")) continue;
                userNames.put(key, OKMAuth.getInstance().getName(null, key));
            }
            workspace.setUserNames(userNames);
            workspace.setPreviewer(Config.SYSTEM_PREVIEWER);
            workspace.setAdvancedFilters(up.getMisc().isAdvancedFilters());
            workspace.setWizardPropertyGroups(!up.getWizard().getPropertyGroups().isEmpty());
            workspace.setWizardPropertyGroupsList(wizardPropGrpLst);
            workspace.setWizardWorkflows(!up.getWizard().getWorkflows().isEmpty());
            workspace.setWizardWorkflowList(wizardWorkflowLst);
            workspace.setWizardCategories(up.getWizard().isCategoriesEnabled());
            workspace.setWizardKeywords(up.getWizard().isKeywordsEnabled());
            workspace.setMiscWorkflowList(miscWorkflowLst);
            workspace.setChatEnabled(up.getChat().isChatEnabled());
            workspace.setChatAutoLogin(up.getChat().isAutoLoginEnabled());
            workspace.setAdminRole(this.getThreadLocalRequest().isUserInRole(Config.DEFAULT_ADMIN_ROLE));
            workspace.setAdminUser(Config.ADMIN_USER.equals(workspace.getUser()));
            workspace.setWebSkin(up.getMisc().getWebSkin());
            workspace.setKeywordEnabled(up.getMisc().isKeywordsEnabled());
            workspace.setUserQuotaEnabled(up.getMisc().getUserQuota() > 0L);
            workspace.setUserQuotaLimit(up.getMisc().getUserQuota() * 1024L * 1024L);
            workspace.setPrintPreview(up.getMisc().isPrintPreview());
            workspace.setUploadNotifyUsers(up.getMisc().isUploadNotifyUsers());
            workspace.setWebdavFix(Config.SYSTEM_WEBDAV_FIX);
            workspace.setStackTaxonomy(up.getStack().isTaxonomyVisible());
            workspace.setStackCategoriesVisible(up.getStack().isCategoriesVisible());
            workspace.setStackThesaurusVisible(up.getStack().isThesaurusVisible());
            workspace.setStackTemplatesVisible(up.getStack().isTemplatesVisible());
            workspace.setStackPersonalVisible(up.getStack().isPersonalVisible());
            workspace.setStackMailVisible(up.getStack().isMailVisible());
            workspace.setStackTrashVisible(up.getStack().isTrashVisible());
            workspace.setMenuFileVisible(up.getMenu().isFileVisible());
            workspace.setMenuEditVisible(up.getMenu().isEditVisible());
            workspace.setMenuBookmarksVisible(up.getMenu().isBookmarksVisible());
            workspace.setMenuToolsVisible(up.getMenu().isToolsVisible());
            workspace.setMenuHelpVisible(up.getMenu().isHelpVisible());
            workspace.setTabDesktopVisible(up.getTab().isDesktopVisible());
            workspace.setTabSearchVisible(up.getTab().isSearchVisible());
            workspace.setTabDashboardVisible(up.getTab().isDashboardVisible());
            workspace.setTabAdminVisible(this.getThreadLocalRequest().isUserInRole(Config.DEFAULT_ADMIN_ROLE) && up.getTab().isAdministrationVisible());
            workspace.setTabDocumentPropertiesVisible(up.getTab().getDocument().isPropertiesVisible());
            workspace.setTabDocumentSecurityVisible(up.getTab().getDocument().isSecurityVisible());
            workspace.setTabDocumentNotesVisible(up.getTab().getDocument().isNotesVisible());
            workspace.setTabDocumentVersionVisible(up.getTab().getDocument().isVersionsVisible());
            workspace.setTabDocumentPreviewVisible(up.getTab().getDocument().isPreviewVisible());
            workspace.setTabDocumentPropertyGroupsVisible(up.getTab().getDocument().isPropertyGroupsVisible());
            workspace.setTabFolderPropertiesVisible(up.getTab().getFolder().isPropertiesVisible());
            workspace.setTabFolderSecurityVisible(up.getTab().getFolder().isSecurityVisible());
            workspace.setTabFolderNotesVisible(up.getTab().getFolder().isNotesVisible());
            workspace.setTabMailPropertiesVisible(up.getTab().getMail().isPropertiesVisible());
            workspace.setTabMailSecurityVisible(up.getTab().getMail().isSecurityVisible());
            workspace.setDashboardUserVisible(up.getDashboard().isUserVisible());
            workspace.setDashboardMailVisible(up.getDashboard().isMailVisible());
            workspace.setDashboardNewsVisible(up.getDashboard().isNewsVisible());
            workspace.setDashboardGeneralVisible(up.getDashboard().isGeneralVisible());
            workspace.setDashboardWorkflowVisible(up.getDashboard().isWorkflowVisible());
            workspace.setDashboardKeywordsVisible(up.getDashboard().isKeywordsVisible());
            GWTAvailableOption availableOption = new GWTAvailableOption();
            availableOption.setCreateFolderOption(up.getMenu().getFile().isCreateFolderVisible());
            availableOption.setFindFolderOption(up.getMenu().getFile().isFindFolderVisible());
            availableOption.setGotoFolderOption(up.getMenu().getFile().isGoFolderVisible());
            availableOption.setDownloadOption(up.getMenu().getFile().isDownloadVisible());
            availableOption.setDownloadPdfOption(up.getMenu().getFile().isDownloadPdfVisible());
            availableOption.setAddDocumentOption(up.getMenu().getFile().isAddDocumentVisible());
            availableOption.setWorkflowOption(up.getMenu().getFile().isStartWorkflowVisible());
            availableOption.setRefreshOption(up.getMenu().getFile().isRefreshVisible());
            availableOption.setScannerOption(up.getMenu().getFile().isScannerVisible());
            availableOption.setUploaderOption(up.getMenu().getFile().isUploaderVisible());
            availableOption.setExportOption(up.getMenu().getFile().isExportVisible());
            availableOption.setCreateFromTemplateOption(up.getMenu().getFile().isCreateFromTemplateVisible());
            availableOption.setPurgeOption(up.getMenu().getFile().isPurgeVisible());
            availableOption.setRestoreOption(up.getMenu().getFile().isRestoreVisible());
            availableOption.setPurgeTrashOption(up.getMenu().getFile().isPurgeTrashVisible());
            availableOption.setSendDocumentLinkOption(up.getMenu().getFile().isSendDocumentLinkVisible());
            availableOption.setSendDocumentAttachmentOption(up.getMenu().getFile().isSendDocumentAttachmentVisible());
            availableOption.setLockOption(up.getMenu().getEdit().isLockVisible());
            availableOption.setUnLockOption(up.getMenu().getEdit().isUnlockVisible());
            availableOption.setRenameOption(up.getMenu().getEdit().isRenameVisible());
            availableOption.setCopyOption(up.getMenu().getEdit().isCopyVisible());
            availableOption.setMoveOption(up.getMenu().getEdit().isMoveVisible());
            availableOption.setCheckinOption(up.getMenu().getEdit().isCheckInVisible());
            availableOption.setCheckoutOption(up.getMenu().getEdit().isCheckOutVisible());
            availableOption.setCancelCheckoutOption(up.getMenu().getEdit().isCancelCheckOutVisible());
            availableOption.setDeleteOption(up.getMenu().getEdit().isDeleteVisible());
            availableOption.setAddPropertyGroupOption(up.getMenu().getEdit().isAddPropertyGroupVisible());
            availableOption.setRemovePropertyGroupOption(up.getMenu().getEdit().isRemovePropertyGroupVisible());
            availableOption.setAddSubscription(up.getMenu().getEdit().isAddSubscriptionVisible());
            availableOption.setRemoveSubscription(up.getMenu().getEdit().isRemoveSubscriptionVisible());
            availableOption.setManageBookmarkOption(up.getMenu().getBookmark().isManageBookmarksVisible());
            availableOption.setAddBookmarkOption(up.getMenu().getBookmark().isAddBookmarkVisible());
            availableOption.setHomeOption(up.getMenu().getBookmark().isGoHomeVisible());
            availableOption.setSetHomeOption(up.getMenu().getBookmark().isSetHomeVisible());
            availableOption.setLanguagesOption(up.getMenu().getTool().isLanguagesVisible());
            availableOption.setSkinOption(up.getMenu().getTool().isSkinVisible());
            availableOption.setDebugOption(up.getMenu().getTool().isDebugVisible());
            availableOption.setAdministrationOption(up.getMenu().getTool().isAdministrationVisible() && this.getThreadLocalRequest().isUserInRole(Config.DEFAULT_ADMIN_ROLE));
            availableOption.setPreferencesOption(up.getMenu().getTool().isPreferencesVisible());
            availableOption.setHelpOption(up.getMenu().getHelp().isHelpVisible());
            availableOption.setDocumentationOption(up.getMenu().getHelp().isDocumentationVisible());
            availableOption.setBugReportOption(up.getMenu().getHelp().isBugTrackingVisible());
            availableOption.setSupportRequestOption(up.getMenu().getHelp().isSupportVisible());
            availableOption.setPublicForumOption(up.getMenu().getHelp().isForumVisible());
            availableOption.setVersionChangesOption(up.getMenu().getHelp().isChangelogVisible());
            availableOption.setProjectWebOption(up.getMenu().getHelp().isWebSiteVisible());
            availableOption.setAboutOption(up.getMenu().getHelp().isAboutVisible());
            availableOption.setMediaPlayerOption(true);
            availableOption.setImageViewerOption(true);
            workspace.setAvailableOption(availableOption);
            for (Integer rpId : up.getMisc().getReports()) {
                Report report = ReportDAO.findByPk(rpId);
                if (report == null || !report.isActive()) continue;
                workspace.getReports().add(GWTUtil.copy(report, ReportUtils.getReportParameters(rpId)));
            }
            GWTProfileToolbar profileToolbar = new GWTProfileToolbar();
            profileToolbar.setAddDocumentVisible(availableOption.isAddDocumentOption());
            profileToolbar.setAddPropertyGroupVisible(availableOption.isAddPropertyGroupOption());
            profileToolbar.setAddSubscriptionVisible(availableOption.isAddSubscription());
            profileToolbar.setCancelCheckoutVisible(availableOption.isCancelCheckoutOption());
            profileToolbar.setCheckoutVisible(availableOption.isCheckoutOption());
            profileToolbar.setCheckinVisible(availableOption.isCheckinOption());
            profileToolbar.setCreateFolderVisible(availableOption.isCreateFolderOption());
            profileToolbar.setDeleteVisible(availableOption.isDeleteOption());
            profileToolbar.setDownloadPdfVisible(availableOption.isDeleteOption());
            profileToolbar.setDownloadVisible(availableOption.isDownloadOption());
            profileToolbar.setFindDocumentVisible(availableOption.isDownloadOption());
            profileToolbar.setFindFolderVisible(availableOption.isFindFolderOption());
            profileToolbar.setHomeVisible(availableOption.isHomeOption());
            profileToolbar.setLockVisible(availableOption.isLockOption());
            profileToolbar.setRefreshVisible(availableOption.isRefreshOption());
            profileToolbar.setRemovePropertyGroupVisible(availableOption.isRemovePropertyGroupOption());
            profileToolbar.setRemoveSubscriptionVisible(availableOption.isRemoveSubscription());
            profileToolbar.setScannerVisible(availableOption.isScannerOption());
            profileToolbar.setStartWorkflowVisible(availableOption.isWorkflowOption());
            profileToolbar.setUnlockVisible(availableOption.isUnLockOption());
            profileToolbar.setUploaderVisible(availableOption.isUploaderOption());
            workspace.setProfileToolbar(profileToolbar);
            ArrayList<GWTLanguage> langs = new ArrayList<GWTLanguage>();
            for (Language lang : LanguageDAO.findAll()) {
                langs.add(GWTUtil.copy(lang));
            }
            workspace.setLangs(langs);
            User user = new User();
            if (Config.PRINCIPAL_ADAPTER.equals(DatabasePrincipalAdapter.class.getCanonicalName())) {
                user = AuthDAO.findUserByPk(this.getThreadLocalRequest().getRemoteUser());
                if (user != null) {
                    workspace.setEmail(user.getEmail());
                }
            } else {
                user.setId(this.getThreadLocalRequest().getRemoteUser());
                user.setName("");
                user.setEmail("");
                user.setActive(true);
                user.setPassword("");
            }
            for (MailAccount mailAccount : MailAccountDAO.findByUser(this.getThreadLocalRequest().getRemoteUser(), true)) {
                workspace.setImapHost(mailAccount.getMailHost());
                workspace.setImapUser(mailAccount.getMailUser());
                workspace.setImapFolder(mailAccount.getMailFolder());
                workspace.setImapID(mailAccount.getId());
            }
            if (user != null) {
                workspace.setRoleList(OKMAuth.getInstance().getRolesByUser(null, user.getId()));
            } else {
                log.warn("User is null! Please, check principal.adapter={}", (Object)Config.PRINCIPAL_ADAPTER);
            }
            if (Config.PRINCIPAL_ADAPTER.equals(DatabasePrincipalAdapter.class.getCanonicalName())) {
                workspace.setChangePassword(true);
            } else {
                workspace.setChangePassword(false);
            }
        }
        catch (LoginException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "001"), e.getMessage());
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "024"), e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "013"), e.getMessage());
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "019"), e.getMessage());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "001"), e.getMessage());
        }
        catch (PrincipalAdapterException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "025"), e.getMessage());
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "015"), e.getMessage());
        }
        finally {
            JCRUtils.logout(session);
        }
        return workspace;
    }

    @Override
    public Double getUserDocumentsSize() throws OKMException {
        Double docSize = new Double(0.0);
        this.updateSessionManager();
        try {
            docSize = new Double(OKMDashboard.getInstance().getUserDocumentsSize(null));
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "001"), e.getMessage());
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "024"), e.getMessage());
        }
        return docSize;
    }

    @Override
    public void updateUserWorkspace(GWTWorkspace workspace) throws OKMException {
        this.updateSessionManager();
        User user = new User();
        user.setId(workspace.getUser());
        user.setPassword(workspace.getPassword());
        user.setEmail(workspace.getEmail());
        MailAccount mailAccount = new MailAccount();
        mailAccount.setActive(true);
        mailAccount.setMailFolder(workspace.getImapFolder());
        mailAccount.setMailHost(workspace.getImapHost());
        mailAccount.setMailPassword(workspace.getImapPassword());
        mailAccount.setMailUser(workspace.getImapUser());
        mailAccount.setUser(workspace.getUser());
        mailAccount.setId(workspace.getImapID());
        try {
            if (Config.PRINCIPAL_ADAPTER.equals(DatabasePrincipalAdapter.class.getCanonicalName())) {
                AuthDAO.updateUserPassword(workspace.getUser(), workspace.getPassword());
                if (!user.getEmail().equals("")) {
                    AuthDAO.updateUserEmail(workspace.getUser(), workspace.getEmail());
                }
            }
            if (MailAccountDAO.findByUser(workspace.getUser(), false).size() > 0) {
                MailAccountDAO.update(mailAccount);
                if (!mailAccount.getMailPassword().equals("")) {
                    MailAccountDAO.updatePassword(mailAccount.getId(), mailAccount.getMailPassword());
                }
            } else if (mailAccount.getMailHost().length() > 0 && mailAccount.getMailFolder().length() > 0 && mailAccount.getMailUser().length() > 0 && !mailAccount.getMailPassword().equals("")) {
                MailAccountDAO.create(mailAccount);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "021"), e.getMessage());
        }
    }

    @Override
    public void deleteMailAccount(int id) throws OKMException {
        this.updateSessionManager();
        try {
            MailAccountDAO.delete(id);
        }
        catch (DatabaseException e) {
            throw new OKMException(ErrorCode.get("014", "021"), e.getMessage());
        }
    }

    @Override
    public String isValidPassword(String password) throws OKMException {
        String msg = "";
        this.updateSessionManager();
        try {
            PasswordValidator passwordValidator = ValidatorFactory.getPasswordValidator();
            try {
                passwordValidator.Validate(password);
            }
            catch (ValidatorException e) {
                msg = e.getMessage();
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OKMException(ErrorCode.get("014", "001"), e.getMessage());
        }
        return msg;
    }
}

