/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.frontend.util;

import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CultureComparator<T>
implements Comparator<T> {
    private static Logger log = LoggerFactory.getLogger(CultureComparator.class);
    protected static final String DEFAULT_LOCALE = "en";
    protected Collator collator;
    private static HashMap<String, HashMap<String, CultureComparator<?>>> comparators = new HashMap();
    private static final Object SYNC_LOCK = new Object();

    protected CultureComparator(String sLocale) {
        try {
            if (sLocale == null) {
                log.debug("no locale defined, using default collator");
                this.collator = Collator.getInstance();
                return;
            }
            String[] split = sLocale.split("-");
            Locale locale = split.length > 1 ? new Locale(split[0], split[1]) : new Locale(split[0]);
            this.collator = Collator.getInstance(locale);
            log.debug("created new collator (locale={}, lang={}, country={}", new Object[]{sLocale, locale.getLanguage(), locale.getCountry()});
        }
        catch (Exception e) {
            log.warn(String.format("Unable to create collator for %1$s, creating default", sLocale), (Throwable)e);
            this.collator = Collator.getInstance();
        }
    }

    @Override
    public abstract int compare(T var1, T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CultureComparator<?> getComparator(String className, String locale, HashMap<String, CultureComparator<?>> hashMap) throws Exception {
        CultureComparator comparator = hashMap.get(className);
        if (comparator != null) {
            return comparator;
        }
        Object object = SYNC_LOCK;
        synchronized (object) {
            if (!hashMap.containsKey(className)) {
                Class<?> clazz = Class.forName(className);
                comparator = (CultureComparator)clazz.getDeclaredConstructor(String.class).newInstance(locale);
                hashMap.put(className, comparator);
            } else {
                comparator = hashMap.get(className);
            }
            return comparator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CultureComparator<?> getInstance(Class<?> clazz, String locale) throws Exception {
        CultureComparator comparator;
        String className = clazz.getName();
        HashMap<String, CultureComparator<Object>> hashMap = comparators.get(locale);
        if (hashMap != null) {
            CultureComparator<?> comparator2 = CultureComparator.getComparator(className, locale, hashMap);
            return comparator2;
        }
        Object object = SYNC_LOCK;
        synchronized (object) {
            if (!comparators.containsKey(locale)) {
                hashMap = new HashMap();
                comparator = (CultureComparator)clazz.getDeclaredConstructor(String.class).newInstance(locale);
                hashMap.put(className, comparator);
                comparators.put(locale, hashMap);
            } else {
                hashMap = comparators.get(locale);
                comparator = CultureComparator.getComparator(className, locale, hashMap);
            }
        }
        return comparator;
    }
}

