/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.servlet.mobile;

import com.openkm.api.OKMAuth;
import com.openkm.api.OKMDocument;
import com.openkm.api.OKMFolder;
import com.openkm.api.OKMSearch;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.servlet.mobile.DocumentComparator;
import com.openkm.servlet.mobile.FolderComparator;
import com.openkm.util.WebUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(HandlerServlet.class);
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String action = WebUtils.getString(request, "action");
        log.debug("action: {}", (Object)action);
        try {
            if (action.equals("") || action.equals("browse")) {
                this.browse(request, response);
            } else if (action.equals("fldprop")) {
                this.fldProperties(request, response);
            } else if (action.equals("docprop")) {
                this.docProperties(request, response);
            } else if (action.equals("search")) {
                this.search(request, response);
            } else if (action.equals("logout")) {
                this.logout(request, response);
            }
        }
        catch (AccessDeniedException e) {
            this.sendErrorRedirect(request, response, e);
        }
        catch (PathNotFoundException e) {
            this.sendErrorRedirect(request, response, e);
        }
        catch (ParseException e) {
            this.sendErrorRedirect(request, response, e);
        }
        catch (RepositoryException e) {
            this.sendErrorRedirect(request, response, e);
        }
        catch (DatabaseException e) {
            this.sendErrorRedirect(request, response, e);
        }
    }

    private void sendErrorRedirect(HttpServletRequest request, HttpServletResponse response, Throwable e) throws ServletException, IOException {
        request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
        ServletContext sc = this.getServletConfig().getServletContext();
        sc.getRequestDispatcher("/error.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void browse(HttpServletRequest request, HttpServletResponse response) throws PathNotFoundException, RepositoryException, IOException, ServletException, DatabaseException {
        log.debug("browse({}, {})", (Object)request, (Object)response);
        ServletContext sc = this.getServletContext();
        String userId = request.getRemoteUser();
        String path = WebUtils.getString(request, "path");
        if (path == null || path.equals("")) {
            path = "/okm:root";
        }
        List<Folder> fldList = OKMFolder.getInstance().getChilds(null, path);
        Collections.sort(fldList, FolderComparator.getInstance());
        List<Document> docList = OKMDocument.getInstance().getChilds(null, path);
        Collections.sort(docList, DocumentComparator.getInstance());
        sc.setAttribute("folderChilds", fldList);
        sc.setAttribute("documentChilds", docList);
        sc.setAttribute("userId", (Object)userId);
        sc.setAttribute("path", (Object)path);
        sc.getRequestDispatcher("/" + Config.EXPERIMENTAL_MOBILE_CONTEXT + "/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void fldProperties(HttpServletRequest request, HttpServletResponse response) throws PathNotFoundException, AccessDeniedException, RepositoryException, IOException, ServletException, DatabaseException {
        log.debug("fldProperties({}, {})", (Object)request, (Object)response);
        ServletContext sc = this.getServletContext();
        String uuid = WebUtils.getString(request, "uuid", null);
        String path = WebUtils.getString(request, "path");
        if (uuid != null) {
            path = OKMFolder.getInstance().getPath(null, uuid);
        }
        if (path == null || path.equals("")) {
            path = "/okm:root";
        }
        sc.setAttribute("fld", (Object)OKMFolder.getInstance().getProperties(null, path));
        sc.setAttribute("path", (Object)path);
        sc.getRequestDispatcher("/" + Config.EXPERIMENTAL_MOBILE_CONTEXT + "/fld-properties.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void docProperties(HttpServletRequest request, HttpServletResponse response) throws PathNotFoundException, AccessDeniedException, RepositoryException, IOException, ServletException, DatabaseException {
        log.debug("docProperties({}, {})", (Object)request, (Object)response);
        ServletContext sc = this.getServletContext();
        String uuid = WebUtils.getString(request, "uuid", null);
        String path = WebUtils.getString(request, "path");
        if (uuid != null) {
            path = OKMDocument.getInstance().getPath(null, uuid);
        }
        if (path == null || path.equals("")) {
            path = "/okm:root";
        }
        Document doc = OKMDocument.getInstance().getProperties(null, path);
        ArrayList<String> categories = new ArrayList<String>();
        for (Folder cat : doc.getCategories()) {
            categories.add(cat.getPath().substring("okm:categories".length() + 2));
        }
        sc.setAttribute("doc", (Object)doc);
        sc.setAttribute("path", (Object)path);
        sc.setAttribute("categories", categories);
        sc.getRequestDispatcher("/" + Config.EXPERIMENTAL_MOBILE_CONTEXT + "/doc-properties.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void search(HttpServletRequest request, HttpServletResponse response) throws PathNotFoundException, ParseException, RepositoryException, IOException, ServletException, DatabaseException {
        log.debug("search({}, {})", (Object)request, (Object)response);
        ServletContext sc = this.getServletContext();
        String query = WebUtils.getString(request, "query");
        if (query != null && !query.equals("")) {
            sc.setAttribute("queryResult", OKMSearch.getInstance().findByContent(null, query));
        }
        sc.getRequestDispatcher("/" + Config.EXPERIMENTAL_MOBILE_CONTEXT + "/search.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void logout(HttpServletRequest request, HttpServletResponse response) throws AccessDeniedException, RepositoryException, IOException, DatabaseException {
        log.debug("logout({}, {})", (Object)request, (Object)response);
        OKMAuth.getInstance().logout(null);
        request.getSession().invalidate();
        response.sendRedirect("index.jsp");
    }
}

