/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import javax.naming.NamingException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dummy {
    private static Logger log = LoggerFactory.getLogger(Dummy.class);
    private static String repHomeDir = "repotest2";
    private static Session systemSession = null;
    private static Repository repository = null;

    public static void main(String[] args) throws NamingException, RepositoryException, FileNotFoundException {
        log.debug("*** DESTROY REPOSITORY ***");
        Dummy.removeRepository();
        log.debug("*** CREATE REPOSITORY ***");
        Dummy.createRepository();
        log.debug("*** USER LOGIN ***");
        Session userSession = Dummy.login("paco", "pepe");
        log.debug("*** GET MY ROOT NODE ***");
        Node rootNode = userSession.getRootNode();
        Node myRoot = rootNode.getNode("my:root");
        log.debug("*** ADD A DOCUMENT NODE ***");
        Node fileNode = myRoot.addNode("perico", "nt:file");
        Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
        log.debug("*** ADD DOCUMENT NODE PROPERTIES ***");
        log.debug("*** PROPERTIES #1 ***");
        contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream("Texto de pruebas".getBytes()));
        log.debug("*** PROPERTIES #2 ***");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        log.debug("*** PROPERTIES #3 ***");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        log.debug("*** SERIALIZE THE ADDED NODE ***");
        myRoot.save();
        for (int i = 0; i < 100; ++i) {
        }
        myRoot.save();
        log.debug("*** SAY BYE ***");
        userSession.logout();
        Dummy.getSystemSession().logout();
    }

    private static void removeRepository() {
        try {
            FileUtils.deleteDirectory((File)new File(repHomeDir));
        }
        catch (IOException e) {
            System.err.println("No previous repo");
        }
    }

    public static Session login(String user, String pass) throws NamingException, RepositoryException, LoginException, NoSuchWorkspaceException {
        Repository repository = Dummy.getRepository();
        Session session = repository.login((Credentials)new SimpleCredentials(user, pass.toCharArray()), null);
        log.debug("Session: " + session);
        return session;
    }

    public static Repository getRepository() throws RepositoryException {
        if (repository == null) {
            String repositoryConfig = "repository2.xml";
            String repositoryHome = "repotest2";
            RepositoryConfig config = RepositoryConfig.create((String)repositoryConfig, (String)repositoryHome);
            repository = RepositoryImpl.create((RepositoryConfig)config);
            log.debug("*** System repository created " + repository);
        }
        return repository;
    }

    public static Session getSystemSession() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (systemSession == null) {
            systemSession = repository.login((Credentials)new SimpleCredentials("system", "".toCharArray()), null);
            log.debug("*** System user created " + systemSession.getUserID());
        }
        return systemSession;
    }

    public static Node createRepository() throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException, ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, InvalidItemStateException {
        Session systemSession = Dummy.getSystemSession();
        Workspace ws = systemSession.getWorkspace();
        ws.getNamespaceRegistry().registerNamespace("my", "http://www.guia-ubuntu.org/1.0");
        Node root = systemSession.getRootNode();
        Node okmRoot = root.addNode("my:root", "nt:folder");
        okmRoot.addMixin("mix:referenceable");
        systemSession.save();
        log.info("****** Repository created *******");
        return okmRoot;
    }

    public static void addDocument(Session session, Node okmRoot, String fileName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, ValueFormatException, FileNotFoundException, AccessDeniedException, InvalidItemStateException {
        Node fileNode = okmRoot.addNode(new File(fileName).getName(), "nt:file");
        fileNode.addMixin("mix:referenceable");
        fileNode.addMixin("mix:lockable");
        fileNode.addMixin("mix:versionable");
        Node resNode = fileNode.addNode("jcr:content", "nt:resource");
        resNode.setProperty("jcr:mimeType", Dummy.getMime(fileName));
        resNode.setProperty("jcr:data", (InputStream)new FileInputStream(fileName));
        resNode.setProperty("jcr:lastModified", Calendar.getInstance());
        session.save();
        log.info("File '" + fileName + "' added.");
    }

    public static String getMime(String fileName) {
        if (fileName.endsWith(".doc")) {
            return "application/msword";
        }
        if (fileName.endsWith(".odt")) {
            return "application/vnd.oasis.opendocument.text";
        }
        if (fileName.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (fileName.endsWith(".txt")) {
            return "text/plain";
        }
        return "application/octect-stream";
    }

    public static void search(Session session, String words) throws RepositoryException, InvalidQueryException, UnsupportedRepositoryOperationException, ItemNotFoundException, AccessDeniedException {
        String statement = "/jcr:root/my:root//element(*,nt:resource)[jcr:contains(.,'" + words + "')]";
        Workspace workspace = session.getWorkspace();
        QueryManager queryManager = workspace.getQueryManager();
        Query query = queryManager.createQuery(statement, "xpath");
        QueryResult result = query.execute();
        log.info("Search results:");
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            Node sNode = (Node)it.next();
            log.info(" * " + sNode.getParent().getName());
        }
    }
}

