/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import javax.naming.NamingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyEncoding {
    private static Logger log = LoggerFactory.getLogger(DummyEncoding.class);
    private static String repHomeDir = "repotest2";
    private static Session systemSession = null;
    private static Repository repository = null;
    private static String nodoPruebaName = "nodoPrueba \u03b3\u03bb\u03ce\u03c3\u03c3\u03b1 \u00f1a\u00f1e\u00f1\u00f3";

    public static void main(String[] args) throws NamingException, RepositoryException, IOException {
        DummyEncoding.write();
        DummyEncoding.read();
    }

    private static void write() throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, InvalidItemStateException, RepositoryException, NamingException, UnsupportedEncodingException {
        log.info("*** DESTROY REPOSITORY ***");
        DummyEncoding.removeRepository();
        log.info("*** CREATE REPOSITORY ***");
        DummyEncoding.createRepository();
        log.info("*** USER LOGIN ***");
        Session userSession = DummyEncoding.login("paco", "pepe");
        log.info("*** GET MY ROOT NODE ***");
        Node rootNode = userSession.getRootNode();
        Node myRoot = rootNode.getNode("my:root");
        log.info("*** ADD A TEST NODE ***");
        Node nodoPrueba = myRoot.addNode(nodoPruebaName);
        nodoPrueba.setProperty("nombre", nodoPruebaName);
        myRoot.save();
        log.info("*** ADD A DOCUMENT NODE ***");
        Node fileNode = myRoot.addNode("\u00f1a\u00f1\u00f3", "nt:file");
        Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(nodoPruebaName.getBytes("UTF-8")));
        contentNode.setProperty("jcr:mimeType", "text/plain");
        contentNode.setProperty("jcr:encoding", "UTF-8");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        myRoot.save();
        log.info("*** SAY BYE ***");
        userSession.logout();
        DummyEncoding.getSystemSession().logout();
    }

    private static void read() throws LoginException, NoSuchWorkspaceException, NamingException, RepositoryException, IOException {
        log.info("*** USER LOGIN ***");
        Session userSession = DummyEncoding.login("paco", "pepe");
        log.info("*** GET MY ROOT NODE ***");
        Node rootNode = userSession.getRootNode();
        Node myRoot = rootNode.getNode("my:root");
        log.info("*** VIEW TEST NODE PROPERTIES ***");
        Node nodoPrueba = myRoot.getNode(nodoPruebaName);
        log.info("** NOMBRE: " + nodoPrueba.getProperty("nombre").getString());
        log.info("*** VIEW DOCUMENT NODE PROPERTIES ***");
        Node fileNode = myRoot.getNode("\u00f1a\u00f1\u00f3");
        Node contentNode = fileNode.getNode("jcr:content");
        InputStream is = contentNode.getProperty("jcr:data").getStream();
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        log.info("** DATA: " + new String(IOUtils.toByteArray((Reader)isr)));
        isr.close();
        is.close();
        log.info("*** SAY BYE ***");
        userSession.logout();
        DummyEncoding.getSystemSession().logout();
    }

    private static void removeRepository() {
        try {
            FileUtils.deleteDirectory((File)new File(repHomeDir));
        }
        catch (IOException e) {
            System.err.println("No previous repo");
        }
    }

    public static Session login(String user, String pass) throws NamingException, RepositoryException, LoginException, NoSuchWorkspaceException {
        Repository repository = DummyEncoding.getRepository();
        Session session = repository.login((Credentials)new SimpleCredentials(user, pass.toCharArray()), null);
        log.debug("Session: " + session);
        return session;
    }

    public static Repository getRepository() throws RepositoryException {
        if (repository == null) {
            String repositoryConfig = "repository2.xml";
            String repositoryHome = "repotest2";
            RepositoryConfig config = RepositoryConfig.create((String)repositoryConfig, (String)repositoryHome);
            repository = RepositoryImpl.create((RepositoryConfig)config);
            log.debug("*** System repository created " + repository);
        }
        return repository;
    }

    public static Session getSystemSession() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (systemSession == null) {
            systemSession = repository.login((Credentials)new SimpleCredentials("system", "".toCharArray()), null);
            log.debug("*** System user created " + systemSession.getUserID());
        }
        return systemSession;
    }

    public static Node createRepository() throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException, ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, InvalidItemStateException {
        DummyEncoding.getRepository();
        Session systemSession = DummyEncoding.getSystemSession();
        Workspace ws = systemSession.getWorkspace();
        ws.getNamespaceRegistry().registerNamespace("my", "http://www.guia-ubuntu.org/1.0");
        Node root = systemSession.getRootNode();
        Node okmRoot = root.addNode("my:root");
        okmRoot.addMixin("mix:referenceable");
        systemSession.save();
        log.info("****** Repository created *******");
        return okmRoot;
    }
}

