/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Hashtable;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.jndi.RegistryHelper;

public class ExportImportTest {
    public static void main(String[] args) throws Exception {
        ExportImportTest.removeRepository("repo_old");
        ExportImportTest.removeRepository("repo_new");
        Session seOld = ExportImportTest.getSession("repo_old");
        Node okmRootOld = ExportImportTest.createRoot(seOld);
        System.out.println("okmRootNew: " + okmRootOld.getUUID());
        Node fileOld = okmRootOld.addNode("prueba", "nt:file");
        fileOld.addMixin("mix:referenceable");
        fileOld.addMixin("mix:lockable");
        fileOld.addMixin("mix:versionable");
        Node contentOld = fileOld.addNode("jcr:content", "nt:resource");
        contentOld.setProperty("jcr:mimeType", "text/plain");
        contentOld.setProperty("jcr:data", "En un lugar de La Mancha...");
        contentOld.setProperty("jcr:lastModified", Calendar.getInstance());
        okmRootOld.save();
        System.out.println("fileOld: " + fileOld.getUUID());
        System.out.println("contentOld: " + contentOld.getUUID());
        System.out.println("isCheckedOut: " + fileOld.isCheckedOut());
        fileOld.checkin();
        System.out.println("isCheckedOut: " + fileOld.isCheckedOut());
        System.out.println("\n ---- VERSIONS ---- ");
        VersionIterator vi = fileOld.getVersionHistory().getAllVersions();
        while (vi.hasNext()) {
            Version v = vi.nextVersion();
            System.out.println("Version Path: " + v.getPath());
            System.out.println("Version Name: " + v.getName());
        }
        System.out.println(" --------------------- \n");
        seOld.exportSystemView("/okm:root", (OutputStream)new FileOutputStream("okmRootSysView.xml"), false, false);
        seOld.exportSystemView("/jcr:system/jcr:versionStorage", (OutputStream)new FileOutputStream("versionStorageSysView.xml"), false, false);
        Session seNew = ExportImportTest.getSession("repo_new");
        seNew.getWorkspace().importXML("/", (InputStream)new FileInputStream("okmRootSysView.xml"), 2);
        seNew.getWorkspace().importXML("/jcr:system", (InputStream)new FileInputStream("versionStorageSysView.xml"), 2);
        Node okmRootNew = seNew.getRootNode().getNode("okm:root");
        System.out.println("okmRootNew: " + okmRootNew.getUUID());
        Node fileNew = okmRootNew.getNode("prueba");
        System.out.println("fileNew: " + fileNew.getUUID());
        Node contentNew = fileNew.getNode("jcr:content");
        System.out.println("contentNew: " + contentNew.getUUID());
        System.out.println("isCheckedOut: " + fileNew.isCheckedOut());
        System.out.println("\n ---- VERSIONS ---- ");
        VersionIterator vi2 = fileNew.getVersionHistory().getAllVersions();
        while (vi2.hasNext()) {
            Version v = vi2.nextVersion();
            System.out.println("Version Path: " + v.getPath());
            System.out.println("Version Name: " + v.getName());
        }
    }

    public static void removeRepository(String repHomeDir) {
        try {
            FileUtils.deleteDirectory((File)new File(repHomeDir));
        }
        catch (IOException e) {
            System.err.println("No previous repo");
        }
    }

    public static Session getSession(String repHomeDir) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory");
        env.put("java.naming.provider.url", "localhost");
        InitialContext ctx = new InitialContext(env);
        String configFile = "repositoryImpExp.xml";
        RegistryHelper.registerRepository((Context)ctx, (String)"repo", (String)configFile, (String)repHomeDir, (boolean)true);
        Repository r = (Repository)ctx.lookup("repo");
        Session session = r.login((Credentials)new SimpleCredentials("paco", "".toCharArray()), null);
        System.out.println("Session: " + session);
        return session;
    }

    public static Node createRoot(Session session) throws Exception {
        Workspace ws = session.getWorkspace();
        ws.getNamespaceRegistry().registerNamespace("okm", "http://www.pepito.org/1.0");
        Node root = session.getRootNode();
        Node okmRoot = root.addNode("okm:root", "nt:folder");
        okmRoot.addMixin("mix:referenceable");
        session.save();
        System.out.println("okm:root created.");
        return okmRoot;
    }
}

