/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.test;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyAccessManager
implements AccessManager {
    private static Logger log = LoggerFactory.getLogger(MyAccessManager.class);
    private AMContext context;
    ThreadLocal<Boolean> alreadyInsideAccessManager = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public void init(AMContext context) throws AccessDeniedException, Exception {
        log.debug("init(" + context + ")");
        this.context = context;
    }

    public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessMgr) throws AccessDeniedException, Exception {
        log.debug("init(" + context + ", " + acProvider + ", " + wspAccessMgr + ")");
        this.init(context);
    }

    public void close() throws Exception {
        log.debug("close()");
    }

    public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        log.info("canAccess(" + workspaceName + ")");
        return true;
    }

    public boolean canRead(Path itemPath) throws RepositoryException {
        log.info("canRead(" + itemPath + ")");
        return this.isGranted(itemPath, 1);
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        log.debug("checkPermission(" + id + ", " + permissions + ")");
        if (this.isGranted(id, permissions)) {
            return;
        }
        throw new AccessDeniedException("JCR permission denied!");
    }

    public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
        log.info("isGranted(" + id + ", " + permissions + ")");
        Path path = this.context.getHierarchyManager().getPath(id);
        return this.isGranted(path, this.deprecatedActionsToNewApi(permissions));
    }

    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        log.info("isGranted(" + absPath + ", " + permissions + ")");
        if (this.alreadyInsideAccessManager.get().booleanValue()) {
            log.debug("[YES inside]");
            return true;
        }
        log.debug("[NOT inside]");
        this.alreadyInsideAccessManager.set(Boolean.TRUE);
        this.alreadyInsideAccessManager.remove();
        return true;
    }

    public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
        log.info("isGranted(" + parentPath + ", " + childName + ", " + permissions + ")");
        Path p = PathFactoryImpl.getInstance().create(parentPath, childName, true);
        return this.isGranted(p, permissions);
    }

    private int deprecatedActionsToNewApi(int actions) {
        boolean read = (actions & 1) != 0;
        boolean write = (actions & 2) != 0;
        boolean remove = (actions & 4) != 0;
        int result = 0;
        if (read) {
            result |= 1;
        }
        if (write) {
            result |= 4;
            result |= 2;
        }
        if (remove) {
            result |= 8;
            result |= 0x10;
        }
        return result;
    }

    private String actionsToString(int actions) {
        StringBuilder sb = new StringBuilder();
        if (actions != 0) {
            if ((actions & 4) != 0) {
                sb.append("add_node ");
            }
            if ((actions & 1) != 0) {
                sb.append("read ");
            }
            if ((actions & 8) != 0) {
                sb.append("remove_node ");
            }
            if ((actions & 0x10) != 0) {
                sb.append("remove_property ");
            }
            if ((actions & 2) != 0) {
                sb.append("set_property ");
            }
        }
        return sb.toString();
    }

    public void checkPermission(Path arg0, int arg1) throws AccessDeniedException, RepositoryException {
    }
}

