/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.test;

import com.openkm.test.DummyLockAccessDenied;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyAccessManagerLockAccessDenied
implements AccessManager {
    private static Logger log = LoggerFactory.getLogger(MyAccessManagerLockAccessDenied.class);
    private Subject subject = null;
    private HierarchyManager hierMgr = null;
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int REMOVE = 4;
    public static boolean CAN_WRITE = true;

    public void init(AMContext context) throws AccessDeniedException, Exception {
        log.debug("init(" + context + ")");
        this.subject = context.getSubject();
        log.debug("##### " + this.subject.getPrincipals());
        this.hierMgr = context.getHierarchyManager();
        log.debug("init: void");
    }

    public void close() throws Exception {
        log.debug("close()");
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        log.debug("checkPermission()");
    }

    public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
        log.debug("isGranted(" + this.subject.getPrincipals() + ", " + id + ", " + (permissions == 1 ? "READ" : (permissions == 2 ? "WRITE" : (permissions == 4 ? "REMOVE" : "NONE"))) + ")");
        boolean access = false;
        Session systemSession = DummyLockAccessDenied.getSystemSession();
        if (this.subject.getPrincipals().contains(new UserPrincipal(systemSession.getUserID()))) {
            access = true;
        } else {
            NodeId nodeId = null;
            log.debug(this.subject.getPrincipals() + " Item Id: " + id);
            try {
                log.debug(this.subject.getPrincipals() + " Item Path: " + this.hierMgr.getPath(id));
            }
            catch (ItemNotFoundException e) {
                log.warn(this.subject.getPrincipals() + " hierMgr.getPath() > ItemNotFoundException: " + e.getMessage());
            }
            if (id instanceof NodeId) {
                nodeId = (NodeId)id;
                log.debug(this.subject.getPrincipals() + " This is a NODE");
            } else {
                PropertyId propertyId = (PropertyId)id;
                nodeId = propertyId.getParentId();
                log.debug(this.subject.getPrincipals() + " This is a PROPERTY");
            }
            if (this.hierMgr.getPath((ItemId)nodeId).denotesRoot()) {
                access = true;
            } else {
                NodeImpl node = null;
                try {
                    node = ((SessionImpl)systemSession).getNodeById(nodeId);
                }
                catch (ItemNotFoundException e1) {
                    log.warn(this.subject.getPrincipals() + " systemSession.getNodeById() > ItemNotFoundException: " + e1.getMessage());
                }
                if (node == null) {
                    access = true;
                } else {
                    log.debug(this.subject.getPrincipals() + " Node Name: " + node.getPath());
                    log.debug(this.subject.getPrincipals() + " Node Type: " + node.getPrimaryNodeType().getName());
                    if (permissions == 1) {
                        PropertyIterator pi = node.getProperties();
                        while (pi.hasNext()) {
                            Property property = pi.nextProperty();
                            log.debug("Property: " + property.getName());
                        }
                        access = true;
                    } else if (permissions == 2 || permissions == 4) {
                        PropertyIterator pi = node.getProperties();
                        while (pi.hasNext()) {
                            Property property = pi.nextProperty();
                            log.debug("Property: " + property.getName());
                        }
                        if (CAN_WRITE) {
                            access = true;
                        }
                    }
                }
            }
        }
        try {
            log.debug(this.subject.getPrincipals() + " Path: " + this.hierMgr.getPath(id));
        }
        catch (ItemNotFoundException e) {
            log.warn(this.subject.getPrincipals() + " hierMgr.getPath() > ItemNotFoundException: " + e.getMessage());
        }
        log.debug(this.subject.getPrincipals() + " isGranted " + (permissions == 1 ? "READ" : (permissions == 2 ? "WRITE" : (permissions == 4 ? "REMOVE" : "NONE"))) + ": " + access);
        log.debug("-------------------------------------");
        return access;
    }

    public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        boolean access = true;
        log.debug("canAccess(" + workspaceName + ")");
        log.debug("canAccess: " + access);
        return access;
    }

    public boolean canRead(Path arg0) throws RepositoryException {
        return false;
    }

    public void init(AMContext arg0, AccessControlProvider arg1, WorkspaceAccessManager arg2) throws AccessDeniedException, Exception {
    }

    public boolean isGranted(Path arg0, int arg1) throws RepositoryException {
        return false;
    }

    public boolean isGranted(Path arg0, Name arg1, int arg2) throws RepositoryException {
        return false;
    }

    public void checkPermission(Path arg0, int arg1) throws AccessDeniedException, RepositoryException {
    }
}

