/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveUtils {
    private static Logger log = LoggerFactory.getLogger(ArchiveUtils.class);

    public static void createZip(File path, String root, OutputStream os) throws IOException {
        log.debug("createZip({}, {}, {})", new Object[]{path, root, os});
        if (!path.exists() || !path.canRead()) {
            throw new IOException("Can't access " + path);
        }
        ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(os);
        zaos.setComment("Generated by OpenKM");
        zaos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
        zaos.setUseLanguageEncodingFlag(true);
        zaos.setFallbackToUTF8(true);
        zaos.setEncoding("UTF-8");
        ZipArchiveEntry zae = new ZipArchiveEntry(root + "/");
        zaos.putArchiveEntry((ArchiveEntry)zae);
        zaos.closeArchiveEntry();
        ArchiveUtils.createZipHelper(path, zaos, root);
        zaos.flush();
        zaos.finish();
        zaos.close();
        log.debug("createZip: void");
    }

    private static void createZipHelper(File fs, ZipArchiveOutputStream zaos, String zePath) throws IOException {
        log.debug("createZipHelper({}, {}, {})", new Object[]{fs, zaos, zePath});
        File[] files = fs.listFiles();
        for (int i = 0; i < files.length; ++i) {
            ZipArchiveEntry zae;
            if (files[i].isDirectory()) {
                log.debug("DIRECTORY {}", (Object)files[i]);
                zae = new ZipArchiveEntry(zePath + "/" + files[i].getName() + "/");
                zaos.putArchiveEntry((ArchiveEntry)zae);
                zaos.closeArchiveEntry();
                ArchiveUtils.createZipHelper(files[i], zaos, zePath + "/" + files[i].getName());
                continue;
            }
            log.debug("FILE {}", (Object)files[i]);
            zae = new ZipArchiveEntry(zePath + "/" + files[i].getName());
            zaos.putArchiveEntry((ArchiveEntry)zae);
            FileInputStream fis = new FileInputStream(files[i]);
            IOUtils.copy((InputStream)fis, (OutputStream)zaos);
            fis.close();
            zaos.closeArchiveEntry();
        }
        log.debug("createZipHelper: void");
    }

    public static void createJar(File path, String root, OutputStream os) throws IOException {
        log.debug("createJar({}, {}, {})", new Object[]{path, root, os});
        if (!path.exists() || !path.canRead()) {
            throw new IOException("Can't access " + path);
        }
        JarArchiveOutputStream jaos = new JarArchiveOutputStream(os);
        jaos.setComment("Generated by OpenKM");
        jaos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
        jaos.setUseLanguageEncodingFlag(true);
        jaos.setFallbackToUTF8(true);
        jaos.setEncoding("UTF-8");
        JarArchiveEntry jae = new JarArchiveEntry(root + "/");
        jaos.putArchiveEntry((ArchiveEntry)jae);
        jaos.closeArchiveEntry();
        ArchiveUtils.createJarHelper(path, jaos, root);
        jaos.flush();
        jaos.finish();
        jaos.close();
        log.debug("createJar: void");
    }

    private static void createJarHelper(File fs, JarArchiveOutputStream jaos, String zePath) throws IOException {
        log.debug("createJarHelper({}, {}, {})", new Object[]{fs, jaos, zePath});
        File[] files = fs.listFiles();
        for (int i = 0; i < files.length; ++i) {
            JarArchiveEntry jae;
            if (files[i].isDirectory()) {
                log.debug("DIRECTORY {}", (Object)files[i]);
                jae = new JarArchiveEntry(zePath + "/" + files[i].getName() + "/");
                jaos.putArchiveEntry((ArchiveEntry)jae);
                jaos.closeArchiveEntry();
                ArchiveUtils.createJarHelper(files[i], jaos, zePath + "/" + files[i].getName());
                continue;
            }
            log.debug("FILE {}", (Object)files[i]);
            jae = new JarArchiveEntry(zePath + "/" + files[i].getName());
            jaos.putArchiveEntry((ArchiveEntry)jae);
            FileInputStream fis = new FileInputStream(files[i]);
            IOUtils.copy((InputStream)fis, (OutputStream)jaos);
            fis.close();
            jaos.closeArchiveEntry();
        }
        log.debug("createJarHelper: void");
    }

    public static byte[] readFileFromZip(ZipInputStream zis, String filename) throws IOException {
        ZipEntry zi = null;
        byte[] content = null;
        while ((zi = zis.getNextEntry()) != null) {
            if (!filename.equals(zi.getName())) continue;
            IOUtils.toByteArray((InputStream)zis);
            break;
        }
        return content;
    }

    public static InputStream getInputStreamFromZip(ZipInputStream zis, String filename) throws IOException {
        ZipEntry zi = null;
        ZipInputStream is = null;
        while ((zi = zis.getNextEntry()) != null) {
            if (!filename.equals(zi.getName())) continue;
            is = zis;
            break;
        }
        return is;
    }
}

