/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.FileSizeExceededException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UnsupportedMimeTypeException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VirusDetectedException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.module.base.BaseDocumentModule;
import com.openkm.module.base.BaseFolderModule;
import com.openkm.module.direct.DirectDocumentModule;
import com.openkm.module.direct.DirectFolderModule;
import com.openkm.util.FormatUtil;
import com.openkm.util.markov.Generator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.InputMismatchException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Benchmark {
    private static Logger log = LoggerFactory.getLogger(Benchmark.class);
    private static final String SEED = Config.HOME_DIR + File.separator + "benchmark.txt";
    private static final int PARAGRAPH = 250;
    private static final int LINE_WIDTH = 80;
    private static final int TOTAL_CHARS = 500;
    private static final int MAX_DOCUMENTS = 12;
    private static final int MAX_FOLDERS = 4;
    private static final int MAX_DEPTH = 3;
    private Generator gen = null;
    private int maxDocuments = 0;
    private int maxFolders = 0;
    private int maxDepth = 0;
    private int totalFolders = 0;
    private int totalDocuments = 0;
    private long totalSize = 0L;
    private int row = 0;

    public static void main(String[] args) {
    }

    public Benchmark() throws IOException {
        this.maxDocuments = 12;
        this.maxFolders = 4;
        this.maxDepth = 3;
        FileInputStream fis = new FileInputStream(SEED);
        this.gen = new Generator(fis);
        fis.close();
    }

    public Benchmark(int maxDocuments, int maxFolders, int maxDepth) throws IOException {
        this.maxDocuments = maxDocuments;
        this.maxFolders = maxFolders;
        this.maxDepth = maxDepth;
        FileInputStream fis = new FileInputStream(SEED);
        this.gen = new Generator(fis);
        fis.close();
    }

    public Benchmark(int maxDocuments, int maxFolders, int maxDepth, InputStream is) throws IOException {
        this.maxDocuments = maxDocuments;
        this.maxFolders = maxFolders;
        this.maxDepth = maxDepth;
        this.gen = new Generator(is);
    }

    public int getMaxDocuments() {
        return this.maxDocuments;
    }

    public int getMaxFolders() {
        return this.maxFolders;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getTotalFolders() {
        return this.totalFolders;
    }

    public int getTotalDocuments() {
        return this.totalDocuments;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int calculateFolders() {
        int nodesAtLevel = 1;
        int total = 0;
        for (int i = 1; i <= this.maxDepth; ++i) {
            total += (nodesAtLevel *= this.maxFolders);
        }
        return total;
    }

    public int calculateDocuments() {
        int nodesAtLevel = 1;
        int total = 0;
        for (int i = 1; i <= this.maxDepth; ++i) {
            total += (nodesAtLevel *= this.maxFolders);
        }
        return total * this.maxDocuments;
    }

    public long runCalibration() throws InputMismatchException, IOException {
        int ITERATIONS = 10;
        long total = 0L;
        for (int i = 0; i < 10; ++i) {
            long calBegin = System.currentTimeMillis();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.gen.generateText(250, 80, 500, baos);
            baos.close();
            long calEnd = System.currentTimeMillis();
            total = calEnd - calBegin;
        }
        log.debug("Calibration: {} ms", (Object)(total / 10L));
        return total / 10L;
    }

    public void okmApiHighPopulate(String token, Folder root, PrintWriter out, PrintWriter res) throws IOException, InputMismatchException, com.openkm.core.ItemExistsException, PathNotFoundException, UserQuotaExceededException, AccessDeniedException, UnsupportedMimeTypeException, FileSizeExceededException, VirusDetectedException, RepositoryException, DatabaseException, ExtensionException {
        long begin = System.currentTimeMillis();
        this.okmApiHighPopulateHelper(token, root, out, res, this.gen, 0);
        long end = System.currentTimeMillis();
        String elapse = FormatUtil.formatSeconds(end - begin);
        log.debug("Total Time: {} - Folders: {}, Documents: {}", new Object[]{elapse, this.totalFolders, this.totalDocuments});
    }

    private void okmApiHighPopulateHelper(String token, Folder root, PrintWriter out, PrintWriter res, Generator gen, int depth) throws InputMismatchException, IOException, com.openkm.core.ItemExistsException, PathNotFoundException, UserQuotaExceededException, AccessDeniedException, UnsupportedMimeTypeException, FileSizeExceededException, VirusDetectedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("okmApiHighPopulateHelper({}, {}, {}, {})", new Object[]{token, root, gen, depth});
        if (depth < this.maxDepth) {
            for (int i = 0; i < this.maxFolders; ++i) {
                long begin = System.currentTimeMillis();
                Folder fld = new Folder();
                fld.setPath(root.getPath() + "/" + System.currentTimeMillis());
                fld = new DirectFolderModule().create(token, fld);
                ++this.totalFolders;
                log.debug("At depth {}, created folder {}", (Object)depth, (Object)fld.getPath());
                for (int j = 0; j < this.maxDocuments; ++j) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    gen.generateText(250, 80, 500, baos);
                    baos.close();
                    this.totalSize += (long)baos.size();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    Document doc = new Document();
                    doc.setMimeType("text/plain");
                    doc.setPath(fld.getPath() + "/" + System.currentTimeMillis() + ".txt");
                    new DirectDocumentModule().create(token, doc, bais);
                    ++this.totalDocuments;
                }
                long end = System.currentTimeMillis();
                String elapse = FormatUtil.formatSeconds(end - begin);
                log.debug("Partial Time: {} - Folders: {}, Documents: {}", new Object[]{elapse, this.totalFolders, this.totalDocuments});
                out.print("<tr class=\"" + (this.row++ % 2 == 0 ? "even" : "odd") + "\">");
                out.print("<td>" + FormatUtil.formatDate(Calendar.getInstance()) + "</td>");
                out.print("<td>" + elapse + "</td>");
                out.print("<td>" + (end - begin) + "</td>");
                out.print("<td>" + this.totalFolders + "</td>");
                out.print("<td>" + this.totalDocuments + "</td>");
                out.print("<td>" + FormatUtil.formatSize(this.totalSize) + "</td>");
                out.println("</tr>");
                out.flush();
                res.print("\"" + FormatUtil.formatDate(Calendar.getInstance()) + "\",");
                res.print("\"" + elapse + "\",");
                res.print("\"" + (end - begin) + "\",");
                res.print("\"" + this.totalFolders + "\",");
                res.print("\"" + this.totalDocuments + "\",");
                res.print("\"" + FormatUtil.formatSize(this.totalSize) + "\"\n");
                res.flush();
                this.okmApiHighPopulateHelper(token, fld, out, res, gen, depth + 1);
            }
        } else {
            log.debug("Max depth reached: {}", (Object)depth);
        }
    }

    public void okmApiLowPopulate(Session session, Node root, PrintWriter out, PrintWriter res) throws ItemExistsException, javax.jcr.PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, javax.jcr.RepositoryException, InputMismatchException, IOException, DatabaseException, UserQuotaExceededException {
        long begin = System.currentTimeMillis();
        this.okmApiLowPopulateHelper(session, root, out, res, this.gen, 0);
        long end = System.currentTimeMillis();
        String elapse = FormatUtil.formatSeconds(end - begin);
        log.debug("Total Time: {} - Folders: {}, Documents: {}", new Object[]{elapse, this.totalFolders, this.totalDocuments});
    }

    private void okmApiLowPopulateHelper(Session session, Node root, PrintWriter out, PrintWriter res, Generator gen, int depth) throws ItemExistsException, javax.jcr.PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, javax.jcr.RepositoryException, InputMismatchException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("okmApiLowPopulateHelper({}, {}, {}, {})", new Object[]{session, root, gen, depth});
        if (depth < this.maxDepth) {
            for (int i = 0; i < this.maxFolders; ++i) {
                long begin = System.currentTimeMillis();
                Node fld = BaseFolderModule.create(session, root, Long.toString(System.currentTimeMillis()));
                ++this.totalFolders;
                log.debug("At depth {}, created folder {}", (Object)depth, (Object)fld.getPath());
                for (int j = 0; j < this.maxDocuments; ++j) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    gen.generateText(250, 80, 500, baos);
                    baos.close();
                    this.totalSize += (long)baos.size();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    BaseDocumentModule.create(session, fld, System.currentTimeMillis() + ".txt", null, "text/plain", new String[0], bais);
                    ++this.totalDocuments;
                }
                long end = System.currentTimeMillis();
                String elapse = FormatUtil.formatSeconds(end - begin);
                log.debug("Partial Time: {} - Folders: {}, Documents: {}", new Object[]{elapse, this.totalFolders, this.totalDocuments});
                out.print("<tr class=\"" + (this.row++ % 2 == 0 ? "even" : "odd") + "\">");
                out.print("<td>" + FormatUtil.formatDate(Calendar.getInstance()) + "</td>");
                out.print("<td>" + elapse + "</td>");
                out.print("<td>" + (end - begin) + "</td>");
                out.print("<td>" + this.totalFolders + "</td>");
                out.print("<td>" + this.totalDocuments + "</td>");
                out.print("<td>" + FormatUtil.formatSize(this.totalSize) + "</td>");
                out.println("</tr>");
                out.flush();
                res.print("\"" + FormatUtil.formatDate(Calendar.getInstance()) + "\",");
                res.print("\"" + elapse + "\",");
                res.print("\"" + (end - begin) + "\",");
                res.print("\"" + this.totalFolders + "\",");
                res.print("\"" + this.totalDocuments + "\",");
                res.print("\"" + FormatUtil.formatSize(this.totalSize) + "\"\n");
                res.flush();
                this.okmApiLowPopulateHelper(session, fld, out, res, gen, depth + 1);
            }
        } else {
            log.debug("Max depth reached: {}", (Object)depth);
        }
    }

    public void okmRawPopulate(Session session, Node root, PrintWriter out, PrintWriter res) throws ItemExistsException, javax.jcr.PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, javax.jcr.RepositoryException, InputMismatchException, IOException {
        long begin = System.currentTimeMillis();
        this.okmRawPopulateHelper(session, root, out, res, this.gen, 0);
        long end = System.currentTimeMillis();
        String elapse = FormatUtil.formatSeconds(end - begin);
        log.debug("Total Time: {} - Folders: {}, Documents: {}", new Object[]{elapse, this.totalFolders, this.totalDocuments});
    }

    private void okmRawPopulateHelper(Session session, Node root, PrintWriter out, PrintWriter res, Generator gen, int depth) throws ItemExistsException, javax.jcr.PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, javax.jcr.RepositoryException, InputMismatchException, IOException {
        log.debug("okmRawPopulateHelper({}, {}, {}, {})", new Object[]{session, root, gen, depth});
        if (depth < this.maxDepth) {
            for (int i = 0; i < this.maxFolders; ++i) {
                long begin = System.currentTimeMillis();
                String fldName = Long.toString(System.currentTimeMillis());
                Node fldNode = root.addNode(fldName, "okm:folder");
                fldNode.setProperty("okm:author", session.getUserID());
                fldNode.setProperty("okm:name", fldName);
                fldNode.setProperty("okm:authUsersRead", new String[]{session.getUserID()});
                fldNode.setProperty("okm:authUsersWrite", new String[]{session.getUserID()});
                fldNode.setProperty("okm:authUsersDelete", new String[]{session.getUserID()});
                fldNode.setProperty("okm:authUsersSecurity", new String[]{session.getUserID()});
                fldNode.setProperty("okm:authRolesRead", new String[0]);
                fldNode.setProperty("okm:authRolesWrite", new String[0]);
                fldNode.setProperty("okm:authRolesDelete", new String[0]);
                fldNode.setProperty("okm:authRolesSecurity", new String[0]);
                root.save();
                ++this.totalFolders;
                log.debug("At depth {}, created folder {}", (Object)depth, (Object)fldNode.getPath());
                for (int j = 0; j < this.maxDocuments; ++j) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    gen.generateText(250, 80, 500, baos);
                    baos.close();
                    this.totalSize += (long)baos.size();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    String docName = System.currentTimeMillis() + ".txt";
                    Node docNode = fldNode.addNode(docName, "okm:document");
                    docNode.setProperty("okm:keywords", new String[0]);
                    docNode.setProperty("okm:categories", new String[0], 9);
                    docNode.setProperty("okm:author", session.getUserID());
                    docNode.setProperty("okm:name", docName);
                    docNode.setProperty("okm:authUsersRead", new String[]{session.getUserID()});
                    docNode.setProperty("okm:authUsersWrite", new String[]{session.getUserID()});
                    docNode.setProperty("okm:authUsersDelete", new String[]{session.getUserID()});
                    docNode.setProperty("okm:authUsersSecurity", new String[]{session.getUserID()});
                    docNode.setProperty("okm:authRolesRead", new String[]{session.getUserID()});
                    docNode.setProperty("okm:authRolesWrite", new String[]{session.getUserID()});
                    docNode.setProperty("okm:authRolesDelete", new String[]{session.getUserID()});
                    docNode.setProperty("okm:authRolesSecurity", new String[]{session.getUserID()});
                    Node contNode = docNode.addNode("okm:content", "okm:resource");
                    contNode.setProperty("okm:size", (long)bais.available());
                    contNode.setProperty("okm:author", session.getUserID());
                    contNode.setProperty("okm:versionComment", "");
                    contNode.setProperty("jcr:mimeType", "text/plain");
                    contNode.setProperty("jcr:encoding", "UTF-8");
                    contNode.setProperty("jcr:data", (InputStream)bais);
                    contNode.setProperty("jcr:lastModified", Calendar.getInstance());
                    fldNode.save();
                    contNode.checkin();
                    ++this.totalDocuments;
                }
                long end = System.currentTimeMillis();
                String elapse = FormatUtil.formatSeconds(end - begin);
                log.debug("Partial Time: {} - Folders: {}, Documents: {}", new Object[]{elapse, this.totalFolders, this.totalDocuments});
                out.print("<tr class=\"" + (this.row++ % 2 == 0 ? "even" : "odd") + "\">");
                out.print("<td>" + FormatUtil.formatDate(Calendar.getInstance()) + "</td>");
                out.print("<td>" + elapse + "</td>");
                out.print("<td>" + (end - begin) + "</td>");
                out.print("<td>" + this.totalFolders + "</td>");
                out.print("<td>" + this.totalDocuments + "</td>");
                out.print("<td>" + FormatUtil.formatSize(this.totalSize) + "</td>");
                out.println("</tr>");
                out.flush();
                res.print("\"" + FormatUtil.formatDate(Calendar.getInstance()) + "\",");
                res.print("\"" + elapse + "\",");
                res.print("\"" + (end - begin) + "\",");
                res.print("\"" + this.totalFolders + "\",");
                res.print("\"" + this.totalDocuments + "\",");
                res.print("\"" + FormatUtil.formatSize(this.totalSize) + "\"\n");
                res.flush();
                this.okmRawPopulateHelper(session, fldNode, out, res, gen, depth + 1);
            }
        } else {
            log.debug("Max depth reached: {}", (Object)depth);
        }
    }

    public void jcrPopulate(Session session, Node root, PrintWriter out, PrintWriter res) throws IOException, ItemExistsException, javax.jcr.PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, javax.jcr.RepositoryException, InputMismatchException, IOException {
        long begin = System.currentTimeMillis();
        this.jcrPopulateHelper(session, root, out, res, this.gen, 0);
        long end = System.currentTimeMillis();
        String elapse = FormatUtil.formatSeconds(end - begin);
        log.debug("Total Time: {} - Folders: {}, Documents: {}", new Object[]{elapse, this.totalFolders, this.totalDocuments});
    }

    private void jcrPopulateHelper(Session session, Node root, PrintWriter out, PrintWriter res, Generator gen, int depth) throws ItemExistsException, javax.jcr.PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, javax.jcr.RepositoryException, InputMismatchException, IOException {
        log.debug("jcrPopulateHelper({}, {}, {}, {})", new Object[]{session, root, gen, depth});
        if (depth < this.maxDepth) {
            for (int i = 0; i < this.maxFolders; ++i) {
                long begin = System.currentTimeMillis();
                Node fldNode = root.addNode(Long.toString(System.currentTimeMillis()), "nt:folder");
                fldNode.addMixin("mix:referenceable");
                root.save();
                ++this.totalFolders;
                log.debug("At depth {}, created folder {}", (Object)depth, (Object)fldNode.getPath());
                for (int j = 0; j < this.maxDocuments; ++j) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    gen.generateText(250, 80, 500, baos);
                    baos.close();
                    this.totalSize += (long)baos.size();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    Node docNode = fldNode.addNode(System.currentTimeMillis() + ".txt", "nt:file");
                    docNode.addMixin("mix:referenceable");
                    Node resNode = docNode.addNode("jcr:content", "nt:resource");
                    resNode.setProperty("jcr:mimeType", "text/plain");
                    resNode.setProperty("jcr:encoding", "UTF-8");
                    resNode.setProperty("jcr:data", (InputStream)bais);
                    resNode.setProperty("jcr:lastModified", Calendar.getInstance());
                    fldNode.save();
                    ++this.totalDocuments;
                }
                long end = System.currentTimeMillis();
                String elapse = FormatUtil.formatSeconds(end - begin);
                log.debug("Partial Time: {} - Folders: {}, Documents: {}", new Object[]{elapse, this.totalFolders, this.totalDocuments});
                out.print("<tr class=\"" + (this.row++ % 2 == 0 ? "even" : "odd") + "\">");
                out.print("<td>" + FormatUtil.formatDate(Calendar.getInstance()) + "</td>");
                out.print("<td>" + elapse + "</td>");
                out.print("<td>" + (end - begin) + "</td>");
                out.print("<td>" + this.totalFolders + "</td>");
                out.print("<td>" + this.totalDocuments + "</td>");
                out.print("<td>" + FormatUtil.formatSize(this.totalSize) + "</td>");
                out.println("</tr>");
                out.flush();
                res.print("\"" + FormatUtil.formatDate(Calendar.getInstance()) + "\",");
                res.print("\"" + elapse + "\",");
                res.print("\"" + (end - begin) + "\",");
                res.print("\"" + this.totalFolders + "\",");
                res.print("\"" + this.totalDocuments + "\",");
                res.print("\"" + FormatUtil.formatSize(this.totalSize) + "\"\n");
                res.flush();
                this.jcrPopulateHelper(session, fldNode, out, res, gen, depth + 1);
            }
        } else {
            log.debug("Max depth reached: {}", (Object)depth);
        }
    }
}

