/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.SQLServerDialect;

public class DatabaseDialectAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dialectAdapter(InputStream is, String dialect) {
        StringBuilder sb;
        block12: {
            sb = new StringBuilder();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(is));
                if (Oracle10gDialect.class.getCanonicalName().equals(dialect)) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(DatabaseDialectAdapter.oracleAdapter(line)).append("\n");
                    }
                } else if (SQLServerDialect.class.getCanonicalName().equals(dialect)) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(DatabaseDialectAdapter.sqlServerAdapter(line)).append("\n");
                    }
                } else {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                }
                IOUtils.closeQuietly((Reader)br);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block12;
            }
            finally {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return sb.toString().trim();
    }

    private static String oracleAdapter(String line) {
        if (line.startsWith("INSERT INTO OKM_FORUM")) {
            return line.replaceAll("NOW\\(\\)", "SYSDATE");
        }
        return line;
    }

    private static String sqlServerAdapter(String line) {
        StringBuilder sb = new StringBuilder();
        if (line.startsWith("INSERT INTO OKM_PROFILE")) {
            sb.append("SET IDENTITY_INSERT OKM_PROFILE ON;").append("\n");
            sb.append(line).append("\n");
            sb.append("SET IDENTITY_INSERT OKM_PROFILE OFF;");
            return sb.toString();
        }
        if (line.startsWith("INSERT INTO OKM_MIME_TYPE")) {
            sb.append("SET IDENTITY_INSERT OKM_MIME_TYPE ON;").append("\n");
            sb.append(line).append("\n");
            sb.append("SET IDENTITY_INSERT OKM_MIME_TYPE OFF;");
            return sb.toString();
        }
        if (line.startsWith("INSERT INTO OKM_FORUM")) {
            sb.append("SET IDENTITY_INSERT OKM_FORUM ON;").append("\n");
            sb.append(line.replaceAll("NOW\\(\\)", "GETDATE()")).append("\n");
            sb.append("SET IDENTITY_INSERT OKM_FORUM OFF;");
            return sb.toString();
        }
        return line;
    }
}

