/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.core.DatabaseException;
import com.openkm.dao.DatabaseMetadataDAO;
import com.openkm.dao.bean.DatabaseMetadataType;
import com.openkm.dao.bean.DatabaseMetadataValue;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetadataUtils {
    private static Logger log = LoggerFactory.getLogger(DatabaseMetadataUtils.class);

    public static String buildQuery(String table, String filter, String order) throws DatabaseException {
        log.debug("buildQuery({}, {}, {})", new Object[]{table, filter, order});
        StringBuilder sb = new StringBuilder();
        String ret = null;
        sb.append("from DatabaseMetadataValue dmv where dmv.table='" + table + "'");
        if (filter != null && filter.length() > 0) {
            sb.append(" and ").append(DatabaseMetadataUtils.replaceVirtual(table, filter));
        }
        if (order != null && order.length() > 0) {
            sb.append(" order by ").append(DatabaseMetadataUtils.replaceVirtual(table, order));
        }
        ret = sb.toString();
        log.debug("buildQuery: {}", (Object)ret);
        return ret;
    }

    public static String buildQuery(String table, String filter) throws DatabaseException {
        log.debug("buildQuery({}, {})", new Object[]{table, filter});
        StringBuilder sb = new StringBuilder();
        String ret = null;
        sb.append("from DatabaseMetadataValue dmv where dmv.table='" + table + "'");
        if (filter != null && filter.length() > 0) {
            sb.append(" and ").append(DatabaseMetadataUtils.replaceVirtual(table, filter));
        }
        ret = sb.toString();
        log.debug("buildQuery: {}", (Object)ret);
        return ret;
    }

    public static String buildUpdate(String table, String values, String filter) throws DatabaseException {
        log.debug("buildUpdate({}, {}, {})", new Object[]{table, values, filter});
        StringBuilder sb = new StringBuilder();
        String ret = null;
        sb.append("update DatabaseMetadataValue dmv set");
        if (values != null && values.length() > 0) {
            sb.append(" ").append(DatabaseMetadataUtils.replaceVirtual(table, values));
        }
        sb.append(" where dmv.table='" + table + "'");
        if (filter != null && filter.length() > 0) {
            sb.append(" and ").append(DatabaseMetadataUtils.replaceVirtual(table, filter));
        }
        ret = sb.toString();
        log.debug("buildUpdate: {}", (Object)ret);
        return ret;
    }

    public static String buildDelete(String table, String filter) throws DatabaseException {
        log.debug("buildDelete({}, {})", new Object[]{table, filter});
        StringBuilder sb = new StringBuilder();
        String ret = null;
        sb.append("delete from DatabaseMetadataValue dmv where dmv.table='" + table + "'");
        if (filter != null && filter.length() > 0) {
            sb.append(" and ").append(DatabaseMetadataUtils.replaceVirtual(table, filter));
        }
        ret = sb.toString();
        log.debug("buildDelete: {}", (Object)ret);
        return ret;
    }

    public static String getString(DatabaseMetadataValue value, String column) throws DatabaseException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List<DatabaseMetadataType> types = DatabaseMetadataDAO.findAllTypes(value.getTable());
        for (DatabaseMetadataType emt : types) {
            if (!emt.getVirtualColumn().equals(column)) continue;
            return BeanUtils.getProperty((Object)value, (String)emt.getRealColumn());
        }
        return null;
    }

    public static Map<String, String> getDatabaseMetadataValueMap(DatabaseMetadataValue value) throws DatabaseException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HashMap<String, String> map = new HashMap<String, String>();
        List<DatabaseMetadataType> types = DatabaseMetadataDAO.findAllTypes(value.getTable());
        for (DatabaseMetadataType emt : types) {
            if (emt.getVirtualColumn().equals("id") || emt.getVirtualColumn().equals("table")) {
                throw new DatabaseException("Virtual column name restriction violated id or table");
            }
            map.put(emt.getVirtualColumn(), BeanUtils.getProperty((Object)value, (String)emt.getRealColumn()));
        }
        map.put("table", value.getTable());
        map.put("id", String.valueOf(value.getId()));
        return map;
    }

    public static DatabaseMetadataValue getDatabaseMetadataValueByMap(Map<String, String> map) throws DatabaseException, IllegalAccessException, InvocationTargetException {
        DatabaseMetadataValue dmv = new DatabaseMetadataValue();
        if (!map.isEmpty() && map.containsKey("table")) {
            dmv.setTable(map.get("table"));
            if (map.containsKey("id")) {
                dmv.setId(new Double(map.get("id")).longValue());
            }
            List<DatabaseMetadataType> types = DatabaseMetadataDAO.findAllTypes(dmv.getTable());
            for (DatabaseMetadataType emt : types) {
                if (emt.getVirtualColumn().equals("id") || emt.getVirtualColumn().equals("table") || !map.keySet().contains(emt.getVirtualColumn())) continue;
                BeanUtils.setProperty((Object)dmv, (String)emt.getRealColumn(), (Object)map.get(emt.getVirtualColumn()));
            }
        }
        return dmv;
    }

    public static String replaceVirtual(List<String> tables, String query) throws DatabaseException {
        String ret = query;
        for (String table : tables) {
            ret = DatabaseMetadataUtils.replaceVirtual(table, ret);
        }
        return ret;
    }

    private static String replaceVirtual(String table, String query) throws DatabaseException {
        log.debug("replaceVirtual({}, {})", new Object[]{table, query});
        String ret = "";
        if (query != null && query.length() > 0) {
            List<DatabaseMetadataType> types = DatabaseMetadataDAO.findAllTypes(table);
            for (DatabaseMetadataType emt : types) {
                String vcol = "\\$" + emt.getVirtualColumn().toLowerCase();
                query = query.replaceAll(vcol, emt.getRealColumn().toLowerCase());
            }
            ret = query;
        }
        log.debug("replaceVirtual: {}", (Object)ret);
        return ret;
    }
}

