/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TiffImage;
import com.openkm.bean.ExecutionResult;
import com.openkm.core.Config;
import com.openkm.core.ConversionException;
import com.openkm.core.DatabaseException;
import com.openkm.util.ExecutionUtils;
import com.openkm.util.FileUtils;
import com.openkm.util.FormatUtil;
import com.openkm.util.TemplateUtils;
import freemarker.template.TemplateException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.extractor.PdfTextExtractor;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocConverter {
    private static Logger log = LoggerFactory.getLogger(DocConverter.class);
    public static ArrayList<String> validOpenOffice = new ArrayList();
    public static ArrayList<String> validImageMagick = new ArrayList();
    public static ArrayList<String> validAutoCad = new ArrayList();
    private static ArrayList<String> validGhoscript = new ArrayList();
    private static ArrayList<String> validInternal = new ArrayList();
    private static DocConverter instance = null;
    private static OfficeManager officeManager = null;

    private DocConverter() {
        validOpenOffice.add("text/plain");
        validOpenOffice.add("text/html");
        validOpenOffice.add("text/csv");
        validOpenOffice.add("application/rtf");
        validOpenOffice.add("application/vnd.oasis.opendocument.text");
        validOpenOffice.add("application/vnd.oasis.opendocument.presentation");
        validOpenOffice.add("application/vnd.oasis.opendocument.spreadsheet");
        validOpenOffice.add("application/vnd.oasis.opendocument.graphics");
        validOpenOffice.add("application/vnd.oasis.opendocument.database");
        validOpenOffice.add("application/msword");
        validOpenOffice.add("application/vnd.ms-excel");
        validOpenOffice.add("application/vnd.ms-powerpoint");
        validOpenOffice.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        validOpenOffice.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        validOpenOffice.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        validGhoscript.add("application/postscript");
        validImageMagick.add("image/jpeg");
        validImageMagick.add("image/png");
        validImageMagick.add("image/gif");
        validImageMagick.add("image/bmp");
        validImageMagick.add("image/svg+xml");
        validImageMagick.add("image/x-psd");
        validAutoCad.add(Config.MIME_DXF);
        validAutoCad.add(Config.MIME_DWG);
        validInternal.add("image/tiff");
    }

    public static synchronized DocConverter getInstance() {
        if (instance == null) {
            instance = new DocConverter();
            if (!Config.SYSTEM_OPENOFFICE_PATH.equals("")) {
                log.info("*** Build Office Manager ***");
                log.info("{}={}", (Object)"system.openoffice.path", (Object)Config.SYSTEM_OPENOFFICE_PATH);
                log.info("{}={}", (Object)"system.openoffice.tasks", (Object)Config.SYSTEM_OPENOFFICE_TASKS);
                log.info("{}={}", (Object)"system.openoffice.port", (Object)Config.SYSTEM_OPENOFFICE_PORT);
                officeManager = new DefaultOfficeManagerConfiguration().setOfficeHome(Config.SYSTEM_OPENOFFICE_PATH).setMaxTasksPerProcess(Config.SYSTEM_OPENOFFICE_TASKS).setPortNumber(Config.SYSTEM_OPENOFFICE_PORT).buildOfficeManager();
            } else {
                log.warn("{} not configured", (Object)"system.openoffice.path");
                if (!Config.SYSTEM_OPENOFFICE_SERVER.equals("")) {
                    log.warn("but {} is configured", (Object)"system.openoffice.server");
                    log.info("{}={}", (Object)"system.openoffice.server", (Object)Config.SYSTEM_OPENOFFICE_SERVER);
                } else {
                    log.warn("and also {} not configured", (Object)"system.openoffice.server");
                }
            }
        }
        return instance;
    }

    public void start() {
        if (officeManager != null) {
            officeManager.start();
        }
    }

    public void stop() {
        if (officeManager != null) {
            officeManager.stop();
        }
    }

    public boolean convertibleToPdf(String from) {
        log.debug("convertibleToPdf({})", (Object)from);
        boolean ret = false;
        if (!(Config.SYSTEM_OPENOFFICE_PATH.equals("") && Config.SYSTEM_OPENOFFICE_SERVER.equals("") || !validOpenOffice.contains(from))) {
            ret = true;
        } else if (!Config.SYSTEM_IMAGEMAGICK_CONVERT.equals("") && validImageMagick.contains(from)) {
            ret = true;
        } else if (!Config.SYSTEM_GHOSTSCRIPT_PS2PDF.equals("") && validGhoscript.contains(from)) {
            ret = true;
        } else if (!Config.SYSTEM_DWG2DXF.equals("") && validAutoCad.contains(from)) {
            ret = true;
        } else if (validInternal.contains(from)) {
            ret = true;
        }
        log.debug("convertibleToPdf: {}", (Object)ret);
        return ret;
    }

    public boolean convertibleToSwf(String from) {
        log.debug("convertibleToSwf({})", (Object)from);
        boolean ret = false;
        if (!Config.SYSTEM_SWFTOOLS_PDF2SWF.equals("") && (Config.MIME_PDF.equals(from) || this.convertibleToPdf(from))) {
            ret = true;
        }
        log.debug("convertibleToSwf: {}", (Object)ret);
        return ret;
    }

    public boolean convertibleToDxf(String from) {
        log.debug("convertibleToDxf({})", (Object)from);
        boolean ret = false;
        if (!Config.SYSTEM_DWG2DXF.equals("") && validAutoCad.contains(from) || Config.MIME_DXF.equals(from)) {
            ret = true;
        }
        log.debug("convertibleToDxf: {}", (Object)ret);
        return ret;
    }

    public void convert(File inputFile, String mimeType, File outputFile) throws ConversionException {
        log.debug("convert({}, {}, {})", new Object[]{inputFile, mimeType, outputFile});
        if (Config.SYSTEM_OPENOFFICE_PATH.equals("") && Config.SYSTEM_OPENOFFICE_SERVER.equals("")) {
            throw new ConversionException("system.openoffice.path or system.openoffice.server not configured");
        }
        if (!validOpenOffice.contains(mimeType)) {
            throw new ConversionException("Invalid document conversion MIME type: " + mimeType);
        }
        try {
            if (!Config.SYSTEM_OPENOFFICE_PATH.equals("")) {
                OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
                converter.convert(inputFile, outputFile);
            } else if (!Config.SYSTEM_OPENOFFICE_SERVER.equals("")) {
                this.remoteConvert(inputFile, mimeType, outputFile);
            }
        }
        catch (OfficeException e) {
            throw new ConversionException("Error converting document: " + e.getMessage());
        }
    }

    private void remoteConvert(File inputFile, String mimeType, File outputFile) throws ConversionException {
        block8: {
            PostMethod post = new PostMethod(Config.SYSTEM_OPENOFFICE_SERVER);
            try {
                Part[] parts = new Part[]{new FilePart(inputFile.getName(), inputFile), new StringPart("src_mime", mimeType), new StringPart("dst_mime", "application/pdf")};
                post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
                HttpClient httpclient = new HttpClient();
                int rc = httpclient.executeMethod((HttpMethod)post);
                log.info("Response Code: {}", (Object)rc);
                if (rc == 200) {
                    FileOutputStream fos = new FileOutputStream(outputFile);
                    BufferedInputStream bis = new BufferedInputStream(post.getResponseBodyAsStream());
                    IOUtils.copy((InputStream)bis, (OutputStream)fos);
                    bis.close();
                    fos.close();
                    break block8;
                }
                throw new IOException("Error in conversion: " + rc);
            }
            catch (HttpException e) {
                throw new ConversionException("Http exception", e);
            }
            catch (FileNotFoundException e) {
                throw new ConversionException("File not found exeption", e);
            }
            catch (IOException e) {
                throw new ConversionException("IO exception", e);
            }
            finally {
                post.releaseConnection();
            }
        }
    }

    public void doc2pdf(File input, String mimeType, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from {} to PDF **", (Object)mimeType);
        OutputStream fos = null;
        try {
            long start = System.currentTimeMillis();
            this.convert(input, mimeType, output);
            log.debug("Elapse doc2pdf time: {}", (Object)FormatUtil.formatSeconds(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new ConversionException("Error in " + mimeType + " to PDF conversion", e);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    public void doc2txt(InputStream input, String mimeType, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from {} to TXT **", (Object)mimeType);
        File tmp = FileUtils.createTempFileFromMime(mimeType);
        FileOutputStream fos = new FileOutputStream(tmp);
        try {
            long start = System.currentTimeMillis();
            if (Config.MIME_PDF.equals(mimeType)) {
                Reader r = new PdfTextExtractor().extractText(input, mimeType, "utf-8");
                fos.close();
                fos = new FileOutputStream(output);
                IOUtils.copy((Reader)r, (OutputStream)fos);
            } else if (validOpenOffice.contains(mimeType)) {
                IOUtils.copy((InputStream)input, (OutputStream)fos);
                fos.flush();
                fos.close();
                this.convert(tmp, mimeType, output);
            }
            log.debug("Elapse doc2txt time: {}", (Object)FormatUtil.formatSeconds(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new ConversionException("Error in " + mimeType + " to TXT conversion", e);
        }
        finally {
            FileUtils.deleteQuietly(tmp);
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    public void ps2pdf(File input, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from PS to PDF **");
        OutputStream fos = null;
        String cmd = null;
        if (!input.getName().toLowerCase().endsWith(".ps")) {
            log.warn("ps2pdf conversion needs *.ps as input file");
        }
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("fileIn", input.getPath());
            hm.put("fileOut", output.getPath());
            String tpl = Config.SYSTEM_GHOSTSCRIPT_PS2PDF + " ${fileIn} ${fileOut}";
            cmd = TemplateUtils.replace("SYSTEM_GHOSTSCRIPT_PS2PDF", tpl, hm);
            ExecutionResult er = ExecutionUtils.runCmd(cmd);
            if (er.getExitValue() != 0) {
                throw new ConversionException(er.getStderr());
            }
        }
        catch (SecurityException e) {
            throw new ConversionException("Security exception executing command: " + cmd, e);
        }
        catch (InterruptedException e) {
            throw new ConversionException("Interrupted exception executing command: " + cmd, e);
        }
        catch (IOException e) {
            throw new ConversionException("IO exception executing command: " + cmd, e);
        }
        catch (TemplateException e) {
            throw new ConversionException("Template exception", e);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    public void img2pdf(File input, String mimeType, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from {} to PDF **", (Object)mimeType);
        OutputStream fos = null;
        String cmd = null;
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("fileIn", input.getPath());
            hm.put("fileOut", output.getPath());
            String tpl = Config.SYSTEM_IMAGEMAGICK_CONVERT + " ${fileIn}[0] ${fileOut}";
            cmd = TemplateUtils.replace("SYSTEM_OCR", tpl, hm);
            ExecutionResult er = ExecutionUtils.runCmd(cmd);
            if (er.getExitValue() != 0) {
                throw new ConversionException(er.getStderr());
            }
        }
        catch (SecurityException e) {
            throw new ConversionException("Security exception executing command: " + cmd, e);
        }
        catch (InterruptedException e) {
            throw new ConversionException("Interrupted exception executing command: " + cmd, e);
        }
        catch (IOException e) {
            throw new ConversionException("IO exception executing command: " + cmd, e);
        }
        catch (TemplateException e) {
            throw new ConversionException("Template exception", e);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    public void cad2pdf(File input, String mimeType, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from {} to PDF **", (Object)mimeType);
        String cmd = null;
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("fileIn", input.getPath());
            hm.put("fileOut", output.getPath());
            String tpl = Config.SYSTEM_DWG2DXF + " /r /ad /lw 1 /f 105 /d ${fileOut} ${fileIn}";
            cmd = TemplateUtils.replace("SYSTEM_DWG2DXF", tpl, hm);
            ExecutionResult er = ExecutionUtils.runCmd(cmd);
            if (er.getExitValue() != 0) {
                throw new ConversionException(er.getStderr());
            }
        }
        catch (SecurityException e) {
            throw new ConversionException("Security exception executing command: " + cmd, e);
        }
        catch (InterruptedException e) {
            throw new ConversionException("Interrupted exception executing command: " + cmd, e);
        }
        catch (IOException e) {
            throw new ConversionException("IO exception executing command: " + cmd, e);
        }
        catch (TemplateException e) {
            throw new ConversionException("Template exception", e);
        }
    }

    public void html2pdf(InputStream is, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from HTML to PDF **");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
            Document doc = new Document(PageSize.A4);
            PdfWriter.getInstance((Document)doc, (OutputStream)fos);
            doc.open();
            HTMLWorker html = new HTMLWorker((DocListener)doc);
            html.parse((Reader)new InputStreamReader(is));
            doc.close();
        }
        catch (DocumentException e) {
            try {
                throw new ConversionException("Exception in conversion: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public void txt2pdf(InputStream is, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from TXT to PDF **");
        FileOutputStream fos = null;
        String line = null;
        try {
            fos = new FileOutputStream(output);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            Document doc = new Document(PageSize.A4);
            PdfWriter.getInstance((Document)doc, (OutputStream)fos);
            doc.open();
            while ((line = br.readLine()) != null) {
                doc.add((Element)new Paragraph(12.0f, line));
            }
            doc.close();
        }
        catch (DocumentException e) {
            try {
                throw new ConversionException("Exception in conversion: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public void pdf2swf(File input, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from PDF to SWF **");
        Reader stdout = null;
        String cmd = null;
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("fileIn", input.getPath());
            hm.put("fileOut", output.getPath());
            cmd = TemplateUtils.replace("SYSTEM_PDF2SWF", Config.SYSTEM_SWFTOOLS_PDF2SWF, hm);
            ExecutionResult er = ExecutionUtils.runCmd(cmd);
            if (er.getExitValue() != 0) {
                throw new ConversionException(er.getStderr());
            }
        }
        catch (SecurityException e) {
            throw new ConversionException("Security exception executing command: " + cmd, e);
        }
        catch (InterruptedException e) {
            throw new ConversionException("Interrupted exception executing command: " + cmd, e);
        }
        catch (IOException e) {
            throw new ConversionException("IO exception executing command: " + cmd, e);
        }
        catch (TemplateException e) {
            throw new ConversionException("Template exception", e);
        }
        finally {
            IOUtils.closeQuietly(stdout);
        }
    }

    public void pdf2img(File input, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from PDF to IMG **");
        File tmpDir = FileUtils.createTempDir();
        String cmd = null;
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("fileIn", input.getPath());
            hm.put("fileOut", tmpDir + File.separator + "out.jpg");
            String tpl = Config.SYSTEM_IMAGEMAGICK_CONVERT + " -bordercolor #666 -border 2x2 ${fileIn} ${fileOut}";
            cmd = TemplateUtils.replace("SYSTEM_IMG2PDF", tpl, hm);
            ExecutionResult er = ExecutionUtils.runCmd(cmd);
            if (er.getExitValue() != 0) {
                throw new ConversionException(er.getStderr());
            }
            hm = new HashMap();
            StringBuilder sb = new StringBuilder();
            File[] files = tmpDir.listFiles();
            Arrays.sort(files, new FileOrderComparator());
            for (File f : files) {
                sb.append(f.getPath()).append(" ");
            }
            hm.put("fileIn", sb.toString());
            hm.put("fileOut", output.getPath());
            tpl = Config.SYSTEM_IMAGEMAGICK_CONVERT + " ${fileIn}-append ${fileOut}";
            cmd = TemplateUtils.replace("SYSTEM_IMG2PDF", tpl, hm);
            er = ExecutionUtils.runCmd(cmd);
            if (er.getExitValue() != 0) {
                throw new ConversionException(er.getStderr());
            }
        }
        catch (SecurityException e) {
            throw new ConversionException("Security exception executing command: " + cmd, e);
        }
        catch (InterruptedException e) {
            throw new ConversionException("Interrupted exception executing command: " + cmd, e);
        }
        catch (IOException e) {
            throw new ConversionException("IO exception executing command: " + cmd, e);
        }
        catch (TemplateException e) {
            throw new ConversionException("Template exception", e);
        }
        finally {
            org.apache.commons.io.FileUtils.deleteQuietly((File)tmpDir);
        }
    }

    public void tiff2pdf(File input, File output) throws ConversionException {
        RandomAccessFileOrArray ra = null;
        Document doc = null;
        try {
            doc = new Document();
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(output));
            doc.open();
            PdfContentByte cb = writer.getDirectContent();
            ra = new RandomAccessFileOrArray(input.getPath());
            int comps = TiffImage.getNumberOfPages((RandomAccessFileOrArray)ra);
            for (int c = 0; c < comps; ++c) {
                Image img = TiffImage.getTiffImage((RandomAccessFileOrArray)ra, (int)(c + 1));
                if (img == null) continue;
                log.debug("tiff2pdf - page {}", (Object)(c + 1));
                if (img.getScaledWidth() > 500.0f || img.getScaledHeight() > 700.0f) {
                    img.scaleToFit(500.0f, 700.0f);
                }
                img.setAbsolutePosition(20.0f, 20.0f);
                cb.addImage(img);
                doc.newPage();
            }
        }
        catch (FileNotFoundException e) {
            throw new ConversionException("File not found: " + e.getMessage(), e);
        }
        catch (DocumentException e) {
            throw new ConversionException("Document exception: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConversionException("IO exception: " + e.getMessage(), e);
        }
        finally {
            if (ra != null) {
                try {
                    ra.close();
                }
                catch (IOException e) {}
            }
            if (doc != null) {
                doc.close();
            }
        }
    }

    public void dwg2dxf(File input, File output) throws ConversionException, DatabaseException, IOException {
        log.debug("** Convert from DWG to DXF **");
        Reader stdout = null;
        String cmd = null;
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("fileIn", input.getPath());
            hm.put("fileOut", output.getPath());
            String tpl = Config.SYSTEM_DWG2DXF + " /r /ad /x14 ${fileIn} ${fileOut}";
            cmd = TemplateUtils.replace("SYSTEM_DWG2DXF", tpl, hm);
            ExecutionResult er = ExecutionUtils.runCmd(cmd);
            if (er.getExitValue() != 0) {
                throw new ConversionException(er.getStderr());
            }
        }
        catch (SecurityException e) {
            throw new ConversionException("Security exception executing command: " + cmd, e);
        }
        catch (InterruptedException e) {
            throw new ConversionException("Interrupted exception executing command: " + cmd, e);
        }
        catch (IOException e) {
            throw new ConversionException("IO exception executing command: " + cmd, e);
        }
        catch (TemplateException e) {
            throw new ConversionException("Template exception", e);
        }
        finally {
            IOUtils.closeQuietly(stdout);
        }
    }

    private class FileOrderComparator
    implements Comparator<File> {
        private FileOrderComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            int o2Ord;
            int o1Ord = Integer.parseInt(o1.getName().split("\\.")[0].split("-")[1]);
            if (o1Ord > (o2Ord = Integer.parseInt(o2.getName().split("\\.")[0].split("-")[1]))) {
                return 1;
            }
            if (o1Ord < o2Ord) {
                return -1;
            }
            return 0;
        }
    }
}

