/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.bean.form.FormElement;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.DocumentFilterDAO;
import com.openkm.dao.bean.DocumentFilter;
import com.openkm.dao.bean.DocumentFilterRule;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.base.BasePropertyGroupModule;
import com.openkm.module.base.BasePropertyModule;
import com.openkm.module.base.BaseWorkflowModule;
import com.openkm.util.JBPMUtils;
import com.openkm.util.metadata.MetadataExtractor;
import com.openkm.util.metadata.OfficeMetadata;
import com.openkm.util.metadata.OpenOfficeMetadata;
import com.openkm.util.metadata.PdfMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.OpenOfficeSpellDictionary;
import org.dts.spell.dictionary.SpellDictionary;
import org.jbpm.JbpmContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentUtils {
    private static Logger log = LoggerFactory.getLogger(DocumentUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkFilters(Session session, Node node, String mimeType) throws DatabaseException, RepositoryException {
        log.info("checkFilters({}, {})", (Object)node.getPath(), (Object)mimeType);
        for (DocumentFilter df : DocumentFilterDAO.findAll(true)) {
            boolean match = false;
            if (!df.isActive()) continue;
            if (df.getType().equals("PATH") && DocumentUtils.checkPathFilter(node, df.getValue())) {
                match = true;
            } else if (df.getType().equals("MIME_TYPE") && df.getValue().equals(mimeType)) {
                match = true;
            }
            if (!match) continue;
            for (DocumentFilterRule dfr : df.getFilterRules()) {
                if (!dfr.isActive()) continue;
                if ("ASSIGN_PROPERTY_GROUP".equals(dfr.getAction())) {
                    try {
                        log.info("ACTION_PROPERTY_GROUP");
                        BasePropertyGroupModule.addGroup(session, node, dfr.getValue());
                    }
                    catch (Exception e) {
                        JCRUtils.discardsPendingChanges(node);
                    }
                    continue;
                }
                if ("ASSIGN_WORKFLOW".equals(dfr.getAction())) {
                    JbpmContext jbpmContext = null;
                    try {
                        log.info("ACTION_WORKFLOW");
                        jbpmContext = JBPMUtils.getConfig().createJbpmContext();
                        ArrayList<FormElement> vars = new ArrayList<FormElement>();
                        int pdId = Integer.parseInt(dfr.getValue());
                        BaseWorkflowModule.runProcessDefinition(session, jbpmContext, pdId, node.getUUID(), vars);
                        continue;
                    }
                    finally {
                        if (jbpmContext != null) {
                            jbpmContext.close();
                        }
                        continue;
                    }
                }
                if ("ADD_CATEGORY".equals(dfr.getAction())) {
                    try {
                        log.info("ACTION_CATEGORY {}", (Object)dfr.getValue());
                        BasePropertyModule.addCategory(session, node, dfr.getValue());
                    }
                    catch (Exception e) {
                        JCRUtils.discardsPendingChanges(node);
                    }
                    continue;
                }
                if ("ADD_KEYWORD".equals(dfr.getAction())) {
                    try {
                        log.info("ACTION_KEYWORD: {}", (Object)dfr.getValue());
                        BasePropertyModule.addKeyword(session, node, dfr.getValue());
                    }
                    catch (Exception e) {
                        JCRUtils.discardsPendingChanges(node);
                    }
                    continue;
                }
                if (!"EXTRACT_METADATA".equals(dfr.getAction())) continue;
                InputStream is = null;
                try {
                    Node contentNode;
                    if (Config.MIME_PDF.equals(mimeType)) {
                        contentNode = node.getNode("okm:content");
                        is = contentNode.getProperty("jcr:data").getStream();
                        PdfMetadata md = MetadataExtractor.pdfExtractor(is);
                        log.info("{}", (Object)md);
                    } else if (Config.MIME_MS_WORD.equals(mimeType) || Config.MIME_MS_EXCEL.equals(mimeType) || Config.MIME_MS_POWERPOINT.equals(mimeType)) {
                        contentNode = node.getNode("okm:content");
                        is = contentNode.getProperty("jcr:data").getStream();
                        OfficeMetadata md = MetadataExtractor.officeExtractor(is, mimeType);
                        log.info("{}", (Object)md);
                    } else if (Config.MIME_OO_TEXT.equals(mimeType) || Config.MIME_OO_SPREADSHEET.equals(mimeType) || Config.MIME_OO_PRESENTATION.equals(mimeType)) {
                        contentNode = node.getNode("okm:content");
                        is = contentNode.getProperty("jcr:data").getStream();
                        OpenOfficeMetadata md = new OpenOfficeMetadata();
                        log.info("{}", (Object)md);
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
        }
    }

    private static boolean checkPathFilter(Node node, String path) throws RepositoryException {
        if (node.getPath().equals(path)) {
            return true;
        }
        return DocumentUtils.checkPathFilter(node.getParent(), path);
    }

    public static String spellChecker(String text) throws IOException {
        log.debug("spellChecker({})", (Object)text);
        StringBuilder sb = new StringBuilder();
        if (Config.SYSTEM_OPENOFFICE_DICTIONARY.equals("")) {
            log.warn("OpenOffice dictionary not configured");
            sb.append(text);
        } else {
            log.info("Using OpenOffice dictionary: {}", (Object)Config.SYSTEM_OPENOFFICE_DICTIONARY);
            ZipFile zf = new ZipFile(Config.SYSTEM_OPENOFFICE_DICTIONARY);
            OpenOfficeSpellDictionary oosd = new OpenOfficeSpellDictionary(zf);
            SpellChecker sc = new SpellChecker((SpellDictionary)oosd);
            sc.setCaseSensitive(false);
            StringTokenizer st = new StringTokenizer(text);
            while (st.hasMoreTokens()) {
                String w = st.nextToken();
                List s = sc.getDictionary().getSuggestions(w);
                if (s.isEmpty()) {
                    sb.append(w).append(" ");
                    continue;
                }
                sb.append((String)s.get(0)).append(" ");
            }
            zf.close();
        }
        log.debug("spellChecker: {}", (Object)sb.toString());
        return sb.toString();
    }
}

