/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentDetector {
    private static Logger log = LoggerFactory.getLogger(EnvironmentDetector.class);
    private static final String JBOSS_PROPERTY = "jboss.home.dir";
    private static final String TOMCAT_PROPERTY = "catalina.home";
    private static final String CUSTOM_HOME_PROPERTY = "openkm.custom.home";

    public static String getServerHomeDir() {
        String dir = System.getProperty(CUSTOM_HOME_PROPERTY);
        if (dir != null) {
            log.debug("Using custom home: {}", (Object)dir);
            return dir;
        }
        dir = System.getProperty(JBOSS_PROPERTY);
        if (dir != null) {
            log.debug("Using JBoss: {}", (Object)dir);
            return dir;
        }
        dir = System.getProperty(TOMCAT_PROPERTY);
        if (dir != null) {
            log.debug("Using Tomcat: {}", (Object)dir);
            return dir;
        }
        dir = System.getProperty("user.dir") + "/src/test/resources";
        log.debug("Using default dir: {}", (Object)dir);
        return dir;
    }

    public static boolean isServerJBoss() {
        return System.getProperty(JBOSS_PROPERTY) != null;
    }

    public static boolean isServerTomcat() {
        return !EnvironmentDetector.isServerJBoss() && System.getProperty(TOMCAT_PROPERTY) != null;
    }

    public static String getServerJndiBase() {
        if (EnvironmentDetector.isServerJBoss()) {
            return "java:/";
        }
        if (EnvironmentDetector.isServerTomcat()) {
            return "java:/comp/env/";
        }
        return "";
    }

    public static String getTempDir() {
        String dir = System.getProperty("java.io.tmpdir");
        if (dir != null) {
            return dir;
        }
        return "";
    }

    public static String getNullDevice() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("linux") || os.contains("mac os")) {
            return "/dev/null";
        }
        if (os.contains("windows")) {
            return "NUL:";
        }
        return null;
    }

    public static boolean inServer() {
        return EnvironmentDetector.isServerJBoss() || EnvironmentDetector.isServerTomcat();
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }
}

