/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import bsh.EvalError;
import bsh.Interpreter;
import com.openkm.bean.ExecutionResult;
import com.openkm.util.FormatUtil;
import com.openkm.util.cl.BinaryClassLoader;
import com.openkm.util.cl.ClassLoaderUtils;
import com.openkm.util.cl.JarClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionUtils {
    private static Logger log = LoggerFactory.getLogger(ExecutionUtils.class);
    private static ExecutionUtils single = new ExecutionUtils();
    private static int TIMEOUT = 300;

    private ExecutionUtils() {
    }

    public static ExecutionUtils getInstance() {
        return single;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] runScript(File script) throws EvalError {
        Object[] ret = new Object[3];
        FileReader fr = null;
        try {
            if (script.exists() && script.canRead()) {
                ByteArrayOutputStream baosOut = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(baosOut);
                ByteArrayOutputStream baosErr = new ByteArrayOutputStream();
                PrintStream err = new PrintStream(baosErr);
                Interpreter i = new Interpreter(null, out, err, false);
                fr = new FileReader(script);
                ret[0] = i.eval((Reader)fr);
                out.flush();
                ret[1] = baosOut.toString();
                err.flush();
                ret[2] = baosErr.toString();
            } else {
                log.warn("Unable to read script: {}", (Object)script.getPath());
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(fr);
        }
        log.debug("runScript: {}", (Object)Arrays.toString(ret));
        return ret;
    }

    public static Object[] runScript(String script) throws EvalError {
        Object[] ret = new Object[3];
        ByteArrayOutputStream baosOut = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baosOut);
        ByteArrayOutputStream baosErr = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(baosErr);
        Interpreter i = new Interpreter(null, out, err, false);
        ret[0] = i.eval(script);
        out.flush();
        ret[1] = baosOut.toString();
        err.flush();
        ret[2] = baosErr.toString();
        log.debug("runScript: {}", (Object)Arrays.toString(ret));
        return ret;
    }

    public Object runJar(File jar) {
        Object ret = null;
        try {
            if (jar.exists() && jar.canRead()) {
                ClassLoader cl = this.getClass().getClassLoader();
                JarClassLoader jcl = new JarClassLoader(jar.toURI().toURL(), cl);
                String mainClass = jcl.getMainClassName();
                if (mainClass != null) {
                    Class<?> c = jcl.loadClass(mainClass);
                    ret = ClassLoaderUtils.invokeMainMethodFromClass(c, new String[0]);
                } else {
                    log.error("Main class not defined at: {}", (Object)jar.getPath());
                }
            } else {
                log.warn("Unable to read jar: {}", (Object)jar.getPath());
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        log.debug("runJar: {}", (Object)(ret != null ? ret.toString() : "null"));
        return ret;
    }

    public Object runJar(File jar, String methodName) {
        Object ret = null;
        try {
            if (jar.exists() && jar.canRead()) {
                ClassLoader cl = this.getClass().getClassLoader();
                JarClassLoader jcl = new JarClassLoader(jar.toURI().toURL(), cl);
                String mainClass = jcl.getMainClassName();
                if (mainClass != null) {
                    Class<?> c = jcl.loadClass(mainClass);
                    ret = ClassLoaderUtils.invokeMethodFromClass(c, methodName);
                } else {
                    log.error("Main class not defined at: {}", (Object)jar.getPath());
                }
            } else {
                log.warn("Unable to read jar: {}", (Object)jar.getPath());
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        log.debug("runJar: {}", (Object)(ret != null ? ret.toString() : "null"));
        return ret;
    }

    public Object runJar(byte[] jar) {
        Object ret = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            BinaryClassLoader jcl = new BinaryClassLoader(jar, cl);
            String mainClass = jcl.getMainClassName();
            if (mainClass != null) {
                Class<?> c = jcl.loadClass(mainClass);
                ret = ClassLoaderUtils.invokeMainMethodFromClass(c, new String[0]);
            } else {
                log.error("Main class not defined at jar");
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        log.debug("runJar: {}", (Object)(ret != null ? ret.toString() : "null"));
        return ret;
    }

    public Object runJar(byte[] jar, String methodName) {
        Object ret = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            BinaryClassLoader jcl = new BinaryClassLoader(jar, cl);
            String mainClass = jcl.getMainClassName();
            if (mainClass != null) {
                Class<?> c = jcl.loadClass(mainClass);
                ret = ClassLoaderUtils.invokeMethodFromClass(c, methodName);
            } else {
                log.error("Main class not defined at jar");
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        log.debug("runJar: {}", (Object)(ret != null ? ret.toString() : "null"));
        return ret;
    }

    public static ExecutionResult runCmd(String cmd) throws SecurityException, InterruptedException, IOException {
        log.debug("runCmd({})", (Object)cmd);
        return ExecutionUtils.runCmdImpl(cmd.split(" "), TimeUnit.SECONDS.toMillis(TIMEOUT));
    }

    public static ExecutionResult runCmd(String[] cmd) throws SecurityException, InterruptedException, IOException {
        log.debug("runCmd({})", (Object)Arrays.toString(cmd));
        return ExecutionUtils.runCmdImpl(cmd, TimeUnit.SECONDS.toMillis(TIMEOUT));
    }

    private static ExecutionResult runCmdImpl(final String[] cmd, long timeout) throws SecurityException, InterruptedException, IOException {
        log.debug("runCmdImpl({}, {})", (Object)Arrays.toString(cmd), (Object)timeout);
        ExecutionResult ret = new ExecutionResult();
        long start = System.currentTimeMillis();
        ProcessBuilder pb = new ProcessBuilder(cmd);
        final Process process = pb.start();
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                process.destroy();
                log.warn("Process killed due to timeout.");
                log.warn("CommandLine: {}", (Object)Arrays.toString(cmd));
            }
        }, timeout);
        try {
            ret.setStdout(IOUtils.toString((InputStream)process.getInputStream()));
            ret.setStderr(IOUtils.toString((InputStream)process.getErrorStream()));
        }
        catch (IOException e) {
            // empty catch block
        }
        process.waitFor();
        t.cancel();
        ret.setExitValue(process.exitValue());
        if (ret.getExitValue() != 0) {
            log.warn("Abnormal program termination: {}", (Object)ret.getExitValue());
            log.warn("CommandLine: {}", (Object)Arrays.toString(cmd));
            log.warn("STDERR: {}", (Object)ret.getStderr());
        } else {
            log.debug("Normal program termination");
        }
        process.destroy();
        log.debug("Elapse time: {}", (Object)FormatUtil.formatSeconds(System.currentTimeMillis() - start));
        return ret;
    }
}

