/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.core.Config;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;

public class FileLogger {
    private static SimpleDateFormat logEntryDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private static final String LEVEL_INFO = "INFO ";
    private static final String LEVEL_WARN = "WARN ";
    private static final String LEVEL_ERROR = "ERROR";
    private Writer cLogger = null;

    public FileLogger(String baseName) throws IOException {
        this.cLogger = new FileWriter(FileLogger.getLogFile(baseName), true);
    }

    public void info(String message, Object ... params) throws IOException {
        this.cLogger.write(FileLogger.getLogEntry(LEVEL_INFO, message, params));
        this.cLogger.flush();
    }

    public void warn(String message, Object ... params) throws IOException {
        this.cLogger.write(FileLogger.getLogEntry(LEVEL_WARN, message, params));
        this.cLogger.flush();
    }

    public void error(String message, Object ... params) throws IOException {
        this.cLogger.write(FileLogger.getLogEntry(LEVEL_ERROR, message, params));
        this.cLogger.flush();
    }

    public void close() {
        IOUtils.closeQuietly((Writer)this.cLogger);
    }

    public static void info(String baseName, String message, Object ... params) throws IOException {
        FileLogger.logWrite(baseName, LEVEL_INFO, message, params);
    }

    public static void warn(String baseName, String message, Object ... params) throws IOException {
        FileLogger.logWrite(baseName, LEVEL_WARN, message, params);
    }

    public static void error(String baseName, String message, Object ... params) throws IOException {
        FileLogger.logWrite(baseName, LEVEL_ERROR, message, params);
    }

    private static void logWrite(String baseName, String level, String message, Object ... params) throws IOException {
        FileWriter sLogger = new FileWriter(FileLogger.getLogFile(baseName), true);
        sLogger.write(FileLogger.getLogEntry(level, message, params));
        ((Writer)sLogger).flush();
        ((Writer)sLogger).close();
    }

    private static String getLogFile(String baseName) {
        String fileDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return Config.HOME_DIR + File.separator + "import_files_log" + File.separator + baseName + "_" + fileDate + ".log";
    }

    private static String getLogEntry(String level, String message, Object ... params) {
        StringBuilder sb = new StringBuilder();
        sb.append(logEntryDate.format(new Date()));
        sb.append(" ");
        sb.append(level);
        sb.append(" ");
        sb.append(MessageFormat.format(message, params));
        sb.append("\n");
        return sb.toString();
    }
}

