/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.MimeTypeDAO;
import com.openkm.dao.bean.MimeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static String getFileName(String file) {
        log.debug("getFileName({})", (Object)file);
        int idx = file.lastIndexOf(".");
        String ret = idx >= 0 ? file.substring(0, idx) : file;
        log.debug("getFileName: {}", (Object)ret);
        return ret;
    }

    public static String getFileExtension(String file) {
        log.debug("getFileExtension({})", (Object)file);
        int idx = file.lastIndexOf(".");
        String ret = idx >= 0 ? file.substring(idx + 1) : "";
        log.debug("getFileExtension: {}", (Object)ret);
        return ret;
    }

    public static File createTempDir() throws IOException {
        File tmpFile = File.createTempFile("okm", null);
        if (!tmpFile.delete()) {
            throw new IOException();
        }
        if (!tmpFile.mkdir()) {
            throw new IOException();
        }
        return tmpFile;
    }

    public static File createTempFileFromMime(String mimeType) throws DatabaseException, IOException {
        MimeType mt = MimeTypeDAO.findByName(mimeType);
        String ext = mt.getExtensions().iterator().next();
        return File.createTempFile("okm", "." + ext);
    }

    public static boolean deleteQuietly(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    public static int countFiles(File dir) {
        File[] found = dir.listFiles();
        int ret = 0;
        if (found != null) {
            for (int i = 0; i < found.length; ++i) {
                if (found[i].isDirectory()) {
                    ret += FileUtils.countFiles(found[i]);
                }
                ++ret;
            }
        }
        return ret;
    }

    public static int countImportFiles(File dir) {
        File[] found = dir.listFiles();
        int ret = 0;
        if (found != null) {
            for (int i = 0; i < found.length; ++i) {
                if (found[i].isDirectory()) {
                    ret += FileUtils.countImportFiles(found[i]);
                }
                if (found[i].isFile() && found[i].getName().toLowerCase().endsWith(Config.EXPORT_METADATA_EXT)) continue;
                ++ret;
            }
        }
        return ret;
    }

    public static void copy(InputStream input, File output) throws IOException {
        FileOutputStream fos = new FileOutputStream(output);
        IOUtils.copy((InputStream)input, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    public static void copy(File input, OutputStream output) throws IOException {
        FileInputStream fis = new FileInputStream(input);
        IOUtils.copy((InputStream)fis, (OutputStream)output);
        fis.close();
    }

    public static void copy(File input, File output) throws IOException {
        org.apache.commons.io.FileUtils.copyFile((File)input, (File)output);
    }
}

