/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.bean.PropertyGroup;
import com.openkm.bean.form.Button;
import com.openkm.bean.form.CheckBox;
import com.openkm.bean.form.Download;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Input;
import com.openkm.bean.form.Node;
import com.openkm.bean.form.Option;
import com.openkm.bean.form.Print;
import com.openkm.bean.form.Select;
import com.openkm.bean.form.Separator;
import com.openkm.bean.form.SuggestBox;
import com.openkm.bean.form.Text;
import com.openkm.bean.form.TextArea;
import com.openkm.bean.form.Upload;
import com.openkm.bean.form.Validator;
import com.openkm.core.Config;
import com.openkm.core.ParseException;
import com.openkm.util.Serializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FormUtils {
    private static Logger log = LoggerFactory.getLogger(FormUtils.class);
    private static Map<PropertyGroup, List<FormElement>> pGroups = null;

    public static Map<String, List<FormElement>> parseWorkflowForms(InputStream is) throws ParseException {
        log.debug("parseWorkflowForms({})", (Object)is);
        HashMap<String, List<FormElement>> forms = new HashMap<String, List<FormElement>>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            ErrorHandler handler = new ErrorHandler();
            LocalResolver resolver = new LocalResolver(Config.DTD_BASE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(handler);
            db.setEntityResolver(resolver);
            if (is != null) {
                Document doc = db.parse(is);
                doc.getDocumentElement().normalize();
                NodeList nlForm = doc.getElementsByTagName("workflow-form");
                for (int i = 0; i < nlForm.getLength(); ++i) {
                    org.w3c.dom.Node nForm = nlForm.item(i);
                    if (nForm.getNodeType() != 1) continue;
                    String taskName = nForm.getAttributes().getNamedItem("task").getNodeValue();
                    NodeList nlField = nForm.getChildNodes();
                    List<FormElement> fe = FormUtils.parseField(nlField);
                    forms.put(taskName, fe);
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ParseException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), e);
        }
        log.debug("parseWorkflowForms: {}", forms);
        return forms;
    }

    public static List<FormElement> parseReportParameters(InputStream is) throws ParseException {
        log.debug("parseReportParameters({})", (Object)is);
        List<FormElement> params = new ArrayList<FormElement>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            ErrorHandler handler = new ErrorHandler();
            LocalResolver resolver = new LocalResolver(Config.DTD_BASE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(handler);
            db.setEntityResolver(resolver);
            if (is != null) {
                Document doc = db.parse(is);
                doc.getDocumentElement().normalize();
                NodeList nlForm = doc.getElementsByTagName("report-parameters");
                for (int i = 0; i < nlForm.getLength(); ++i) {
                    org.w3c.dom.Node nForm = nlForm.item(i);
                    if (nForm.getNodeType() != 1) continue;
                    NodeList nlField = nForm.getChildNodes();
                    params = FormUtils.parseField(nlField);
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ParseException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), e);
        }
        log.debug("parseReportParameters: {}", params);
        return params;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized Map<PropertyGroup, List<FormElement>> parsePropertyGroupsForms(String pgFile) throws IOException, ParseException {
        log.debug("parseMetadataForms()");
        if (pGroups == null) {
            log.debug("PropertyGroupForms: {}", (Object)pgFile);
            pGroups = new HashMap<PropertyGroup, List<FormElement>>();
            FileInputStream fis = null;
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(true);
                ErrorHandler handler = new ErrorHandler();
                DocumentBuilder db = dbf.newDocumentBuilder();
                LocalResolver resolver = new LocalResolver(Config.DTD_BASE);
                db.setErrorHandler(handler);
                db.setEntityResolver(resolver);
                fis = new FileInputStream(pgFile);
                if (fis != null) {
                    Document doc = db.parse(fis);
                    doc.getDocumentElement().normalize();
                    NodeList nlForm = doc.getElementsByTagName("property-group");
                    for (int i = 0; i < nlForm.getLength(); ++i) {
                        org.w3c.dom.Node nForm = nlForm.item(i);
                        if (nForm.getNodeType() != 1) continue;
                        PropertyGroup pg = new PropertyGroup();
                        org.w3c.dom.Node item = nForm.getAttributes().getNamedItem("label");
                        if (item != null) {
                            pg.setLabel(item.getNodeValue());
                        }
                        if ((item = nForm.getAttributes().getNamedItem("name")) != null) {
                            pg.setName(item.getNodeValue());
                        }
                        if ((item = nForm.getAttributes().getNamedItem("visible")) != null) {
                            pg.setVisible(Boolean.valueOf(item.getNodeValue()));
                        }
                        if ((item = nForm.getAttributes().getNamedItem("readonly")) != null) {
                            pg.setReadonly(Boolean.valueOf(item.getNodeValue()));
                        }
                        NodeList nlField = nForm.getChildNodes();
                        List<FormElement> fe = FormUtils.parseField(nlField);
                        pGroups.put(pg, fe);
                    }
                }
            }
            catch (ParserConfigurationException e) {
                try {
                    throw new ParseException(e.getMessage());
                    catch (SAXException e2) {
                        throw new ParseException(e2.getMessage());
                    }
                    catch (IOException e3) {
                        throw e3;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        log.debug("parseMetadataForms: {}", pGroups);
        return FormUtils.clonedPropertyGroups();
    }

    private static Map<PropertyGroup, List<FormElement>> clonedPropertyGroups() throws IOException {
        try {
            return (Map)Serializer.read(Serializer.write(pGroups));
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException", e);
        }
    }

    public static synchronized void resetPropertyGroupsForms() {
        pGroups = null;
    }

    public static List<FormElement> getPropertyGroupForms(Map<PropertyGroup, List<FormElement>> formsElements, String groupName) {
        for (Map.Entry<PropertyGroup, List<FormElement>> entry : formsElements.entrySet()) {
            if (!entry.getKey().getName().equals(groupName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static FormElement getFormElement(Map<PropertyGroup, List<FormElement>> formsElements, String propertyName) {
        for (Map.Entry<PropertyGroup, List<FormElement>> entry : formsElements.entrySet()) {
            for (FormElement fe : entry.getValue()) {
                if (!fe.getName().equals(propertyName)) continue;
                return fe;
            }
        }
        return null;
    }

    private static List<FormElement> parseField(NodeList nlField) {
        ArrayList<FormElement> fe = new ArrayList<FormElement>();
        for (int j = 0; j < nlField.getLength(); ++j) {
            org.w3c.dom.Node item;
            org.w3c.dom.Node nField = nlField.item(j);
            if (nField.getNodeType() != 1) continue;
            String fieldComponent = nField.getNodeName();
            if (fieldComponent.equals("input")) {
                Input input = new Input();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    input.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    input.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("type")) != null) {
                    input.setType(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("value")) != null) {
                    input.setValue(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("data")) != null) {
                    input.setData(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    input.setWidth(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("height")) != null) {
                    input.setHeight(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("readonly")) != null) {
                    input.setReadonly(Boolean.parseBoolean(item.getNodeValue()));
                }
                input.setValidators(FormUtils.parseValidators(nField));
                fe.add(input);
                continue;
            }
            if (fieldComponent.equals("suggestbox")) {
                SuggestBox sbox = new SuggestBox();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    sbox.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    sbox.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("value")) != null) {
                    sbox.setValue(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("data")) != null) {
                    sbox.setData(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    sbox.setWidth(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("height")) != null) {
                    sbox.setHeight(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("table")) != null) {
                    sbox.setTable(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("filterQuery")) != null) {
                    sbox.setFilterQuery(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("valueQuery")) != null) {
                    sbox.setValueQuery(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("dialogTitle")) != null) {
                    sbox.setDialogTitle(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("readonly")) != null) {
                    sbox.setReadonly(Boolean.parseBoolean(item.getNodeValue()));
                }
                if ((item = nField.getAttributes().getNamedItem("filterMinLen")) != null) {
                    sbox.setFilterMinLen(Integer.parseInt(item.getNodeValue()));
                }
                sbox.setValidators(FormUtils.parseValidators(nField));
                fe.add(sbox);
                continue;
            }
            if (fieldComponent.equals("upload")) {
                Upload up = new Upload();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    up.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    up.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    up.setWidth(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("height")) != null) {
                    up.setHeight(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("folderPath")) != null) {
                    up.setFolderPath(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("folderUuid")) != null) {
                    up.setFolderUuid(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("documentName")) != null) {
                    up.setDocumentName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("documentUuid")) != null) {
                    up.setDocumentUuid(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("type")) != null) {
                    up.setType(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("data")) != null) {
                    up.setData(item.getNodeValue());
                }
                up.setValidators(FormUtils.parseValidators(nField));
                fe.add(up);
                continue;
            }
            if (fieldComponent.equals("download")) {
                Download down = new Download();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    down.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    down.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    down.setWidth(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("height")) != null) {
                    down.setHeight(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("data")) != null) {
                    down.setData(item.getNodeValue());
                }
                down.setNodes(FormUtils.parseNodes(nField));
                down.setValidators(FormUtils.parseValidators(nField));
                fe.add(down);
                continue;
            }
            if (fieldComponent.equals("print")) {
                Print print = new Print();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    print.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    print.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    print.setWidth(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("height")) != null) {
                    print.setHeight(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("data")) != null) {
                    print.setData(item.getNodeValue());
                }
                print.setNodes(FormUtils.parseNodes(nField));
                print.setValidators(FormUtils.parseValidators(nField));
                fe.add(print);
                continue;
            }
            if (fieldComponent.equals("checkbox")) {
                CheckBox checkBox = new CheckBox();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    checkBox.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    checkBox.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("value")) != null) {
                    checkBox.setValue(Boolean.parseBoolean(item.getNodeValue()));
                }
                if ((item = nField.getAttributes().getNamedItem("data")) != null) {
                    checkBox.setData(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    checkBox.setWidth(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("height")) != null) {
                    checkBox.setHeight(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("readonly")) != null) {
                    checkBox.setReadonly(Boolean.parseBoolean(item.getNodeValue()));
                }
                checkBox.setValidators(FormUtils.parseValidators(nField));
                fe.add(checkBox);
                continue;
            }
            if (fieldComponent.equals("textarea")) {
                TextArea textArea = new TextArea();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    textArea.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    textArea.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("value")) != null) {
                    textArea.setValue(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("data")) != null) {
                    textArea.setData(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    textArea.setWidth(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("height")) != null) {
                    textArea.setHeight(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("readonly")) != null) {
                    textArea.setReadonly(Boolean.parseBoolean(item.getNodeValue()));
                }
                textArea.setValidators(FormUtils.parseValidators(nField));
                fe.add(textArea);
                continue;
            }
            if (fieldComponent.equals("button")) {
                Button button = new Button();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    button.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    button.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("validate")) != null) {
                    button.setValidate(Boolean.parseBoolean(item.getNodeValue()));
                }
                if ((item = nField.getAttributes().getNamedItem("transition")) != null) {
                    button.setTransition(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("confirmation")) != null) {
                    button.setConfirmation(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    button.setWidth(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("height")) != null) {
                    button.setHeight(item.getNodeValue());
                }
                fe.add(button);
                continue;
            }
            if (fieldComponent.equals("text")) {
                Text txt = new Text();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    txt.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    txt.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("data")) != null) {
                    txt.setData(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    txt.setWidth(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("height")) != null) {
                    txt.setHeight(item.getNodeValue());
                }
                fe.add(txt);
                continue;
            }
            if (fieldComponent.equals("separator")) {
                Separator sep = new Separator();
                item = nField.getAttributes().getNamedItem("label");
                if (item != null) {
                    sep.setLabel(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("name")) != null) {
                    sep.setName(item.getNodeValue());
                }
                if ((item = nField.getAttributes().getNamedItem("width")) != null) {
                    sep.setWidth(item.getNodeValue());
                }
                fe.add(sep);
                continue;
            }
            if (!fieldComponent.equals("select")) continue;
            Select select = new Select();
            ArrayList<Option> options = new ArrayList<Option>();
            org.w3c.dom.Node item2 = nField.getAttributes().getNamedItem("label");
            if (item2 != null) {
                select.setLabel(item2.getNodeValue());
            }
            if ((item2 = nField.getAttributes().getNamedItem("name")) != null) {
                select.setName(item2.getNodeValue());
            }
            if ((item2 = nField.getAttributes().getNamedItem("type")) != null) {
                select.setType(item2.getNodeValue());
            }
            if ((item2 = nField.getAttributes().getNamedItem("data")) != null) {
                select.setData(item2.getNodeValue());
            }
            if ((item2 = nField.getAttributes().getNamedItem("optionsData")) != null) {
                select.setOptionsData(item2.getNodeValue());
            }
            if ((item2 = nField.getAttributes().getNamedItem("width")) != null) {
                select.setWidth(item2.getNodeValue());
            }
            if ((item2 = nField.getAttributes().getNamedItem("height")) != null) {
                select.setHeight(item2.getNodeValue());
            }
            if ((item2 = nField.getAttributes().getNamedItem("readonly")) != null) {
                select.setReadonly(Boolean.parseBoolean(item2.getNodeValue()));
            }
            if ((item2 = nField.getAttributes().getNamedItem("table")) != null) {
                select.setTable(item2.getNodeValue());
            }
            if ((item2 = nField.getAttributes().getNamedItem("optionsQuery")) != null) {
                select.setOptionsQuery(item2.getNodeValue());
            }
            NodeList nlOptions = nField.getChildNodes();
            for (int k = 0; k < nlOptions.getLength(); ++k) {
                org.w3c.dom.Node nOption = nlOptions.item(k);
                if (nOption.getNodeType() != 1 || !nOption.getNodeName().equals("option")) continue;
                Option option = new Option();
                item2 = nOption.getAttributes().getNamedItem("label");
                if (item2 != null) {
                    option.setLabel(item2.getNodeValue());
                }
                if ((item2 = nOption.getAttributes().getNamedItem("value")) != null) {
                    option.setValue(item2.getNodeValue());
                }
                if ((item2 = nOption.getAttributes().getNamedItem("selected")) != null) {
                    option.setSelected(Boolean.parseBoolean(item2.getNodeValue()));
                }
                options.add(option);
            }
            select.setOptions(options);
            select.setValidators(FormUtils.parseValidators(nField));
            fe.add(select);
        }
        return fe;
    }

    private static List<Node> parseNodes(org.w3c.dom.Node nField) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nlNodes = nField.getChildNodes();
        for (int k = 0; k < nlNodes.getLength(); ++k) {
            org.w3c.dom.Node nNode = nlNodes.item(k);
            if (nNode.getNodeType() != 1 || !nNode.getNodeName().equals("node")) continue;
            Node node = new Node();
            org.w3c.dom.Node item = nNode.getAttributes().getNamedItem("label");
            if (item != null) {
                node.setLabel(item.getNodeValue());
            }
            if ((item = nNode.getAttributes().getNamedItem("path")) != null) {
                node.setPath(item.getNodeValue());
            }
            if ((item = nNode.getAttributes().getNamedItem("uuid")) != null) {
                node.setUuid(item.getNodeValue());
            }
            nodes.add(node);
        }
        return nodes;
    }

    private static List<Validator> parseValidators(org.w3c.dom.Node nField) {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        NodeList nlValidators = nField.getChildNodes();
        for (int k = 0; k < nlValidators.getLength(); ++k) {
            org.w3c.dom.Node nValidator = nlValidators.item(k);
            if (nValidator.getNodeType() != 1 || !nValidator.getNodeName().equals("validator")) continue;
            Validator validator = new Validator();
            org.w3c.dom.Node item = nValidator.getAttributes().getNamedItem("type");
            if (item != null) {
                validator.setType(item.getNodeValue());
            }
            if ((item = nValidator.getAttributes().getNamedItem("parameter")) != null) {
                validator.setParameter(item.getNodeValue());
            }
            validators.add(validator);
        }
        return validators;
    }

    public static Map<String, String> toString(FormElement fe) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("label", fe.getLabel());
        ret.put("name", fe.getName());
        ret.put("width", fe.getWidth());
        ret.put("height", fe.getHeight());
        if (fe instanceof Input) {
            Input input = (Input)fe;
            ret.put("field", "Input");
            StringBuilder sb = new StringBuilder();
            sb.append("<i>Readonly:</i> ");
            sb.append(input.isReadonly());
            sb.append("<br/>");
            sb.append("<i>Data:</i> ");
            sb.append(input.getData());
            sb.append("<br/>");
            sb.append("<i>Type:</i> ");
            sb.append(input.getType());
            FormUtils.drawValidators(sb, input.getValidators());
            ret.put("others", sb.toString());
        } else if (fe instanceof SuggestBox) {
            SuggestBox suggestBox = (SuggestBox)fe;
            ret.put("field", "SuggestBox");
            StringBuilder sb = new StringBuilder();
            sb.append("<i>Readonly:</i> ");
            sb.append(suggestBox.isReadonly());
            sb.append("<br/>");
            sb.append("<i>Data:</i> ");
            sb.append(suggestBox.getData());
            sb.append("<br/>");
            sb.append("<i>DialogTitle:</i> ");
            sb.append(suggestBox.getDialogTitle());
            sb.append("<br/>");
            sb.append("<i>Table:</i> ");
            sb.append(suggestBox.getTable());
            sb.append("<br/>");
            sb.append("<i>FilterMinLen:</i> ");
            sb.append(suggestBox.getFilterMinLen());
            sb.append("<br/>");
            sb.append("<i>FilterQuery:</i> ");
            sb.append(suggestBox.getFilterQuery());
            sb.append("<br/>");
            sb.append("<i>ValueQuery:</i> ");
            sb.append(suggestBox.getValueQuery());
            FormUtils.drawValidators(sb, suggestBox.getValidators());
            ret.put("others", sb.toString());
        } else if (fe instanceof CheckBox) {
            CheckBox checkBox = new CheckBox();
            ret.put("field", "CheckBox");
            StringBuilder sb = new StringBuilder();
            sb.append("<i>Readonly:</i> ");
            sb.append(checkBox.isReadonly());
            sb.append("<br/>");
            sb.append("<i>Data:</i> ");
            sb.append(checkBox.getData());
            FormUtils.drawValidators(sb, checkBox.getValidators());
            ret.put("others", sb.toString());
        } else if (fe instanceof TextArea) {
            TextArea textArea = (TextArea)fe;
            ret.put("field", "TextArea");
            StringBuilder sb = new StringBuilder();
            sb.append("<i>Readonly:</i> ");
            sb.append(textArea.isReadonly());
            sb.append("<br/>");
            sb.append("<i>Data:</i> ");
            sb.append(textArea.getData());
            FormUtils.drawValidators(sb, textArea.getValidators());
            ret.put("others", sb.toString());
        } else if (fe instanceof Select) {
            Select select = (Select)fe;
            ret.put("field", "Select");
            StringBuilder sb = new StringBuilder();
            sb.append("<i>Readonly:</i> ");
            sb.append(select.isReadonly());
            sb.append("<br/>");
            sb.append("<i>Data:</i> ");
            sb.append(select.getData());
            sb.append("<br/>");
            sb.append("<i>Type:</i> ");
            sb.append(select.getType());
            sb.append("<br/>");
            sb.append("<i>Options:</i><ul>");
            for (Option opt : select.getOptions()) {
                sb.append("<li><i>Label:</i> ");
                sb.append(opt.getLabel());
                sb.append(", <i>Value:</i> ");
                sb.append(opt.getValue());
                sb.append("</li>");
            }
            sb.append("</ul>");
            FormUtils.drawValidators(sb, select.getValidators());
            ret.put("others", sb.toString());
        } else if (fe instanceof Button) {
            Button button = (Button)fe;
            ret.put("field", "Button");
            StringBuilder sb = new StringBuilder();
            sb.append("<i>Transition:</i> ");
            sb.append(button.getTransition());
            ret.put("others", sb.toString());
        } else if (fe instanceof Upload) {
            Upload up = (Upload)fe;
            ret.put("field", "Upload");
            StringBuilder sb = new StringBuilder();
            sb.append("<i>Type:</i> ");
            sb.append(up.getType());
            sb.append("<br/>");
            sb.append("<i>FolderPath:</i> ");
            sb.append(up.getFolderPath());
            sb.append("<br/>");
            sb.append("<i>FolderUuid:</i> ");
            sb.append(up.getFolderUuid());
            sb.append("<br/>");
            sb.append("<i>DocumentName:</i> ");
            sb.append(up.getDocumentName());
            sb.append("<br/>");
            sb.append("<i>DocumentUuid:</i> ");
            sb.append(up.getDocumentUuid());
            FormUtils.drawValidators(sb, up.getValidators());
            ret.put("others", sb.toString());
        } else if (fe instanceof Separator) {
            ret.put("field", "Separator");
            ret.put("others", "");
        } else if (fe instanceof Text) {
            ret.put("field", "Text");
            ret.put("others", "");
        }
        return ret;
    }

    private static void drawValidators(StringBuilder sb, List<Validator> validators) {
        if (!validators.isEmpty()) {
            sb.append("<br/><i>Validators:</i><ul>");
            for (Validator v : validators) {
                sb.append("<li><i>Type:</i> ");
                sb.append(v.getType());
                sb.append(", <i>Parameter:</i> ");
                sb.append(v.getParameter());
                sb.append("</li>");
            }
            sb.append("</ul>");
        }
    }

    static class LocalResolver
    implements EntityResolver {
        private static Logger log = LoggerFactory.getLogger(LocalResolver.class);
        private Hashtable<String, String> dtds = new Hashtable();
        private boolean hasDTD = false;

        public LocalResolver(String dtdBase) {
            File[] files;
            log.info("new LocalResolver({})", (Object)dtdBase);
            File folder = new File(dtdBase);
            for (File f : files = folder.listFiles()) {
                String fileName;
                if (!f.isFile() || !(fileName = f.getName()).endsWith(".dtd")) continue;
                String fpi = "-//OpenKM//DTD ";
                fileName = fileName.replaceAll("\\.dtd", "");
                boolean isFirst = true;
                for (String token : fileName.split("-")) {
                    char capLetter = Character.toUpperCase(token.charAt(0));
                    String toBeCapped = capLetter + token.substring(1, token.length());
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        fpi = fpi + " ";
                    }
                    fpi = fpi + toBeCapped;
                }
                fpi = fpi + "//EN";
                this.registerDTD(fpi, f.getPath());
            }
        }

        public void registerDTD(String publicId, String dtdFileName) {
            log.info("registerDTD({}, {})", (Object)publicId, (Object)dtdFileName);
            this.dtds.put(publicId, dtdFileName);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            this.hasDTD = false;
            String dtd = this.dtds.get(publicId);
            log.info("resolveEntity(publicId={}, systemId={}) => {}", new Object[]{publicId, systemId, dtd == null ? "NULL" : dtd});
            if (dtd != null) {
                this.hasDTD = true;
                try {
                    InputSource aInputSource = new InputSource(dtd);
                    return aInputSource;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean hasDTD() {
            return this.hasDTD;
        }
    }

    private static final class ErrorHandler
    extends DefaultHandler {
        private ErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            log.error(exception.getMessage());
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            log.error(exception.getMessage());
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            log.warn(exception.getMessage());
            throw exception;
        }
    }
}

