/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.bean.LogMessage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatUtil {
    private static Logger log = LoggerFactory.getLogger(FormatUtil.class);

    public static final boolean isMobile(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        return userAgent.contains("android") || userAgent.contains("iphone") || userAgent.contains("blackberry");
    }

    public static String formatSize(long size) {
        DecimalFormat df = new DecimalFormat("#0.0");
        String str = size / 1024L < 1L ? size + " B" : (size / 0x100000L < 1L ? df.format((double)size / 1024.0) + " KB" : (size / 0x40000000L < 1L ? df.format((double)size / 1048576.0) + " MB" : (size / 0x10000000000L < 1L ? df.format((double)size / 1.073741824E9) + " GB" : (size / 0x4000000000000L < 1L ? df.format((double)size / 1.099511627776E12) + " TB" : "BIG"))));
        return str;
    }

    public static String formatTime(long time) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        String str = df.format(time);
        return str;
    }

    public static String formatSeconds(long time) {
        long hours = (time /= 1000L) / 3600L;
        long minutes = (time -= hours * 3600L) / 60L;
        long seconds = time -= minutes * 60L;
        return (hours < 10L ? "0" + hours : Long.valueOf(hours)) + ":" + (minutes < 10L ? "0" + minutes : Long.valueOf(minutes)) + ":" + (seconds < 10L ? "0" + seconds : Long.valueOf(seconds));
    }

    public static String formatMiliSeconds(long time) {
        long mseconds = time % 1000L;
        long hours = (time /= 1000L) / 3600L;
        long minutes = (time -= hours * 3600L) / 60L;
        long seconds = time -= minutes * 60L;
        return (hours < 10L ? "0" + hours : Long.valueOf(hours)) + ":" + (minutes < 10L ? "0" + minutes : Long.valueOf(minutes)) + ":" + (seconds < 10L ? "0" + seconds : Long.valueOf(seconds)) + "." + (mseconds < 10L ? "00" + mseconds : (mseconds < 100L ? "0" + mseconds : Long.valueOf(mseconds)));
    }

    public static String formatDate(Calendar cal) {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(cal.getTime());
    }

    public static String formatArray(String[] values) {
        if (values != null) {
            if (values.length == 1) {
                return values[0];
            }
            return ArrayUtils.toString((Object)values);
        }
        return "NULL";
    }

    public static String formatObject(Object value) {
        if (value != null) {
            if (value instanceof Object[]) {
                return ArrayUtils.toString((Object)value);
            }
            return value.toString();
        }
        return "NULL";
    }

    public static String escapeHtml(String str) {
        return str.replace("<", "&lt;").replace(">", "&gt;");
    }

    public static Collection<LogMessage> parseLog(File flog, int begin, int end, String str) throws IOException {
        ArrayList<LogMessage> al = new ArrayList<LogMessage>();
        int i = 0;
        if (begin < 0 || end < 0) {
            int maxLines = 0;
            LineIterator lit = FileUtils.lineIterator((File)flog);
            while (lit.hasNext()) {
                lit.nextLine();
                ++maxLines;
            }
            if (begin < 0) {
                begin += maxLines;
            }
            if (end < 0) {
                end += maxLines + 1;
            }
        }
        LineIterator lit = FileUtils.lineIterator((File)flog);
        while (lit.hasNext()) {
            String line = lit.nextLine();
            int idx = line.indexOf(str);
            if (str != null && idx <= -1 || ++i < begin || i > end) continue;
            if (idx > -1) {
                StringBuilder sb = new StringBuilder();
                sb.append(line.substring(0, idx));
                sb.append("<span class=\"highlight\">");
                sb.append(line.substring(idx, idx + str.length()));
                sb.append("</span>");
                sb.append(line.substring(idx + str.length()));
                line = sb.toString();
            }
            LogMessage lm = new LogMessage();
            lm.setLine(i);
            lm.setMessage(line);
            al.add(lm);
        }
        return al;
    }
}

