/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.api.OKMDocument;
import com.openkm.api.OKMFolder;
import com.openkm.api.OKMMail;
import com.openkm.api.OKMPropertyGroup;
import com.openkm.api.OKMRepository;
import com.openkm.bean.DashboardDocumentResult;
import com.openkm.bean.DashboardFolderResult;
import com.openkm.bean.DashboardMailResult;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.bean.Lock;
import com.openkm.bean.Mail;
import com.openkm.bean.Note;
import com.openkm.bean.PropertyGroup;
import com.openkm.bean.QueryResult;
import com.openkm.bean.Version;
import com.openkm.bean.form.Button;
import com.openkm.bean.form.CheckBox;
import com.openkm.bean.form.Download;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Input;
import com.openkm.bean.form.Node;
import com.openkm.bean.form.Option;
import com.openkm.bean.form.Print;
import com.openkm.bean.form.Select;
import com.openkm.bean.form.Separator;
import com.openkm.bean.form.SuggestBox;
import com.openkm.bean.form.Text;
import com.openkm.bean.form.TextArea;
import com.openkm.bean.form.Upload;
import com.openkm.bean.form.Validator;
import com.openkm.bean.workflow.Comment;
import com.openkm.bean.workflow.ProcessDefinition;
import com.openkm.bean.workflow.ProcessInstance;
import com.openkm.bean.workflow.TaskInstance;
import com.openkm.bean.workflow.Token;
import com.openkm.bean.workflow.Transition;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.KeyValueDAO;
import com.openkm.dao.bean.Activity;
import com.openkm.dao.bean.Bookmark;
import com.openkm.dao.bean.KeyValue;
import com.openkm.dao.bean.Language;
import com.openkm.dao.bean.QueryParams;
import com.openkm.dao.bean.Report;
import com.openkm.dao.bean.UserConfig;
import com.openkm.extension.dao.bean.Contact;
import com.openkm.extension.dao.bean.Forum;
import com.openkm.extension.dao.bean.ForumPost;
import com.openkm.extension.dao.bean.ForumTopic;
import com.openkm.extension.dao.bean.MessageReceived;
import com.openkm.extension.dao.bean.MessageSent;
import com.openkm.extension.dao.bean.ProposedQueryReceived;
import com.openkm.extension.dao.bean.ProposedQuerySent;
import com.openkm.extension.dao.bean.ProposedSubscriptionReceived;
import com.openkm.extension.dao.bean.ProposedSubscriptionSent;
import com.openkm.extension.dao.bean.StampImage;
import com.openkm.extension.dao.bean.StampText;
import com.openkm.extension.dao.bean.Staple;
import com.openkm.extension.dao.bean.StapleGroup;
import com.openkm.frontend.client.bean.GWTBookmark;
import com.openkm.frontend.client.bean.GWTComment;
import com.openkm.frontend.client.bean.GWTDashboardDocumentResult;
import com.openkm.frontend.client.bean.GWTDashboardFolderResult;
import com.openkm.frontend.client.bean.GWTDashboardMailResult;
import com.openkm.frontend.client.bean.GWTDocument;
import com.openkm.frontend.client.bean.GWTFolder;
import com.openkm.frontend.client.bean.GWTKeyValue;
import com.openkm.frontend.client.bean.GWTLanguage;
import com.openkm.frontend.client.bean.GWTLock;
import com.openkm.frontend.client.bean.GWTMail;
import com.openkm.frontend.client.bean.GWTNote;
import com.openkm.frontend.client.bean.GWTProcessDefinition;
import com.openkm.frontend.client.bean.GWTProcessInstance;
import com.openkm.frontend.client.bean.GWTPropertyGroup;
import com.openkm.frontend.client.bean.GWTPropertyParams;
import com.openkm.frontend.client.bean.GWTQueryParams;
import com.openkm.frontend.client.bean.GWTQueryResult;
import com.openkm.frontend.client.bean.GWTReport;
import com.openkm.frontend.client.bean.GWTTaskInstance;
import com.openkm.frontend.client.bean.GWTToken;
import com.openkm.frontend.client.bean.GWTTransition;
import com.openkm.frontend.client.bean.GWTUserConfig;
import com.openkm.frontend.client.bean.GWTVersion;
import com.openkm.frontend.client.bean.GWTWorkflowComment;
import com.openkm.frontend.client.bean.extension.GWTActivity;
import com.openkm.frontend.client.bean.extension.GWTContact;
import com.openkm.frontend.client.bean.extension.GWTForum;
import com.openkm.frontend.client.bean.extension.GWTForumPost;
import com.openkm.frontend.client.bean.extension.GWTForumTopic;
import com.openkm.frontend.client.bean.extension.GWTMessageReceived;
import com.openkm.frontend.client.bean.extension.GWTProposedQueryReceived;
import com.openkm.frontend.client.bean.extension.GWTProposedQuerySent;
import com.openkm.frontend.client.bean.extension.GWTProposedSubscriptionReceived;
import com.openkm.frontend.client.bean.extension.GWTProposedSubscriptionSent;
import com.openkm.frontend.client.bean.extension.GWTStamp;
import com.openkm.frontend.client.bean.extension.GWTStaple;
import com.openkm.frontend.client.bean.extension.GWTStapleGroup;
import com.openkm.frontend.client.bean.extension.GWTTextMessageSent;
import com.openkm.frontend.client.bean.form.GWTButton;
import com.openkm.frontend.client.bean.form.GWTCheckBox;
import com.openkm.frontend.client.bean.form.GWTDownload;
import com.openkm.frontend.client.bean.form.GWTFormElement;
import com.openkm.frontend.client.bean.form.GWTInput;
import com.openkm.frontend.client.bean.form.GWTNode;
import com.openkm.frontend.client.bean.form.GWTOption;
import com.openkm.frontend.client.bean.form.GWTPrint;
import com.openkm.frontend.client.bean.form.GWTSelect;
import com.openkm.frontend.client.bean.form.GWTSeparator;
import com.openkm.frontend.client.bean.form.GWTSuggestBox;
import com.openkm.frontend.client.bean.form.GWTText;
import com.openkm.frontend.client.bean.form.GWTTextArea;
import com.openkm.frontend.client.bean.form.GWTUpload;
import com.openkm.frontend.client.bean.form.GWTValidator;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GWTUtil {
    private static Logger log = LoggerFactory.getLogger(GWTUtil.class);

    public static GWTDocument copy(Document doc) {
        log.debug("copy({})", (Object)doc);
        GWTDocument gWTDoc = new GWTDocument();
        gWTDoc.setKeywords(doc.getKeywords());
        gWTDoc.setMimeType(doc.getMimeType());
        gWTDoc.setName(GWTUtil.getName(doc.getPath()));
        gWTDoc.setParent(GWTUtil.getParent(doc.getPath()));
        gWTDoc.setParentId(GWTUtil.getParent(doc.getPath()));
        gWTDoc.setPath(doc.getPath());
        gWTDoc.setAuthor(doc.getAuthor());
        gWTDoc.setCreated(doc.getCreated().getTime());
        gWTDoc.setLastModified(doc.getLastModified().getTime());
        gWTDoc.setCheckedOut(doc.isCheckedOut());
        gWTDoc.setLocked(doc.isLocked());
        gWTDoc.setSubscribed(doc.isSubscribed());
        gWTDoc.setActualVersion(GWTUtil.copy(doc.getActualVersion()));
        gWTDoc.setPermissions(doc.getPermissions());
        gWTDoc.setLockInfo(GWTUtil.copy(doc.getLockInfo()));
        gWTDoc.setConvertibleToPdf(doc.isConvertibleToPdf());
        gWTDoc.setConvertibleToSwf(doc.isConvertibleToSwf());
        gWTDoc.setConvertibleToDxf(doc.isConvertibleToDxf());
        gWTDoc.setCipherName(doc.getCipherName());
        gWTDoc.setSubscriptors(doc.getSubscriptors());
        gWTDoc.setUuid(doc.getUuid());
        gWTDoc.setNotes(GWTUtil.copy(doc.getNotes()));
        Iterator<Note> it = doc.getNotes().iterator();
        while (it.hasNext() && !gWTDoc.isHasNotes()) {
            Note note = it.next();
            if (note.getUser().equals(Config.SYSTEM_USER)) continue;
            gWTDoc.setHasNotes(true);
        }
        HashSet<GWTFolder> categories = new HashSet<GWTFolder>();
        Iterator<Folder> it2 = doc.getCategories().iterator();
        while (it2.hasNext()) {
            categories.add(GWTUtil.copy(it2.next()));
        }
        gWTDoc.setCategories(categories);
        log.debug("copy: {}", (Object)gWTDoc);
        return gWTDoc;
    }

    public static Document copy(GWTDocument gWTDoc) {
        log.debug("copy({})", (Object)gWTDoc);
        Document doc = new Document();
        Calendar cal = Calendar.getInstance();
        doc.setKeywords(gWTDoc.getKeywords());
        doc.setMimeType(gWTDoc.getMimeType());
        doc.setPath(gWTDoc.getPath());
        doc.setAuthor(gWTDoc.getAuthor());
        cal.setTime(gWTDoc.getCreated());
        doc.setCreated(cal);
        cal.setTime(gWTDoc.getLastModified());
        doc.setLastModified(cal);
        doc.setCheckedOut(gWTDoc.isCheckedOut());
        doc.setLocked(gWTDoc.isLocked());
        doc.setActualVersion(GWTUtil.copy(gWTDoc.getActualVersion()));
        doc.setPermissions(gWTDoc.getPermissions());
        doc.setSubscribed(gWTDoc.isSubscribed());
        doc.setSubscriptors(gWTDoc.getSubscriptors());
        HashSet<Folder> categories = new HashSet<Folder>();
        Iterator<GWTFolder> it = gWTDoc.getCategories().iterator();
        while (it.hasNext()) {
            categories.add(GWTUtil.copy(it.next()));
        }
        doc.setCategories(categories);
        gWTDoc.setActualVersion(GWTUtil.copy(doc.getActualVersion()));
        log.debug("copy: {}", (Object)gWTDoc);
        return doc;
    }

    public static GWTFolder copy(Folder fld) {
        log.debug("copy({})", (Object)fld);
        GWTFolder gWTFolder = new GWTFolder();
        gWTFolder.setUuid(fld.getUuid());
        gWTFolder.setPath(fld.getPath());
        gWTFolder.setParentPath(GWTUtil.getParent(fld.getPath()));
        gWTFolder.setName(GWTUtil.getName(fld.getPath()));
        gWTFolder.setHasChilds(fld.getHasChilds());
        gWTFolder.setCreated(fld.getCreated().getTime());
        gWTFolder.setPermissions(fld.getPermissions());
        gWTFolder.setAuthor(fld.getAuthor());
        gWTFolder.setSubscribed(fld.isSubscribed());
        gWTFolder.setSubscriptors(fld.getSubscriptors());
        gWTFolder.setNotes(GWTUtil.copy(fld.getNotes()));
        Iterator<Note> it = fld.getNotes().iterator();
        while (it.hasNext() && !gWTFolder.isHasNotes()) {
            Note note = it.next();
            if (note.getUser().equals(Config.SYSTEM_USER)) continue;
            gWTFolder.setHasNotes(true);
        }
        log.debug("copy: {}", (Object)gWTFolder);
        return gWTFolder;
    }

    public static Folder copy(GWTFolder fld) {
        log.debug("copy({})", (Object)fld);
        Folder folder = new Folder();
        folder.setUuid(fld.getUuid());
        folder.setPath(fld.getPath());
        folder.setHasChilds(fld.getHasChilds());
        Calendar created = Calendar.getInstance();
        created.setTimeInMillis(fld.getCreated().getTime());
        folder.setCreated(created);
        folder.setPermissions(fld.getPermissions());
        folder.setAuthor(fld.getAuthor());
        folder.setSubscribed(fld.isSubscribed());
        folder.setSubscriptors(fld.getSubscriptors());
        log.debug("copy: {}", (Object)folder);
        return folder;
    }

    public static GWTVersion copy(Version version) {
        log.debug("copy({})", (Object)version);
        GWTVersion gWTVersion = new GWTVersion();
        gWTVersion.setCreated(version.getCreated().getTime());
        gWTVersion.setName(version.getName());
        gWTVersion.setSize(version.getSize());
        gWTVersion.setAuthor(version.getAuthor());
        gWTVersion.setActual(version.isActual());
        gWTVersion.setComment(version.getComment());
        log.debug("copy: {}", (Object)gWTVersion);
        return gWTVersion;
    }

    public static Version copy(GWTVersion gWTVersion) {
        log.debug("copy({})", (Object)gWTVersion);
        Version version = new Version();
        Calendar cal = Calendar.getInstance();
        version.setName(gWTVersion.getName());
        version.setSize(gWTVersion.getSize());
        version.setAuthor(gWTVersion.getAuthor());
        version.setActual(gWTVersion.isActual());
        cal.setTime(gWTVersion.getCreated());
        version.setCreated(cal);
        version.setComment(gWTVersion.getComment());
        log.debug("copy: {}", (Object)version);
        return version;
    }

    public static GWTLock copy(Lock lock) {
        log.debug("copy({})", (Object)lock);
        GWTLock gWTLock = new GWTLock();
        if (lock != null) {
            gWTLock.setNodePath(lock.getNodePath());
            gWTLock.setOwner(lock.getOwner());
            gWTLock.setToken(lock.getToken());
        }
        log.debug("copy: {}", (Object)gWTLock);
        return gWTLock;
    }

    public static GWTBookmark copy(Bookmark bookmark) {
        log.debug("copy({})", (Object)bookmark);
        GWTBookmark gWTBookmark = new GWTBookmark();
        if (bookmark != null) {
            gWTBookmark.setId(bookmark.getId());
            gWTBookmark.setName(bookmark.getName());
            gWTBookmark.setPath(bookmark.getPath());
            gWTBookmark.setUuid(bookmark.getUuid());
            gWTBookmark.setType(bookmark.getType());
        }
        log.debug("copy: {}", (Object)gWTBookmark);
        return gWTBookmark;
    }

    public static String getParent(String path) {
        log.debug("getParent({})", (Object)path);
        int lastSlash = path.lastIndexOf(47);
        String ret = lastSlash > 0 ? path.substring(0, lastSlash) : "";
        log.debug("getParent: {}", (Object)ret);
        return ret;
    }

    public static String getName(String path) {
        log.debug("getName({})", (Object)path);
        String ret = path.substring(path.lastIndexOf(47) + 1);
        log.debug("getName: {}", (Object)ret);
        return ret;
    }

    public static QueryParams copy(GWTQueryParams gWTParams) {
        QueryParams params = new QueryParams();
        params.setId(gWTParams.getId());
        params.setQueryName(gWTParams.getQueryName());
        params.setContent(gWTParams.getContent());
        String keywords = gWTParams.getKeywords().trim();
        HashSet<String> tmpKwd = new HashSet<String>();
        if (!keywords.equals("")) {
            String[] kw = keywords.split(" ");
            for (int i = 0; i < kw.length; ++i) {
                tmpKwd.add(kw[i]);
            }
        }
        params.setKeywords(tmpKwd);
        params.setMimeType(gWTParams.getMimeType());
        params.setName(gWTParams.getName());
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String key : gWTParams.getProperties().keySet()) {
            properties.put(key, gWTParams.getProperties().get(key).getValue());
        }
        params.setProperties(properties);
        params.setPath(gWTParams.getPath());
        String categories = gWTParams.getCategoryUuid().trim();
        HashSet<String> tmpCat = new HashSet<String>();
        if (!categories.equals("")) {
            tmpCat.add(categories);
        }
        params.setCategories(tmpCat);
        params.setAuthor(gWTParams.getAuthor());
        Calendar lastModifiedFrom = Calendar.getInstance();
        Calendar lastModifiedTo = Calendar.getInstance();
        if (gWTParams.getLastModifiedFrom() != null && gWTParams.getLastModifiedTo() != null) {
            lastModifiedFrom.setTime(gWTParams.getLastModifiedFrom());
            lastModifiedTo.setTime(gWTParams.getLastModifiedTo());
        } else {
            lastModifiedFrom = null;
            lastModifiedTo = null;
        }
        params.setLastModifiedFrom(lastModifiedFrom);
        params.setLastModifiedTo(lastModifiedTo);
        params.setDashboard(gWTParams.isDashboard());
        params.setDomain(gWTParams.getDomain());
        params.setMailSubject(gWTParams.getMailSubject());
        params.setMailTo(gWTParams.getMailTo());
        params.setMailFrom(gWTParams.getMailFrom());
        params.setOperator(gWTParams.getOperator());
        return params;
    }

    public static GWTQueryResult copy(QueryResult queryResult) {
        GWTQueryResult gwtQueryResult = new GWTQueryResult();
        if (queryResult.getDocument() != null) {
            gwtQueryResult.setDocument(GWTUtil.copy(queryResult.getDocument()));
            gwtQueryResult.getDocument().setAttachment(false);
        } else if (queryResult.getFolder() != null) {
            gwtQueryResult.setFolder(GWTUtil.copy(queryResult.getFolder()));
        } else if (queryResult.getMail() != null) {
            gwtQueryResult.setMail(GWTUtil.copy(queryResult.getMail()));
        } else if (queryResult.getAttachment() != null) {
            gwtQueryResult.setAttachment(GWTUtil.copy(queryResult.getAttachment()));
            gwtQueryResult.getAttachment().setAttachment(true);
        }
        gwtQueryResult.setScore(queryResult.getScore());
        return gwtQueryResult;
    }

    public static GWTQueryParams copy(QueryParams params) throws RepositoryException, IOException, PathNotFoundException, ParseException, DatabaseException {
        GWTQueryParams gWTParams = new GWTQueryParams();
        gWTParams.setId(params.getId());
        gWTParams.setQueryName(params.getQueryName());
        gWTParams.setContent(params.getContent());
        String tmp = "";
        Iterator<String> itKwd = params.getKeywords().iterator();
        while (itKwd.hasNext()) {
            tmp = tmp + itKwd.next() + " ";
        }
        gWTParams.setKeywords(tmp);
        gWTParams.setMimeType(params.getMimeType());
        gWTParams.setName(params.getName());
        gWTParams.setPath(params.getPath());
        gWTParams.setAuthor(params.getAuthor());
        gWTParams.setDashboard(params.isDashboard());
        gWTParams.setDomain(params.getDomain());
        gWTParams.setMailSubject(params.getMailSubject());
        gWTParams.setMailFrom(params.getMailFrom());
        gWTParams.setMailTo(params.getMailTo());
        gWTParams.setOperator(params.getOperator());
        Iterator<String> itCat = params.getCategories().iterator();
        if (itCat.hasNext()) {
            gWTParams.setCategoryUuid(itCat.next());
        }
        if (params.getCategories() != null && !params.getCategories().isEmpty() && (itCat = params.getCategories().iterator()).hasNext()) {
            gWTParams.setCategoryPath(OKMRepository.getInstance().getNodePath(null, itCat.next()));
        }
        if (params.getLastModifiedFrom() != null && params.getLastModifiedTo() != null) {
            gWTParams.setLastModifiedFrom(params.getLastModifiedFrom().getTime());
            gWTParams.setLastModifiedTo(params.getLastModifiedTo().getTime());
        }
        HashMap<String, GWTPropertyParams> finalProperties = new HashMap<String, GWTPropertyParams>();
        Map<String, String> properties = params.getProperties();
        Set<String> colKeys = properties.keySet();
        for (String key : colKeys) {
            boolean found = false;
            List<PropertyGroup> colGroups = OKMPropertyGroup.getInstance().getAllGroups(null);
            Iterator itGroup = colGroups.iterator();
            block2: while (itGroup.hasNext() && !found) {
                PropertyGroup group = (PropertyGroup)itGroup.next();
                List<FormElement> metaData = OKMPropertyGroup.getInstance().getPropertyGroupForm(null, group.getName());
                for (FormElement formElement : metaData) {
                    if (!formElement.getName().equals(key)) continue;
                    found = true;
                    GWTPropertyParams gWTPropertyParams = new GWTPropertyParams();
                    gWTPropertyParams.setGrpName(group.getName());
                    gWTPropertyParams.setGrpLabel(group.getLabel());
                    gWTPropertyParams.setFormElement(GWTUtil.copy(formElement));
                    gWTPropertyParams.setValue(properties.get(key));
                    finalProperties.put(key, gWTPropertyParams);
                    continue block2;
                }
            }
        }
        gWTParams.setProperties(finalProperties);
        return gWTParams;
    }

    public static GWTDashboardDocumentResult copy(DashboardDocumentResult dsDocumentResult) {
        GWTDashboardDocumentResult gwtDashboardDocumentResult = new GWTDashboardDocumentResult();
        gwtDashboardDocumentResult.setDocument(GWTUtil.copy(dsDocumentResult.getDocument()));
        gwtDashboardDocumentResult.setVisited(dsDocumentResult.isVisited());
        gwtDashboardDocumentResult.setDate(dsDocumentResult.getDate().getTime());
        return gwtDashboardDocumentResult;
    }

    public static GWTDashboardFolderResult copy(DashboardFolderResult dsFolderResult) {
        GWTDashboardFolderResult gwtDashboardFolderResult = new GWTDashboardFolderResult();
        gwtDashboardFolderResult.setFolder(GWTUtil.copy(dsFolderResult.getFolder()));
        gwtDashboardFolderResult.setVisited(dsFolderResult.isVisited());
        gwtDashboardFolderResult.setDate(dsFolderResult.getDate().getTime());
        return gwtDashboardFolderResult;
    }

    public static GWTDashboardMailResult copy(DashboardMailResult dsmailResult) {
        GWTDashboardMailResult gwtDashboardMailResult = new GWTDashboardMailResult();
        gwtDashboardMailResult.setMail(GWTUtil.copy(dsmailResult.getMail()));
        gwtDashboardMailResult.setVisited(dsmailResult.isVisited());
        gwtDashboardMailResult.setDate(dsmailResult.getDate().getTime());
        return gwtDashboardMailResult;
    }

    public static GWTProcessDefinition copy(ProcessDefinition processDefinition) {
        GWTProcessDefinition gWTProcessDefinition = new GWTProcessDefinition();
        gWTProcessDefinition.setId(processDefinition.getId());
        gWTProcessDefinition.setName(processDefinition.getName());
        gWTProcessDefinition.setVersion(processDefinition.getVersion());
        gWTProcessDefinition.setDescription(processDefinition.getDescription());
        return gWTProcessDefinition;
    }

    public static GWTTaskInstance copy(TaskInstance taskInstance) throws PathNotFoundException, RepositoryException, DatabaseException {
        GWTTaskInstance gWTTaskInstance = new GWTTaskInstance();
        gWTTaskInstance.setActorId(taskInstance.getActorId());
        gWTTaskInstance.setCreate(taskInstance.getCreate().getTime());
        gWTTaskInstance.setId(taskInstance.getId());
        gWTTaskInstance.setName(taskInstance.getName());
        gWTTaskInstance.setProcessInstance(GWTUtil.copy(taskInstance.getProcessInstance()));
        gWTTaskInstance.setDescription(taskInstance.getDescription());
        if (taskInstance.getDueDate() != null) {
            gWTTaskInstance.setDueDate(taskInstance.getDueDate().getTime());
        }
        if (taskInstance.getStart() != null) {
            gWTTaskInstance.setStart(taskInstance.getStart().getTime());
        }
        gWTTaskInstance.setComments(GWTUtil.copyComments(taskInstance.getComments()));
        if (taskInstance.getVariables() != null) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : taskInstance.getVariables().entrySet()) {
                variables.put(entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null);
            }
            gWTTaskInstance.setVariables(variables);
        }
        return gWTTaskInstance;
    }

    public static GWTProcessInstance copy(ProcessInstance processInstance) throws PathNotFoundException, RepositoryException, DatabaseException {
        GWTProcessInstance gWTProcessInstance = new GWTProcessInstance();
        gWTProcessInstance.setEnded(processInstance.isEnded());
        gWTProcessInstance.setId(processInstance.getId());
        gWTProcessInstance.setProcessDefinition(GWTUtil.copy(processInstance.getProcessDefinition()));
        gWTProcessInstance.setSuspended(processInstance.isSuspended());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (String key : processInstance.getVariables().keySet()) {
            Object obj = processInstance.getVariables().get(key);
            if (obj instanceof FormElement) {
                variables.put(key, GWTUtil.copy((FormElement)obj));
                continue;
            }
            variables.put(key, obj);
        }
        gWTProcessInstance.setVariables(variables);
        gWTProcessInstance.setVersion(processInstance.getVersion());
        gWTProcessInstance.setStart(processInstance.getStart().getTime());
        gWTProcessInstance.setKey(processInstance.getKey());
        gWTProcessInstance.setRootToken(GWTUtil.copy(processInstance.getRootToken()));
        processInstance.getRootToken();
        return gWTProcessInstance;
    }

    public static GWTToken copy(Token token) throws PathNotFoundException, RepositoryException, DatabaseException {
        GWTToken gWTToken = new GWTToken();
        ArrayList<GWTTransition> availableTransitions = new ArrayList<GWTTransition>();
        Iterator<Transition> it = token.getAvailableTransitions().iterator();
        while (it.hasNext()) {
            availableTransitions.add(GWTUtil.copy(it.next()));
        }
        gWTToken.setAvailableTransitions(availableTransitions);
        ArrayList<GWTWorkflowComment> comments = new ArrayList<GWTWorkflowComment>();
        Iterator<Comment> it2 = token.getComments().iterator();
        while (it2.hasNext()) {
            comments.add(GWTUtil.copy(it2.next()));
        }
        gWTToken.setComments(comments);
        if (token.getEnd() != null) {
            gWTToken.setEnd(token.getEnd().getTime());
        }
        gWTToken.setId(token.getId());
        gWTToken.setName(token.getName());
        gWTToken.setNode(token.getNode());
        if (token.getParent() != null) {
            gWTToken.setParent(GWTUtil.copy(token.getParent()));
        }
        if (token.getProcessInstance() != null) {
            gWTToken.setProcessInstance(GWTUtil.copy(token.getProcessInstance()));
        }
        gWTToken.setStart(token.getStart().getTime());
        gWTToken.setSuspended(token.isSuspended());
        return gWTToken;
    }

    public static GWTTransition copy(Transition transition) {
        GWTTransition gWTTransition = new GWTTransition();
        gWTTransition.setFrom(transition.getFrom());
        gWTTransition.setId(transition.getId());
        gWTTransition.setName(transition.getName());
        gWTTransition.setTo(transition.getTo());
        return gWTTransition;
    }

    public static GWTWorkflowComment copy(Comment comment) {
        GWTWorkflowComment gWTComment = new GWTWorkflowComment();
        gWTComment.setActorId(comment.getActorId());
        gWTComment.setMessage(comment.getMessage());
        gWTComment.setTime(comment.getTime().getTime());
        return gWTComment;
    }

    public static List<GWTValidator> copyValidators(List<Validator> validators) {
        ArrayList<GWTValidator> gwtValidatorsList = new ArrayList<GWTValidator>();
        for (Validator validator : validators) {
            gwtValidatorsList.add(GWTUtil.copy(validator));
        }
        return gwtValidatorsList;
    }

    public static List<GWTNode> copyNodes(List<Node> nodes) {
        ArrayList<GWTNode> gwtNodesList = new ArrayList<GWTNode>();
        for (Node node : nodes) {
            gwtNodesList.add(GWTUtil.copy(node));
        }
        return gwtNodesList;
    }

    public static GWTFormElement copy(FormElement formElement) throws PathNotFoundException, RepositoryException, DatabaseException {
        if (formElement instanceof Button) {
            GWTButton gWTButton = new GWTButton();
            gWTButton.setName(formElement.getName());
            gWTButton.setLabel(formElement.getLabel());
            gWTButton.setWidth(formElement.getWidth());
            gWTButton.setHeight(formElement.getHeight());
            Button button = (Button)formElement;
            gWTButton.setTransition(button.getTransition());
            gWTButton.setConfirmation(button.getConfirmation());
            gWTButton.setValidate(button.isValidate());
            return gWTButton;
        }
        if (formElement instanceof Input) {
            GWTInput gWTInput = new GWTInput();
            gWTInput.setName(formElement.getName());
            gWTInput.setLabel(formElement.getLabel());
            gWTInput.setWidth(formElement.getWidth());
            gWTInput.setHeight(formElement.getHeight());
            Input input = (Input)formElement;
            gWTInput.setReadonly(input.isReadonly());
            gWTInput.setValue(input.getValue());
            if (input.getType().equals("date") && !input.getValue().equals("")) {
                Calendar date = ISO8601.parse((String)input.getValue());
                if (date != null) {
                    gWTInput.setDate(date.getTime());
                } else {
                    log.warn("Input '{}' value should be in ISO8601 format: {}", (Object)input.getName(), (Object)input.getValue());
                }
            }
            if (input.getType().equals("folder") && !gWTInput.getValue().equals("")) {
                gWTInput.setFolder(GWTUtil.copy(OKMFolder.getInstance().getProperties(null, ((Input)formElement).getValue())));
            }
            gWTInput.setType(((Input)formElement).getType());
            gWTInput.setValidators(GWTUtil.copyValidators(input.getValidators()));
            gWTInput.setData(input.getData());
            return gWTInput;
        }
        if (formElement instanceof SuggestBox) {
            GWTSuggestBox gWTsuggestBox = new GWTSuggestBox();
            gWTsuggestBox.setName(formElement.getName());
            gWTsuggestBox.setLabel(formElement.getLabel());
            gWTsuggestBox.setWidth(formElement.getWidth());
            gWTsuggestBox.setHeight(formElement.getHeight());
            SuggestBox suggestBox = (SuggestBox)formElement;
            gWTsuggestBox.setReadonly(suggestBox.isReadonly());
            gWTsuggestBox.setValidators(GWTUtil.copyValidators(suggestBox.getValidators()));
            gWTsuggestBox.setValue(suggestBox.getValue());
            gWTsuggestBox.setDialogTitle(suggestBox.getDialogTitle());
            gWTsuggestBox.setTable(suggestBox.getTable());
            gWTsuggestBox.setFilterQuery(suggestBox.getFilterQuery());
            gWTsuggestBox.setValueQuery(suggestBox.getValueQuery());
            gWTsuggestBox.setFilterMinLen(suggestBox.getFilterMinLen());
            gWTsuggestBox.setData(suggestBox.getData());
            return gWTsuggestBox;
        }
        if (formElement instanceof CheckBox) {
            GWTCheckBox gWTCheckbox = new GWTCheckBox();
            gWTCheckbox.setName(formElement.getName());
            gWTCheckbox.setLabel(formElement.getLabel());
            CheckBox checkbox = (CheckBox)formElement;
            gWTCheckbox.setValue(checkbox.getValue());
            gWTCheckbox.setReadonly(checkbox.isReadonly());
            gWTCheckbox.setValidators(GWTUtil.copyValidators(checkbox.getValidators()));
            gWTCheckbox.setData(checkbox.getData());
            return gWTCheckbox;
        }
        if (formElement instanceof Select) {
            GWTSelect gWTselect = new GWTSelect();
            gWTselect.setName(formElement.getName());
            gWTselect.setLabel(formElement.getLabel());
            gWTselect.setWidth(formElement.getWidth());
            gWTselect.setHeight(formElement.getHeight());
            Select select = (Select)formElement;
            gWTselect.setType(select.getType());
            gWTselect.setReadonly(select.isReadonly());
            ArrayList<GWTOption> options = new ArrayList<GWTOption>();
            Iterator<Option> it = select.getOptions().iterator();
            while (it.hasNext()) {
                options.add(GWTUtil.copy(it.next()));
            }
            gWTselect.setOptions(options);
            gWTselect.setValidators(GWTUtil.copyValidators(select.getValidators()));
            gWTselect.setData(select.getData());
            gWTselect.setOptionsData(select.getOptionsData());
            return gWTselect;
        }
        if (formElement instanceof TextArea) {
            GWTTextArea gWTTextArea = new GWTTextArea();
            gWTTextArea.setName(formElement.getName());
            gWTTextArea.setLabel(formElement.getLabel());
            gWTTextArea.setWidth(formElement.getWidth());
            gWTTextArea.setHeight(formElement.getHeight());
            TextArea textArea = (TextArea)formElement;
            gWTTextArea.setValue(textArea.getValue());
            gWTTextArea.setReadonly(textArea.isReadonly());
            gWTTextArea.setValidators(GWTUtil.copyValidators(textArea.getValidators()));
            gWTTextArea.setData(textArea.getData());
            return gWTTextArea;
        }
        if (formElement instanceof Upload) {
            GWTUpload gWTUpload = new GWTUpload();
            gWTUpload.setName(formElement.getName());
            gWTUpload.setLabel(formElement.getLabel());
            gWTUpload.setWidth(formElement.getWidth());
            gWTUpload.setHeight(formElement.getHeight());
            Upload upload = (Upload)formElement;
            gWTUpload.setFolderPath(upload.getFolderPath());
            gWTUpload.setFolderUuid(upload.getFolderUuid());
            gWTUpload.setDocumentName(upload.getDocumentName());
            gWTUpload.setDocumentUuid(upload.getDocumentUuid());
            gWTUpload.setType(upload.getType());
            gWTUpload.setData(upload.getData());
            gWTUpload.setValidators(GWTUtil.copyValidators(upload.getValidators()));
            return gWTUpload;
        }
        if (formElement instanceof Text) {
            GWTText gWTtext = new GWTText();
            gWTtext.setName(formElement.getName());
            gWTtext.setLabel(formElement.getLabel());
            gWTtext.setHeight(formElement.getHeight());
            gWTtext.setWidth(formElement.getWidth());
            Text text = (Text)formElement;
            gWTtext.setData(text.getData());
            return gWTtext;
        }
        if (formElement instanceof Separator) {
            GWTSeparator separator = new GWTSeparator();
            separator.setName(formElement.getName());
            separator.setLabel(formElement.getLabel());
            separator.setHeight(formElement.getHeight());
            separator.setWidth(formElement.getWidth());
            return separator;
        }
        if (formElement instanceof Download) {
            GWTDownload gWTdownload = new GWTDownload();
            gWTdownload.setName(formElement.getName());
            gWTdownload.setLabel(formElement.getLabel());
            gWTdownload.setHeight(formElement.getHeight());
            gWTdownload.setWidth(formElement.getWidth());
            Download download = (Download)formElement;
            gWTdownload.setData(download.getData());
            gWTdownload.setValidators(GWTUtil.copyValidators(download.getValidators()));
            gWTdownload.setNodes(GWTUtil.copyNodes(download.getNodes()));
            return gWTdownload;
        }
        if (formElement instanceof Print) {
            GWTPrint gWTprint = new GWTPrint();
            gWTprint.setName(formElement.getName());
            gWTprint.setLabel(formElement.getLabel());
            gWTprint.setHeight(formElement.getHeight());
            gWTprint.setWidth(formElement.getWidth());
            Print download = (Print)formElement;
            gWTprint.setData(download.getData());
            gWTprint.setValidators(GWTUtil.copyValidators(download.getValidators()));
            gWTprint.setNodes(GWTUtil.copyNodes(download.getNodes()));
            return gWTprint;
        }
        return new GWTFormElement();
    }

    public static FormElement copy(GWTFormElement formElement) {
        if (formElement instanceof GWTButton) {
            Button button = new Button();
            button.setName(formElement.getName());
            GWTButton gWTButton = (GWTButton)formElement;
            button.setTransition(gWTButton.getTransition());
            button.setConfirmation(gWTButton.getConfirmation());
            button.setValidate(gWTButton.isValidate());
            return button;
        }
        if (formElement instanceof GWTInput) {
            Input input = new Input();
            input.setName(formElement.getName());
            GWTInput gWTInput = (GWTInput)formElement;
            input.setReadonly(gWTInput.isReadonly());
            if (gWTInput.getType().equals("text") || gWTInput.getType().equals("link") || gWTInput.getType().equals("folder")) {
                input.setValue(gWTInput.getValue());
            } else if (gWTInput.getType().equals("date") && gWTInput.getDate() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(((GWTInput)formElement).getDate());
                input.setValue(ISO8601.format((Calendar)cal));
            }
            input.setType(gWTInput.getType());
            input.setData(gWTInput.getData());
            return input;
        }
        if (formElement instanceof GWTSuggestBox) {
            SuggestBox suggestBox = new SuggestBox();
            suggestBox.setName(formElement.getName());
            GWTSuggestBox gWTSuggestBox = (GWTSuggestBox)formElement;
            suggestBox.setReadonly(gWTSuggestBox.isReadonly());
            suggestBox.setValue(gWTSuggestBox.getValue());
            suggestBox.setFilterQuery(gWTSuggestBox.getFilterQuery());
            suggestBox.setValueQuery(gWTSuggestBox.getValueQuery());
            suggestBox.setFilterMinLen(gWTSuggestBox.getFilterMinLen());
            suggestBox.setData(gWTSuggestBox.getData());
            return suggestBox;
        }
        if (formElement instanceof GWTCheckBox) {
            CheckBox checkbox = new CheckBox();
            checkbox.setLabel(formElement.getLabel());
            checkbox.setName(formElement.getName());
            GWTCheckBox gWTCheckBox = (GWTCheckBox)formElement;
            checkbox.setValue(gWTCheckBox.getValue());
            checkbox.setReadonly(gWTCheckBox.isReadonly());
            checkbox.setData(gWTCheckBox.getData());
            return checkbox;
        }
        if (formElement instanceof GWTSelect) {
            Select select = new Select();
            select.setName(formElement.getName());
            GWTSelect gWTSelect = (GWTSelect)formElement;
            select.setType(gWTSelect.getType());
            select.setReadonly(gWTSelect.isReadonly());
            ArrayList<Option> options = new ArrayList<Option>();
            for (GWTOption option : gWTSelect.getOptions()) {
                options.add(GWTUtil.copy(option));
                if (!option.isSelected()) continue;
                if ("simple".equals(select.getType())) {
                    select.setValue(option.getValue());
                    continue;
                }
                if ("".equals(select.getValue())) {
                    select.setValue(option.getValue());
                    continue;
                }
                select.setValue(select.getValue().concat(",").concat(option.getValue()));
            }
            select.setOptions(options);
            select.setData(gWTSelect.getData());
            select.setOptionsData(gWTSelect.getOptionsData());
            return select;
        }
        if (formElement instanceof GWTTextArea) {
            TextArea textArea = new TextArea();
            textArea.setName(formElement.getName());
            GWTTextArea gWTTextArea = (GWTTextArea)formElement;
            textArea.setValue(gWTTextArea.getValue());
            textArea.setReadonly(gWTTextArea.isReadonly());
            textArea.setData(gWTTextArea.getData());
            return textArea;
        }
        if (formElement instanceof GWTUpload) {
            Upload upload = new Upload();
            upload.setName(formElement.getName());
            GWTUpload gWTUpload = (GWTUpload)formElement;
            upload.setDocumentName(gWTUpload.getDocumentName());
            upload.setDocumentUuid(gWTUpload.getDocumentUuid());
            upload.setFolderPath(gWTUpload.getFolderPath());
            upload.setFolderUuid(gWTUpload.getFolderUuid());
            upload.setType(gWTUpload.getType());
            upload.setData(gWTUpload.getData());
            return upload;
        }
        if (formElement instanceof GWTText) {
            Text text = new Text();
            GWTText gWTText = (GWTText)formElement;
            text.setName(gWTText.getName());
            text.setLabel(gWTText.getLabel());
            text.setHeight(gWTText.getHeight());
            text.setWidth(gWTText.getWidth());
            text.setData(gWTText.getData());
            return text;
        }
        if (formElement instanceof GWTSeparator) {
            Separator separator = new Separator();
            GWTSeparator gWTSeparator = (GWTSeparator)formElement;
            separator.setName(gWTSeparator.getName());
            separator.setLabel(gWTSeparator.getLabel());
            separator.setHeight(gWTSeparator.getHeight());
            separator.setWidth(gWTSeparator.getWidth());
            return separator;
        }
        if (formElement instanceof GWTDownload) {
            Download download = new Download();
            GWTDownload gWTDownload = (GWTDownload)formElement;
            download.setName(gWTDownload.getName());
            download.setLabel(gWTDownload.getLabel());
            download.setHeight(gWTDownload.getHeight());
            download.setWidth(gWTDownload.getWidth());
            download.setData(gWTDownload.getData());
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (GWTNode gWTNode : gWTDownload.getNodes()) {
                nodes.add(GWTUtil.copy(gWTNode));
            }
            return download;
        }
        if (formElement instanceof GWTPrint) {
            Print print = new Print();
            GWTPrint gWTprint = (GWTPrint)formElement;
            print.setName(gWTprint.getName());
            print.setLabel(gWTprint.getLabel());
            print.setHeight(gWTprint.getHeight());
            print.setWidth(gWTprint.getWidth());
            print.setData(gWTprint.getData());
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (GWTNode gWTNode : gWTprint.getNodes()) {
                nodes.add(GWTUtil.copy(gWTNode));
            }
            return print;
        }
        return new FormElement();
    }

    public static Object getFormElementValue(GWTFormElement formElement) throws DatabaseException {
        if (formElement instanceof GWTButton) {
            return ((GWTButton)formElement).getLabel();
        }
        if (formElement instanceof GWTInput) {
            GWTInput input = (GWTInput)formElement;
            if ("date".equals(input.getType())) {
                return input.getDate();
            }
            return input.getValue();
        }
        if (formElement instanceof GWTSuggestBox) {
            GWTSuggestBox suggestBox = (GWTSuggestBox)formElement;
            String formatedQuery = MessageFormat.format(suggestBox.getValueQuery().replaceAll("'", "\\\""), suggestBox.getValue()).replaceAll("\"", "'");
            List<KeyValue> keyValues = KeyValueDAO.getKeyValues(Arrays.asList(suggestBox.getTable()), formatedQuery);
            if (!keyValues.isEmpty()) {
                return keyValues.get(0).getValue();
            }
            return "";
        }
        if (formElement instanceof GWTCheckBox) {
            return ((GWTCheckBox)formElement).getValue() ? "true" : "false";
        }
        if (formElement instanceof GWTSelect) {
            String value = "";
            for (GWTOption option : ((GWTSelect)formElement).getOptions()) {
                if (!option.isSelected()) continue;
                value = value + option.getLabel() + " ";
            }
            return value;
        }
        if (formElement instanceof GWTTextArea) {
            return ((GWTTextArea)formElement).getValue();
        }
        if (formElement instanceof GWTUpload) {
            return ((GWTButton)formElement).getLabel();
        }
        if (formElement instanceof GWTText) {
            return ((GWTText)formElement).getLabel();
        }
        if (formElement instanceof GWTSeparator) {
            return ((GWTSeparator)formElement).getLabel();
        }
        if (formElement instanceof GWTDownload) {
            GWTDownload download = (GWTDownload)formElement;
            String value = "";
            for (GWTNode node : download.getNodes()) {
                if (!value.equals("")) {
                    value = value + ",";
                }
                if (!node.getUuid().equals("")) {
                    value = value + node.getUuid();
                    continue;
                }
                value = value + node.getPath();
            }
            return value;
        }
        if (formElement instanceof GWTPrint) {
            GWTPrint print = (GWTPrint)formElement;
            String value = "";
            for (GWTNode node : print.getNodes()) {
                if (!value.equals("")) {
                    value = value + ",";
                }
                if (!node.getUuid().equals("")) {
                    value = value + node.getUuid();
                    continue;
                }
                value = value + node.getPath();
            }
            return value;
        }
        return "";
    }

    public static GWTValidator copy(Validator validator) {
        GWTValidator gWTValidator = new GWTValidator();
        gWTValidator.setParameter(validator.getParameter());
        gWTValidator.setType(validator.getType());
        return gWTValidator;
    }

    public static GWTNode copy(Node node) {
        GWTNode gWTNode = new GWTNode();
        gWTNode.setLabel(node.getLabel());
        gWTNode.setPath(node.getPath());
        gWTNode.setUuid(node.getUuid());
        return gWTNode;
    }

    public static Node copy(GWTNode gWTNode) {
        Node node = new Node();
        node.setLabel(gWTNode.getLabel());
        node.setPath(gWTNode.getPath());
        node.setUuid(gWTNode.getUuid());
        return node;
    }

    public static Option copy(GWTOption gWTOption) {
        Option option = new Option();
        option.setLabel(gWTOption.getLabel());
        option.setValue(gWTOption.getValue());
        option.setSelected(gWTOption.isSelected());
        return option;
    }

    public static GWTOption copy(Option option) {
        GWTOption gWTOption = new GWTOption();
        gWTOption.setLabel(option.getLabel());
        gWTOption.setValue(option.getValue());
        gWTOption.setSelected(option.isSelected());
        return gWTOption;
    }

    public static List<GWTComment> copyComments(List<Comment> list) {
        ArrayList<GWTComment> al = new ArrayList<GWTComment>();
        for (Comment comment : list) {
            GWTComment gWTComment = new GWTComment();
            gWTComment.setActorId(comment.getActorId());
            gWTComment.setMessage(comment.getMessage());
            gWTComment.setTime(comment.getTime().getTime());
            al.add(gWTComment);
        }
        return al;
    }

    public static List<GWTNote> copy(List<Note> commentList) {
        ArrayList<GWTNote> gWTCommentList = new ArrayList<GWTNote>();
        Iterator<Note> it = commentList.iterator();
        while (it.hasNext()) {
            gWTCommentList.add(GWTUtil.copy(it.next()));
        }
        return gWTCommentList;
    }

    public static GWTNote copy(Note note) {
        GWTNote gWTNote = new GWTNote();
        gWTNote.setDate(note.getDate().getTime());
        gWTNote.setText(note.getText());
        gWTNote.setUser(note.getUser());
        gWTNote.setPath(note.getPath());
        return gWTNote;
    }

    public static GWTMail copy(Mail mail) {
        log.debug("copy({})", (Object)mail);
        GWTMail gWTMail = new GWTMail();
        ArrayList<GWTDocument> attachList = new ArrayList<GWTDocument>();
        Iterator<Document> it = mail.getAttachments().iterator();
        while (it.hasNext()) {
            attachList.add(GWTUtil.copy(it.next()));
        }
        gWTMail.setAttachments(attachList);
        gWTMail.setBcc(mail.getBcc());
        gWTMail.setCc(mail.getCc());
        gWTMail.setContent(mail.getContent());
        gWTMail.setFrom(mail.getFrom());
        gWTMail.setPath(mail.getPath());
        gWTMail.setPermissions(mail.getPermissions());
        gWTMail.setReceivedDate(mail.getReceivedDate().getTime());
        gWTMail.setReply(mail.getReply());
        gWTMail.setSentDate(mail.getSentDate().getTime());
        gWTMail.setSize(mail.getSize());
        gWTMail.setSubject(mail.getSubject());
        gWTMail.setTo(mail.getTo());
        gWTMail.setUuid(mail.getUuid());
        gWTMail.setParent(GWTUtil.getParent(mail.getPath()));
        gWTMail.setMimeType(mail.getMimeType());
        log.debug("copy: {}", (Object)gWTMail);
        return gWTMail;
    }

    public static GWTPropertyGroup copy(PropertyGroup property) {
        GWTPropertyGroup gWTPropertyGroup = new GWTPropertyGroup();
        gWTPropertyGroup.setLabel(property.getLabel());
        gWTPropertyGroup.setName(property.getName());
        gWTPropertyGroup.setVisible(property.isVisible());
        gWTPropertyGroup.setReadonly(property.isReadonly());
        return gWTPropertyGroup;
    }

    public static GWTUserConfig copy(UserConfig userCopy) {
        GWTUserConfig gWTUserConfig = new GWTUserConfig();
        gWTUserConfig.setHomePath(userCopy.getHomePath());
        gWTUserConfig.setHomeType(userCopy.getHomeType());
        gWTUserConfig.setHomeUuid(userCopy.getHomeUuid());
        gWTUserConfig.setUser(userCopy.getUser());
        return gWTUserConfig;
    }

    public static GWTStapleGroup copy(StapleGroup sg) throws RepositoryException, DatabaseException, PathNotFoundException {
        GWTStapleGroup gsg = new GWTStapleGroup();
        gsg.setId(sg.getId());
        gsg.setUser(sg.getUser());
        for (Staple st : sg.getStaples()) {
            GWTStaple gst = new GWTStaple();
            gst.setId(st.getId());
            gst.setType(st.getType());
            try {
                String path;
                if (st.getType().equals("okm:document")) {
                    path = OKMDocument.getInstance().getPath(null, st.getUuid());
                    gst.setDoc(GWTUtil.copy(OKMDocument.getInstance().getProperties(null, path)));
                } else if (st.getType().equals("okm:folder")) {
                    path = OKMFolder.getInstance().getPath(null, st.getUuid());
                    gst.setFolder(GWTUtil.copy(OKMFolder.getInstance().getProperties(null, path)));
                } else if (st.getType().equals("okm:mail")) {
                    path = OKMMail.getInstance().getPath(null, st.getUuid());
                    gst.setMail(GWTUtil.copy(OKMMail.getInstance().getProperties(null, path)));
                }
                gsg.getStaples().add(gst);
            }
            catch (AccessDeniedException e) {}
        }
        return gsg;
    }

    public static GWTLanguage copy(Language language) {
        GWTLanguage gWTlang = new GWTLanguage();
        gWTlang.setId(language.getId());
        gWTlang.setName(language.getName());
        return gWTlang;
    }

    public static GWTProposedSubscriptionReceived copy(ProposedSubscriptionReceived ps) {
        GWTProposedSubscriptionReceived gWTProposedSubscription = new GWTProposedSubscriptionReceived();
        gWTProposedSubscription.setId(ps.getId());
        gWTProposedSubscription.setFrom(ps.getFrom());
        gWTProposedSubscription.setTo(ps.getTo());
        gWTProposedSubscription.setUuid(ps.getUuid());
        gWTProposedSubscription.setPath(ps.getPath());
        gWTProposedSubscription.setType(ps.getType());
        gWTProposedSubscription.setComment(ps.getComment());
        gWTProposedSubscription.setAccepted(ps.isAccepted());
        gWTProposedSubscription.setSentDate(ps.getSentDate().getTime());
        if (ps.getSeenDate() != null) {
            gWTProposedSubscription.setSeenDate(ps.getSeenDate().getTime());
        }
        return gWTProposedSubscription;
    }

    public static GWTProposedSubscriptionSent copy(ProposedSubscriptionSent ps) {
        GWTProposedSubscriptionSent gWTProposedSubscription = new GWTProposedSubscriptionSent();
        gWTProposedSubscription.setId(ps.getId());
        gWTProposedSubscription.setFrom(ps.getFrom());
        gWTProposedSubscription.setTo(ps.getTo());
        gWTProposedSubscription.setUuid(ps.getUuid());
        gWTProposedSubscription.setPath(ps.getPath());
        gWTProposedSubscription.setType(ps.getType());
        gWTProposedSubscription.setComment(ps.getComment());
        gWTProposedSubscription.setSentDate(ps.getSentDate().getTime());
        return gWTProposedSubscription;
    }

    public static GWTProposedQueryReceived copy(ProposedQueryReceived pq, QueryParams params) throws RepositoryException, IOException, PathNotFoundException, ParseException, DatabaseException {
        GWTProposedQueryReceived gWTProposedQuery = new GWTProposedQueryReceived();
        gWTProposedQuery.setAccepted(pq.isAccepted());
        gWTProposedQuery.setComment(pq.getComment());
        gWTProposedQuery.setFrom(pq.getFrom());
        gWTProposedQuery.setTo(pq.getTo());
        gWTProposedQuery.setUser(pq.getUser());
        gWTProposedQuery.setId(pq.getId());
        gWTProposedQuery.setSentDate(pq.getSentDate().getTime());
        if (pq.getSeenDate() != null) {
            gWTProposedQuery.setSeenDate(pq.getSeenDate().getTime());
        }
        gWTProposedQuery.setParams(GWTUtil.copy(params));
        return gWTProposedQuery;
    }

    public static GWTProposedQuerySent copy(ProposedQuerySent pq, QueryParams params) throws RepositoryException, IOException, PathNotFoundException, ParseException, DatabaseException {
        GWTProposedQuerySent gWTProposedQuery = new GWTProposedQuerySent();
        gWTProposedQuery.setComment(pq.getComment());
        gWTProposedQuery.setFrom(pq.getFrom());
        gWTProposedQuery.setTo(pq.getTo());
        gWTProposedQuery.setUser(pq.getUser());
        gWTProposedQuery.setId(pq.getId());
        gWTProposedQuery.setSentDate(pq.getSentDate().getTime());
        gWTProposedQuery.setParams(GWTUtil.copy(params));
        return gWTProposedQuery;
    }

    public static GWTTextMessageSent copy(MessageSent ms) {
        GWTTextMessageSent gWTMessageSent = new GWTTextMessageSent();
        gWTMessageSent.setContent(ms.getContent());
        gWTMessageSent.setFrom(ms.getFrom());
        gWTMessageSent.setUser(ms.getUser());
        gWTMessageSent.setId(ms.getId());
        gWTMessageSent.setSentDate(ms.getSentDate().getTime());
        gWTMessageSent.setSubject(ms.getSubject());
        gWTMessageSent.setTo(ms.getTo());
        return gWTMessageSent;
    }

    public static GWTMessageReceived copy(MessageReceived mr) {
        GWTMessageReceived gWTMessageReceived = new GWTMessageReceived();
        gWTMessageReceived.setContent(mr.getContent());
        gWTMessageReceived.setFrom(mr.getFrom());
        gWTMessageReceived.setId(mr.getId());
        if (mr.getSeenDate() != null) {
            gWTMessageReceived.setSeenDate(mr.getSeenDate().getTime());
        }
        gWTMessageReceived.setSentDate(mr.getSentDate().getTime());
        gWTMessageReceived.setSubject(mr.getSubject());
        gWTMessageReceived.setTo(mr.getTo());
        gWTMessageReceived.setUser(mr.getUser());
        return gWTMessageReceived;
    }

    public static GWTStamp copy(StampText st) {
        GWTStamp gst = new GWTStamp();
        gst.setId(st.getId());
        gst.setName(st.getName());
        gst.setType(0);
        return gst;
    }

    public static GWTStamp copy(StampImage st) {
        GWTStamp gst = new GWTStamp();
        gst.setId(st.getId());
        gst.setName(st.getName());
        gst.setType(1);
        return gst;
    }

    public static Contact copy(GWTContact gWTContact) {
        Contact contact = new Contact();
        contact.setAddress(gWTContact.getAddress());
        contact.setCity(gWTContact.getCity());
        contact.setCountry(gWTContact.getCountry());
        contact.setFax(gWTContact.getFax());
        contact.setId(gWTContact.getId());
        contact.setMail(gWTContact.getMail());
        contact.setMobile(gWTContact.getMobile());
        contact.setName(gWTContact.getName());
        contact.setNotes(gWTContact.getNotes());
        contact.setPostalCode(gWTContact.getPostalCode());
        contact.setPhone(gWTContact.getPhone());
        contact.setProvince(gWTContact.getProvince());
        contact.setWeb(gWTContact.getWeb());
        contact.setExternalId(gWTContact.getExternalId());
        contact.setOrigin(gWTContact.getOrigin());
        return contact;
    }

    public static GWTContact copy(Contact contact, String uuid) {
        GWTContact gwtContact = new GWTContact();
        gwtContact.setAddress(contact.getAddress());
        gwtContact.setCity(contact.getCity());
        gwtContact.setCountry(contact.getCountry());
        gwtContact.setFax(contact.getFax());
        gwtContact.setId(contact.getId());
        gwtContact.setMail(contact.getMail());
        gwtContact.setMobile(contact.getMobile());
        gwtContact.setName(contact.getName());
        gwtContact.setNotes(contact.getNotes());
        gwtContact.setPostalCode(contact.getPostalCode());
        gwtContact.setPhone(contact.getPhone());
        gwtContact.setProvince(contact.getProvince());
        gwtContact.setWeb(contact.getWeb());
        return gwtContact;
    }

    public static GWTActivity copy(Activity activity) {
        GWTActivity gWTActivity = new GWTActivity();
        gWTActivity.setAction(activity.getAction());
        gWTActivity.setDate(activity.getDate().getTime());
        gWTActivity.setId(activity.getId());
        gWTActivity.setItem(activity.getItem());
        gWTActivity.setParams(activity.getParams());
        gWTActivity.setUser(activity.getUser());
        return gWTActivity;
    }

    public static GWTForum copy(Forum forum) {
        GWTForum f = new GWTForum();
        f.setActive(forum.isActive());
        f.setDate(forum.getDate().getTime());
        f.setDescription(forum.getDescription());
        f.setId(forum.getId());
        f.setLastPostDate(forum.getLastPostDate().getTime());
        f.setLastPostUser(forum.getLastPostUser());
        f.setName(forum.getName());
        f.setNumPosts(forum.getNumPosts());
        f.setNumTopics(forum.getNumTopics());
        for (ForumTopic topic : forum.getTopics()) {
            f.getTopics().add(GWTUtil.copy(topic));
        }
        return f;
    }

    public static GWTForumTopic copy(ForumTopic topic) {
        GWTForumTopic ft = new GWTForumTopic();
        ft.setDate(topic.getDate().getTime());
        ft.setId(topic.getId());
        ft.setReplies(topic.getReplies());
        ft.setLastPostDate(topic.getLastPostDate().getTime());
        ft.setLastPostUser(topic.getLastPostUser());
        ft.setTitle(topic.getTitle());
        ft.setUser(topic.getUser());
        ft.setUuid(topic.getUuid());
        ft.setViews(topic.getViews());
        Iterator<ForumPost> it = topic.getPosts().iterator();
        while (it.hasNext()) {
            ft.getPosts().add(GWTUtil.copy(it.next()));
        }
        return ft;
    }

    public static GWTForumPost copy(ForumPost post) {
        GWTForumPost fp = new GWTForumPost();
        fp.setDate(post.getDate().getTime());
        fp.setId(post.getId());
        fp.setMessage(post.getMessage());
        fp.setSubject(post.getSubject());
        fp.setUser(post.getUser());
        return fp;
    }

    public static Forum copy(GWTForum forum) {
        Forum f = new Forum();
        f.setActive(forum.isActive());
        Calendar cal = Calendar.getInstance();
        cal.setTime(forum.getDate());
        f.setDate(cal);
        f.setDescription(forum.getDescription());
        f.setId(forum.getId());
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(forum.getLastPostDate());
        f.setLastPostDate(cal2);
        f.setLastPostUser(forum.getLastPostUser());
        f.setName(forum.getName());
        f.setNumPosts(forum.getNumPosts());
        f.setNumTopics(forum.getNumTopics());
        for (GWTForumTopic topic : forum.getTopics()) {
            f.getTopics().add(GWTUtil.copy(topic));
        }
        return f;
    }

    public static ForumTopic copy(GWTForumTopic topic) {
        ForumTopic ft = new ForumTopic();
        Calendar date = Calendar.getInstance();
        date.setTime(topic.getDate());
        ft.setDate(date);
        ft.setId(topic.getId());
        ft.setReplies(topic.getReplies());
        Calendar lastDate = Calendar.getInstance();
        lastDate.setTime(topic.getLastPostDate());
        ft.setLastPostDate(lastDate);
        ft.setLastPostUser(topic.getLastPostUser());
        ft.setTitle(topic.getTitle());
        ft.setUser(topic.getUser());
        ft.setUuid(topic.getUuid());
        ft.setViews(topic.getViews());
        Iterator<GWTForumPost> it = topic.getPosts().iterator();
        while (it.hasNext()) {
            ft.getPosts().add(GWTUtil.copy(it.next()));
        }
        return ft;
    }

    public static ForumPost copy(GWTForumPost post) {
        ForumPost fp = new ForumPost();
        Calendar date = Calendar.getInstance();
        date.setTime(post.getDate());
        fp.setDate(date);
        fp.setId(post.getId());
        fp.setMessage(post.getMessage());
        fp.setSubject(post.getSubject());
        fp.setUser(post.getUser());
        return fp;
    }

    public static GWTKeyValue copy(KeyValue keyValue) {
        GWTKeyValue gWTKeyValue = new GWTKeyValue();
        gWTKeyValue.setKey(keyValue.getKey());
        gWTKeyValue.setValue(keyValue.getValue());
        return gWTKeyValue;
    }

    public static GWTReport copy(Report report, List<FormElement> formElements) throws PathNotFoundException, RepositoryException, DatabaseException {
        GWTReport gWTReport = new GWTReport();
        gWTReport.setActive(report.isActive());
        gWTReport.setFileContent(report.getFileContent());
        gWTReport.setFileMime(report.getFileMime());
        gWTReport.setFileName(report.getFileName());
        gWTReport.setId(report.getId());
        gWTReport.setName(report.getName());
        ArrayList<GWTFormElement> gWTFormElemets = new ArrayList<GWTFormElement>();
        for (FormElement formElement : formElements) {
            gWTFormElemets.add(GWTUtil.copy(formElement));
        }
        gWTReport.setFormElements(gWTFormElemets);
        return gWTReport;
    }
}

