/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.core.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jbpm.JbpmConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMUtils {
    private static Logger log = LoggerFactory.getLogger(JBPMUtils.class);
    private static JbpmConfiguration jbpmConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized JbpmConfiguration getConfig() {
        if (jbpmConfig == null) {
            File jbpmCfg = new File(Config.JBPM_CONFIG);
            FileInputStream fisJbpmCfg = null;
            try {
                fisJbpmCfg = new FileInputStream(jbpmCfg);
                log.info("Creating JBPM configuration from {}", (Object)jbpmCfg.getPath());
                jbpmConfig = JbpmConfiguration.parseInputStream((InputStream)fisJbpmCfg);
            }
            catch (FileNotFoundException e) {
                try {
                    log.info("Creating JBPM default configuration");
                    jbpmConfig = JbpmConfiguration.getInstance();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fisJbpmCfg);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fisJbpmCfg);
            }
            IOUtils.closeQuietly((InputStream)fisJbpmCfg);
        }
        return jbpmConfig;
    }

    public static synchronized void closeConfig() {
        if (jbpmConfig != null) {
            jbpmConfig.close();
            jbpmConfig = null;
        }
    }
}

