/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.api.OKMDocument;
import com.openkm.api.OKMFolder;
import com.openkm.api.OKMRepository;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.bean.Mail;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.ConversionException;
import com.openkm.core.DatabaseException;
import com.openkm.core.FileSizeExceededException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UnsupportedMimeTypeException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VirusDetectedException;
import com.openkm.dao.bean.MailAccount;
import com.openkm.dao.bean.MailFilter;
import com.openkm.dao.bean.MailFilterRule;
import com.openkm.extension.core.ExtensionException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.direct.DirectDocumentModule;
import com.openkm.module.direct.DirectMailModule;
import com.openkm.util.FileUtils;
import com.openkm.util.TemplateUtils;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.pop3.POP3Folder;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtils {
    private static Logger log = LoggerFactory.getLogger(MailUtils.class);

    public static void sendMessage(List<String> toAddress, String subject, String content) throws MessagingException {
        try {
            MailUtils.send(null, toAddress, subject, content, null);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (DatabaseException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void sendMessage(String toAddress, String subject, String content) throws MessagingException {
        try {
            ArrayList<String> toList = new ArrayList<String>();
            toList.add(toAddress);
            MailUtils.send(null, toList, subject, content, null);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (DatabaseException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void sendMessage(String fromAddress, List<String> toAddress, String subject, String content) throws MessagingException {
        try {
            MailUtils.send(fromAddress, toAddress, subject, content, null);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (DatabaseException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void sendMessage(String fromAddress, String toAddress, String subject, String content) throws MessagingException {
        try {
            ArrayList<String> toList = new ArrayList<String>();
            toList.add(toAddress);
            MailUtils.send(fromAddress, toList, subject, content, null);
        }
        catch (PathNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (DatabaseException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void sendDocument(String fromAddress, List<String> toAddress, String subject, String text, String docPath) throws MessagingException, PathNotFoundException, RepositoryException, IOException, DatabaseException {
        MailUtils.send(fromAddress, toAddress, subject, text, docPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void send(String fromAddress, List<String> toAddress, String subject, String text, String docPath) throws MessagingException, PathNotFoundException, RepositoryException, IOException, DatabaseException {
        log.debug("send({}, {}, {}, {}, {})", new Object[]{fromAddress, toAddress, subject, text, docPath});
        File tmpAttachment = File.createTempFile("okm", ".tmp");
        try {
            MimeMessage m = MailUtils.create(fromAddress, toAddress, subject, text, docPath, tmpAttachment);
            Transport.send((Message)m);
        }
        finally {
            FileUtils.deleteQuietly(tmpAttachment);
        }
        log.debug("send: void");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MimeMessage create(String fromAddress, List<String> toAddress, String subject, String text, String docPath, File tmpAttachment) throws MessagingException, PathNotFoundException, RepositoryException, IOException, DatabaseException {
        log.debug("create({}, {}, {}, {}, {})", new Object[]{fromAddress, toAddress, subject, text, docPath});
        Session mailSession = MailUtils.getMailSession();
        MimeMessage m = new MimeMessage(mailSession);
        if (fromAddress != null) {
            InternetAddress from = new InternetAddress(fromAddress);
            m.setFrom((Address)from);
        } else {
            m.setFrom();
        }
        InternetAddress[] to = new InternetAddress[toAddress.size()];
        int i = 0;
        Iterator<String> it = toAddress.iterator();
        while (it.hasNext()) {
            to[i++] = new InternetAddress(it.next());
        }
        m.addHeader("charset", "UTF-8");
        m.setRecipients(Message.RecipientType.TO, (Address[])to);
        m.setSubject(subject, "UTF-8");
        m.setSentDate(new Date());
        MimeMultipart content = new MimeMultipart("alternative");
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText(text.replaceAll("<br/?>", "\n").replaceAll("<[^>]*>", ""));
        textPart.setHeader("Content-Type", "text/plain; charset=UTF-8");
        content.addBodyPart((BodyPart)textPart);
        MimeBodyPart htmlPart = new MimeBodyPart();
        StringBuilder htmlContent = new StringBuilder();
        htmlContent.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        htmlContent.append("<html>\n<head>\n");
        htmlContent.append("<meta content=\"text/html;charset=UTF-8\" http-equiv=\"Content-Type\"/>\n");
        htmlContent.append("</head>\n<body>\n");
        htmlContent.append(text);
        htmlContent.append("\n</body>\n</html>");
        htmlPart.setContent((Object)htmlContent.toString(), "text/html; charset=UTF-8");
        htmlPart.setHeader("Content-Type", "text/html; charset=UTF-8");
        content.addBodyPart((BodyPart)htmlPart);
        if (docPath != null) {
            InputStream is = null;
            FileOutputStream fos = null;
            String docName = JCRUtils.getName(docPath);
            try {
                final Document doc = OKMDocument.getInstance().getProperties(null, docPath);
                is = OKMDocument.getInstance().getContent(null, docPath, false);
                fos = new FileOutputStream(tmpAttachment);
                IOUtils.copy((InputStream)is, (OutputStream)fos);
                fos.flush();
                MimeBodyPart docPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(tmpAttachment.getPath()){

                    public String getContentType() {
                        return doc.getMimeType();
                    }
                };
                docPart.setDataHandler(new DataHandler((DataSource)source));
                docPart.setFileName(docName);
                content.addBodyPart((BodyPart)docPart);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        m.setContent((Multipart)content);
        log.debug("create: {}", (Object)m);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeMessage create(String token, Mail mail) throws MessagingException, PathNotFoundException, RepositoryException, IOException, DatabaseException {
        MimeBodyPart textPart;
        log.debug("create({})", (Object)mail);
        Session mailSession = MailUtils.getMailSession();
        MimeMessage m = new MimeMessage(mailSession);
        if (mail.getFrom() != null) {
            InternetAddress from = new InternetAddress(mail.getFrom());
            m.setFrom((Address)from);
        } else {
            m.setFrom();
        }
        InternetAddress[] to = new InternetAddress[mail.getTo().length];
        int i = 0;
        for (String strTo : mail.getTo()) {
            to[i++] = new InternetAddress(strTo);
        }
        m.addHeader("charset", "UTF-8");
        m.setRecipients(Message.RecipientType.TO, (Address[])to);
        m.setSubject(mail.getSubject(), "UTF-8");
        m.setSentDate(new Date());
        MimeMultipart content = new MimeMultipart("alternative");
        if ("text/plain".equals(mail.getMimeType())) {
            textPart = new MimeBodyPart();
            textPart.setText(mail.getContent());
            textPart.setHeader("Content-Type", "text/plain");
            content.addBodyPart((BodyPart)textPart);
            MimeBodyPart htmlPart = new MimeBodyPart();
            StringBuilder htmlContent = new StringBuilder();
            htmlContent.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
            htmlContent.append("<html>\n<head>\n");
            htmlContent.append("<meta content=\"text/html;charset=UTF-8\" http-equiv=\"Content-Type\"/>\n");
            htmlContent.append("</head>\n<body>\n");
            htmlContent.append(mail.getContent());
            htmlContent.append("\n</body>\n</html>");
            htmlPart.setContent((Object)htmlContent.toString(), "text/html; charset=UTF-8");
            htmlPart.setHeader("Content-Type", "text/html");
            content.addBodyPart((BodyPart)htmlPart);
        } else if ("text/html".equals(mail.getMimeType())) {
            textPart = new MimeBodyPart();
            textPart.setText(mail.getContent().replaceAll("<br/?>", "\n").replaceAll("<[^>]*>", ""));
            textPart.setHeader("Content-Type", "text/plain");
            content.addBodyPart((BodyPart)textPart);
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)mail.getContent(), "text/html; charset=UTF-8");
            htmlPart.setHeader("Content-Type", "text/html");
            content.addBodyPart((BodyPart)htmlPart);
        } else {
            log.warn("Email does not specify content MIME type");
            textPart = new MimeBodyPart();
            textPart.setText(mail.getContent());
            textPart.setHeader("Content-Type", "text/plain");
            content.addBodyPart((BodyPart)textPart);
        }
        for (Document doc : mail.getAttachments()) {
            InputStream is = null;
            FileOutputStream fos = null;
            String docName = JCRUtils.getName(doc.getPath());
            try {
                is = OKMDocument.getInstance().getContent(token, doc.getPath(), false);
                File tmp = File.createTempFile("okm", ".tmp");
                fos = new FileOutputStream(tmp);
                IOUtils.copy((InputStream)is, (OutputStream)fos);
                fos.flush();
                MimeBodyPart docPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(tmp.getPath());
                docPart.setDataHandler(new DataHandler((DataSource)source));
                docPart.setFileName(docName);
                content.addBodyPart((BodyPart)docPart);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        m.setContent((Multipart)content);
        log.debug("create: {}", (Object)m);
        return m;
    }

    private static Session getMailSession() {
        Session mailSession = null;
        try {
            InitialContext initialContext = new InitialContext();
            Object obj = initialContext.lookup(Config.JNDI_BASE + "mail/OpenKM");
            mailSession = (Session)PortableRemoteObject.narrow((Object)obj, Session.class);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mailSession;
    }

    public static String importMessages(String uid, MailAccount ma) throws PathNotFoundException, ItemExistsException, VirusDetectedException, AccessDeniedException, RepositoryException, DatabaseException, UserQuotaExceededException, ExtensionException {
        log.debug("importMessages({}, {})", new Object[]{uid, ma});
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props);
        String exceptionMessage = null;
        try {
            Store store = session.getStore(ma.getMailProtocol());
            store.connect(ma.getMailHost(), ma.getMailUser(), ma.getMailPassword());
            javax.mail.Folder folder = store.getFolder(ma.getMailFolder());
            folder.open(2);
            Message[] messages = folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
            for (int i = 0; i < messages.length; ++i) {
                Message msg = messages[i];
                Calendar receivedDate = Calendar.getInstance();
                Calendar sentDate = Calendar.getInstance();
                if (msg.getReceivedDate() != null) {
                    receivedDate.setTime(msg.getReceivedDate());
                }
                if (msg.getSentDate() != null) {
                    sentDate.setTime(msg.getSentDate());
                }
                log.debug("{} -> {} - {}", new Object[]{i, msg.getSubject(), msg.getReceivedDate()});
                Mail mail = new Mail();
                String body = MailUtils.getText((Part)msg);
                if (body.charAt(0) == 'H') {
                    mail.setMimeType("text/html");
                } else if (body.charAt(0) == 'T') {
                    mail.setMimeType("text/plain");
                } else {
                    mail.setMimeType("unknown");
                }
                mail.setContent(body.substring(1));
                if (msg.getFrom().length > 0) {
                    mail.setFrom(MimeUtility.decodeText((String)msg.getFrom()[0].toString()));
                }
                mail.setSize(msg.getSize());
                mail.setSubject(msg.getSubject());
                mail.setTo(MailUtils.address2String(msg.getRecipients(Message.RecipientType.TO)));
                mail.setCc(MailUtils.address2String(msg.getRecipients(Message.RecipientType.CC)));
                mail.setBcc(MailUtils.address2String(msg.getRecipients(Message.RecipientType.BCC)));
                mail.setReceivedDate(receivedDate);
                mail.setSentDate(sentDate);
                if (ma.getMailFilters().isEmpty()) {
                    log.debug("Import in compatibility mode");
                    String mailPath = MailUtils.getUserMailPath(uid);
                    MailUtils.importMail(mailPath, true, folder, msg, ma, mail);
                } else {
                    for (MailFilter mf : ma.getMailFilters()) {
                        log.debug("MailFilter: {}", (Object)mf);
                        if (!MailUtils.checkRules(mail, mf.getFilterRules())) continue;
                        String mailPath = mf.getPath();
                        MailUtils.importMail(mailPath, mf.isGrouping(), folder, msg, ma, mail);
                    }
                }
                if (ma.isMailMarkSeen()) {
                    msg.setFlag(Flags.Flag.SEEN, true);
                } else {
                    msg.setFlag(Flags.Flag.SEEN, false);
                }
                if (!ma.isMailMarkDeleted()) continue;
                msg.setFlag(Flags.Flag.DELETED, true);
            }
            log.debug("Expunge: {}", (Object)ma.isMailMarkDeleted());
            folder.close(ma.isMailMarkDeleted());
            store.close();
        }
        catch (NoSuchProviderException e) {
            log.error(e.getMessage(), (Throwable)e);
            exceptionMessage = e.getMessage();
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
            exceptionMessage = e.getMessage();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            exceptionMessage = e.getMessage();
        }
        log.debug("importMessages: {}", (Object)exceptionMessage);
        return exceptionMessage;
    }

    private static void importMail(String mailPath, boolean grouping, javax.mail.Folder folder, Message msg, MailAccount ma, Mail mail) throws DatabaseException, RepositoryException, AccessDeniedException, ItemExistsException, PathNotFoundException, MessagingException, VirusDetectedException, UserQuotaExceededException, IOException, ExtensionException {
        String path;
        String systemToken = JcrSessionManager.getInstance().getSystemToken();
        OKMRepository okmRepository = OKMRepository.getInstance();
        String string = path = grouping ? MailUtils.createGroupPath(mailPath, mail.getReceivedDate()) : mailPath;
        if (ma.getMailProtocol().equals("pop3") || ma.getMailProtocol().equals("pop3s")) {
            mail.setPath(path + "/" + ((POP3Folder)folder).getUID(msg) + "-" + JCRUtils.escape(msg.getSubject()));
        } else {
            mail.setPath(path + "/" + ((IMAPFolder)folder).getUID(msg) + "-" + JCRUtils.escape(msg.getSubject()));
        }
        String newMailPath = JCRUtils.getParent(mail.getPath()) + "/" + JCRUtils.escape(JCRUtils.getName(mail.getPath()));
        log.debug("newMailPath: {}", (Object)newMailPath);
        if (!okmRepository.hasNode(systemToken, newMailPath)) {
            new DirectMailModule().create(systemToken, mail, ma.getUser());
            try {
                MailUtils.addAttachments(mail, (Part)msg, ma.getUser());
            }
            catch (UnsupportedMimeTypeException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            catch (FileSizeExceededException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            catch (UserQuotaExceededException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static boolean checkRules(Mail mail, Set<MailFilterRule> filterRules) {
        log.info("checkRules({}, {})", (Object)mail, filterRules);
        boolean ret = true;
        for (MailFilterRule fr : filterRules) {
            log.info("FilterRule: {}", (Object)fr);
            if (fr.isActive()) {
                if ("FROM".equals(fr.getField())) {
                    if ("CONTAINS".equals(fr.getOperation())) {
                        ret &= mail.getFrom().toLowerCase().contains(fr.getValue().toLowerCase());
                    } else if ("EQUALS".equals(fr.getOperation())) {
                        ret &= mail.getFrom().equalsIgnoreCase(fr.getValue());
                    }
                } else if ("TO".equals(fr.getField())) {
                    int j;
                    if ("CONTAINS".equals(fr.getOperation())) {
                        for (j = 0; j < mail.getTo().length; ++j) {
                            ret &= mail.getTo()[j].toLowerCase().contains(fr.getValue().toLowerCase());
                        }
                    } else if ("EQUALS".equals(fr.getOperation())) {
                        for (j = 0; j < mail.getTo().length; ++j) {
                            ret &= mail.getTo()[j].equalsIgnoreCase(fr.getValue());
                        }
                    }
                } else if ("SUBJECT".equals(fr.getField())) {
                    if ("CONTAINS".equals(fr.getOperation())) {
                        ret &= mail.getSubject().toLowerCase().contains(fr.getValue().toLowerCase());
                    } else if ("EQUALS".equals(fr.getOperation())) {
                        ret &= mail.getSubject().equalsIgnoreCase(fr.getValue());
                    }
                } else if ("CONTENT".equals(fr.getField())) {
                    if ("CONTAINS".equals(fr.getOperation())) {
                        ret &= mail.getContent().toLowerCase().contains(fr.getValue().toLowerCase());
                    } else if ("EQUALS".equals(fr.getOperation())) {
                        ret &= mail.getContent().equalsIgnoreCase(fr.getValue());
                    }
                }
            }
            log.info("FilterRule: {}", (Object)ret);
        }
        log.info("checkRules: {}", (Object)ret);
        return ret;
    }

    private static String createGroupPath(String mailPath, Calendar receivedDate) throws DatabaseException, RepositoryException, AccessDeniedException, ItemExistsException, PathNotFoundException, ExtensionException {
        Folder fld;
        log.debug("createGroupPath({}, {})", new Object[]{mailPath, receivedDate});
        String systemToken = JcrSessionManager.getInstance().getSystemToken();
        OKMRepository okmRepository = OKMRepository.getInstance();
        String path = mailPath + "/" + receivedDate.get(1);
        OKMFolder okmFolder = OKMFolder.getInstance();
        if (!okmRepository.hasNode(systemToken, path)) {
            fld = new Folder();
            fld.setPath(path);
            okmFolder.create(systemToken, fld);
        }
        if (!okmRepository.hasNode(systemToken, path = path + "/" + (receivedDate.get(2) + 1))) {
            fld = new Folder();
            fld.setPath(path);
            okmFolder.create(systemToken, fld);
        }
        if (!okmRepository.hasNode(systemToken, path = path + "/" + receivedDate.get(5))) {
            fld = new Folder();
            fld.setPath(path);
            okmFolder.create(systemToken, fld);
        }
        log.debug("createGroupPath: {}", (Object)path);
        return path;
    }

    private static String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            Object obj = p.getContent();
            String str = null;
            if (obj instanceof InputStream) {
                InputStream is = (InputStream)obj;
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
                str = writer.toString();
            } else {
                str = (String)obj;
            }
            if (p.isMimeType("text/html")) {
                return "H" + str;
            }
            if (p.isMimeType("text/plain")) {
                return "T" + str;
            }
            return "X" + str;
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                String s;
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/plain")) {
                    s = MailUtils.getText((Part)bp);
                    if (s == null) continue;
                    return s;
                }
                if (bp.isMimeType("text/html")) {
                    s = MailUtils.getText((Part)bp);
                    if (s == null) continue;
                    return s;
                }
                return MailUtils.getText((Part)bp);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = MailUtils.getText((Part)mp.getBodyPart(i));
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private static void addAttachments(Mail mail, Part p, String userId) throws MessagingException, IOException, UnsupportedMimeTypeException, FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, ItemExistsException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        String systemToken = JcrSessionManager.getInstance().getSystemToken();
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            for (int i = 1; i < count; ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.getFileName() == null) continue;
                Document attachment = new Document();
                String mimeType = Config.mimeTypes.getContentType(bp.getFileName().toLowerCase());
                attachment.setMimeType(mimeType);
                attachment.setPath(mail.getPath() + "/" + bp.getFileName());
                InputStream is = bp.getInputStream();
                new DirectDocumentModule().create(systemToken, attachment, is, userId);
                is.close();
            }
        }
    }

    private static String[] address2String(Address[] addresses) {
        ArrayList<String> list = new ArrayList<String>();
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                list.add(addresses[i].toString());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getUserMailPath(String uid) {
        return "/okm:mail/" + uid;
    }

    public static String getTinyUrl(String fullUrl) throws HttpException, IOException {
        int c;
        HttpClient httpclient = new HttpClient();
        GetMethod method = new GetMethod("http://tinyurl.com/api-create.php");
        method.setQueryString(new NameValuePair[]{new NameValuePair("url", fullUrl)});
        httpclient.executeMethod((HttpMethod)method);
        InputStreamReader isr = new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8");
        StringWriter sw = new StringWriter();
        while ((c = isr.read()) != -1) {
            sw.write(c);
        }
        isr.close();
        method.releaseConnection();
        return sw.toString();
    }

    public static void testConnection(MailAccount ma) throws IOException {
        log.debug("testConnection({})", (Object)ma);
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props);
        Store store = null;
        javax.mail.Folder folder = null;
        try {
            store = session.getStore(ma.getMailProtocol());
            store.connect(ma.getMailHost(), ma.getMailUser(), ma.getMailPassword());
            folder = store.getFolder(ma.getMailFolder());
            folder.open(2);
            folder.close(false);
        }
        catch (NoSuchProviderException e) {
            throw new IOException(e.getMessage());
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (folder != null && folder.isOpen()) {
                try {
                    folder.close(false);
                }
                catch (MessagingException e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (store != null) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
        log.debug("testConnection: void");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String mail2html(Mail mail) throws ConversionException {
        HashMap<String, String> hm = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mail.getTo().length - 1; ++i) {
            sb.append(mail.getTo()[i]).append(", ");
        }
        sb.append(mail.getTo()[mail.getTo().length - 1]);
        hm.put("mailTo", sb.toString());
        hm.put("mailFrom", mail.getFrom());
        hm.put("mailSubject", mail.getSubject());
        hm.put("mailContent", mail.getContent());
        StringWriter sw = new StringWriter();
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(MailUtils.class.getResourceAsStream("mail.ftl"));
            Template tpl = new Template("mail", (Reader)isr, TemplateUtils.getConfig());
            tpl.process(hm, (Writer)sw);
        }
        catch (IOException e) {
            try {
                throw new ConversionException("IOException: " + e.getMessage(), e);
                catch (TemplateException e2) {
                    throw new ConversionException("TemplateException: " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Writer)sw);
                IOUtils.closeQuietly(isr);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)sw);
        IOUtils.closeQuietly((Reader)isr);
        return sw.toString();
    }
}

