/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import bsh.EvalError;
import bsh.Interpreter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import com.openkm.util.TemplateUtils;
import de.svenjacobs.loremipsum.LoremIpsum;
import freemarker.template.TemplateException;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFUtils {
    private static Logger log = LoggerFactory.getLogger(PDFUtils.class);
    public static int LAYER_UNDER_CONTENT = 0;
    public static int LAYER_OVER_CONTENT = 1;

    public static void stampImage(InputStream input, byte[] image, OutputStream output) throws FileNotFoundException, DocumentException, EvalError, IOException {
        log.debug("stampImage({}, {}, {})", new Object[]{input, image, output});
        PDFUtils.stampImage(input, image, LAYER_UNDER_CONTENT, 0.3f, "PAGE_CENTER - IMAGE_WIDTH / 2", "PAGE_MIDDLE - IMAGE_HEIGHT / 2", output);
    }

    public static void stampImage(InputStream input, byte[] image, int layer, float opacity, String exprX, String exprY, OutputStream output) throws FileNotFoundException, DocumentException, EvalError, IOException {
        log.debug("stampImage({}, {}, {}, {}, {}, {}, {})", new Object[]{input, image, layer, Float.valueOf(opacity), exprX, exprY, output});
        Image img = Image.getInstance((byte[])image);
        PdfReader reader = new PdfReader(input);
        PdfStamper stamper = new PdfStamper(reader, output);
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(opacity);
        gs.setStrokeOpacity(opacity);
        int numPages = reader.getNumberOfPages();
        int count = 0;
        while (count++ < numPages) {
            Interpreter i = new Interpreter();
            i.set("IMAGE_WIDTH", (int)img.getWidth());
            i.set("IMAGE_HEIGHT", (int)img.getHeight());
            i.set("PAGE_WIDTH", (int)reader.getPageSizeWithRotation(count).getWidth());
            i.set("PAGE_HEIGHT", (int)reader.getPageSizeWithRotation(count).getHeight());
            i.set("PAGE_CENTER", (int)reader.getPageSizeWithRotation(count).getWidth() / 2);
            i.set("PAGE_MIDDLE", (int)reader.getPageSizeWithRotation(count).getHeight() / 2);
            int evalX = (Integer)i.eval(exprX);
            int evalY = (Integer)i.eval(exprY);
            log.debug("evalX: {}", (Object)evalX);
            log.debug("evalY: {}", (Object)evalY);
            img.setAbsolutePosition((float)evalX, (float)evalY);
            PdfContentByte cb = null;
            if (layer == LAYER_UNDER_CONTENT) {
                cb = stamper.getUnderContent(count);
            } else if (layer == LAYER_OVER_CONTENT) {
                cb = stamper.getOverContent(count);
            } else {
                throw new IllegalArgumentException();
            }
            cb.saveState();
            cb.setGState(gs);
            cb.addImage(img);
            cb.restoreState();
        }
        stamper.close();
    }

    public static void stampText(InputStream input, String text, OutputStream output) throws FileNotFoundException, DocumentException, EvalError, IOException {
        log.debug("stampText({}, {}, {})", new Object[]{input, text, output});
        PDFUtils.stampText(input, text, LAYER_UNDER_CONTENT, 0.5f, 100, Color.RED, 35, 1, "PAGE_CENTER", "PAGE_MIDDLE", output);
    }

    public static void stampText(InputStream input, String text, int layer, float opacity, int size, Color color, int rotation, int align, String exprX, String exprY, OutputStream output) throws FileNotFoundException, DocumentException, EvalError, IOException {
        log.debug("stampText({}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {})", new Object[]{input, text, layer, Float.valueOf(opacity), size, color, rotation, align, exprX, exprY, output});
        PdfReader reader = new PdfReader(input);
        PdfStamper stamper = new PdfStamper(reader, output);
        BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(opacity);
        gs.setStrokeOpacity(opacity);
        int numPages = reader.getNumberOfPages();
        int count = 0;
        while (count++ < numPages) {
            Interpreter i = new Interpreter();
            i.set("PAGE_WIDTH", (int)reader.getPageSizeWithRotation(count).getWidth());
            i.set("PAGE_HEIGHT", (int)reader.getPageSizeWithRotation(count).getHeight());
            i.set("PAGE_CENTER", (int)reader.getPageSizeWithRotation(count).getWidth() / 2);
            i.set("PAGE_MIDDLE", (int)reader.getPageSizeWithRotation(count).getHeight() / 2);
            int evalX = (Integer)i.eval(exprX);
            int evalY = (Integer)i.eval(exprY);
            log.debug("evalX: {}", (Object)evalX);
            log.debug("evalY: {}", (Object)evalY);
            PdfContentByte cb = null;
            if (layer == LAYER_UNDER_CONTENT) {
                cb = stamper.getUnderContent(count);
            } else if (layer == LAYER_OVER_CONTENT) {
                cb = stamper.getOverContent(count);
            } else {
                throw new IllegalArgumentException();
            }
            cb.saveState();
            cb.setColorFill(color);
            cb.setGState(gs);
            cb.beginText();
            cb.setFontAndSize(bf, (float)size);
            cb.showTextAligned(align, text, (float)evalX, (float)evalY, (float)rotation);
            cb.endText();
            cb.restoreState();
        }
        stamper.close();
        reader.close();
    }

    public static void fillForm(InputStream input, Map<String, Object> values, OutputStream output) throws FileNotFoundException, DocumentException, TemplateException, IOException {
        log.debug("fillForm({}, {}, {})", new Object[]{input, values, output});
        PdfReader reader = new PdfReader(input);
        PdfStamper stamper = new PdfStamper(reader, output);
        AcroFields fields = stamper.getAcroFields();
        PRAcroForm form = reader.getAcroForm();
        boolean formFlattening = false;
        if (form != null) {
            for (PRAcroForm.FieldInformation field : form.getFields()) {
                String fieldValue = fields.getField(field.getName());
                log.debug("Field: {}, Value: {}", (Object)field.getName(), (Object)fieldValue);
                if (fieldValue != null && !fieldValue.equals("")) {
                    if (!values.containsKey(field.getName())) continue;
                    String result = TemplateUtils.replace("PDF_FILL_FORM", fieldValue, values);
                    log.debug("Set to '{}'", (Object)result);
                    fields.setField(field.getName(), result);
                    stamper.partialFormFlattening(field.getName());
                    formFlattening = true;
                    continue;
                }
                Object value = values.get(field.getName());
                if (value == null) continue;
                log.debug("Set to '{}'", value);
                fields.setField(field.getName(), value.toString());
                stamper.partialFormFlattening(field.getName());
                formFlattening = true;
            }
        }
        stamper.setFormFlattening(formFlattening);
        stamper.close();
        reader.close();
    }

    public static List<String> listFormFields(String input) throws FileNotFoundException, DocumentException, IOException {
        log.debug("listFormFields({})", (Object)input);
        ArrayList<String> formFields = new ArrayList<String>();
        PdfReader reader = new PdfReader(input);
        PRAcroForm form = reader.getAcroForm();
        if (form != null) {
            for (PRAcroForm.FieldInformation field : form.getFields()) {
                formFields.add(field.getName());
            }
        }
        reader.close();
        log.debug("listFormFields: {}", formFields);
        return formFields;
    }

    public static void generateSample(int paragraphs, OutputStream os) throws DocumentException {
        LoremIpsum li = new LoremIpsum();
        Document doc = new Document(PageSize.A4, 25.0f, 25.0f, 25.0f, 25.0f);
        PdfWriter.getInstance((Document)doc, (OutputStream)os);
        doc.open();
        for (int i = 0; i < paragraphs; ++i) {
            doc.add((Element)new Paragraph(li.getParagraphs()));
        }
        doc.close();
    }
}

