/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.api.OKMDocument;
import com.openkm.api.OKMFolder;
import com.openkm.api.OKMRepository;
import com.openkm.bean.Folder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Populate {
    private static Logger log = LoggerFactory.getLogger(Populate.class);
    public static final List<String> DEFAULT_TYPES = Arrays.asList("pdf", "rtf", "doc", "ppt", "xls");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void massiveImport(String token, String seedWord, int numDocs, List<String> fileTypes, Writer out) throws Exception {
        OKMRepository okmRepository = OKMRepository.getInstance();
        final OKMDocument okmDocument = OKMDocument.getInstance();
        OKMFolder okmFolder = OKMFolder.getInstance();
        int n = 0;
        for (int typeIdx = 0; typeIdx < fileTypes.size(); ++typeIdx) {
            URL[] urls;
            String type = fileTypes.get(typeIdx);
            int offset = 0;
            while (n < numDocs * (typeIdx + 1) / fileTypes.size() && (urls = new Search(type, seedWord, offset).getURLs()).length != 0) {
                for (int i = 0; i < urls.length; ++i) {
                    final URL currentURL = urls[i];
                    String urlPath = currentURL.getPath();
                    if (urlPath.startsWith("/")) {
                        urlPath = urlPath.substring(1);
                    }
                    String host = urls[i].getHost();
                    ArrayList<String> folderNames = new ArrayList<String>();
                    folderNames.addAll(Arrays.asList(host.split("\\.")));
                    Collections.reverse(folderNames);
                    folderNames.addAll(Arrays.asList(urlPath.split("/", 0)));
                    String fileName = URLDecoder.decode((String)folderNames.remove(folderNames.size() - 1), "UTF-8").replaceAll(":", "_");
                    String path = okmRepository.getRootFolder(null).getPath();
                    Iterator fn = folderNames.iterator();
                    while (fn.hasNext()) {
                        String name = URLDecoder.decode((String)fn.next(), "UTF-8");
                        if ((name = name.replaceAll(":", "_")).length() == 0 || okmRepository.hasNode(null, path = path + "/" + name)) continue;
                        Folder fld = new Folder();
                        fld.setPath(path);
                        okmFolder.create(null, fld);
                    }
                    if (okmRepository.hasNode(null, path = path + "/" + fileName)) continue;
                    final Writer fOut = out;
                    final String docPath = path;
                    final Exception[] ex = new Exception[1];
                    final int nDoc = n;
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                URLConnection con = currentURL.openConnection();
                                InputStream in = con.getInputStream();
                                try {
                                    Writer writer = fOut;
                                    synchronized (writer) {
                                        fOut.write("<tr class=\"" + (nDoc % 2 == 0 ? "odd" : "even") + "\">");
                                        fOut.write("<td>" + nDoc + "</td>");
                                        fOut.write("<td>" + Text.encodeIllegalXMLCharacters((String)currentURL.toString()) + "</td>");
                                        fOut.flush();
                                    }
                                    int length = con.getContentLength();
                                    if (length != -1) {
                                        // empty if block
                                    }
                                    log.info("Create document: {}", (Object)docPath);
                                    com.openkm.bean.Document doc = new com.openkm.bean.Document();
                                    doc.setPath(docPath);
                                    okmDocument.create(null, doc, in);
                                }
                                finally {
                                    in.close();
                                }
                            }
                            catch (Exception e) {
                                ex[0] = e;
                            }
                        }
                    });
                    t.start();
                    int s = 0;
                    while (t.isAlive()) {
                        Thread.sleep(100L);
                        if (s % 10 == 0) {
                            Writer writer = fOut;
                            synchronized (writer) {
                            }
                        }
                        ++s;
                    }
                    if (ex[0] == null) {
                        ++n;
                        Writer writer = fOut;
                        synchronized (writer) {
                            fOut.write("<td>Ok</td></tr>");
                            fOut.flush();
                        }
                        if (n < numDocs * (typeIdx + 1) / fileTypes.size()) continue;
                        break;
                    }
                    fOut.write("<td>Error</td></tr>");
                    fOut.flush();
                }
                offset += 10;
            }
        }
    }

    static class Search {
        private final String filetype;
        private final String term;
        private final int start;

        public Search(String filetype, String term, int start) {
            this.filetype = filetype;
            this.term = term;
            this.start = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL[] getURLs() throws Exception {
            ArrayList<URL> urls = new ArrayList<URL>();
            String query = this.term + " filetype:" + this.filetype;
            URL google = new URL("http://www.google.com/search?q=" + URLEncoder.encode(query, "UTF-8") + "&start=" + this.start);
            URLConnection con = google.openConnection();
            con.setRequestProperty("User-Agent", "");
            InputStream in = con.getInputStream();
            try {
                HTMLEditorKit kit = new HTMLEditorKit();
                HTMLDocument doc = new HTMLDocument();
                doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                kit.read(new InputStreamReader(in, "UTF-8"), (Document)doc, 0);
                HTMLDocument.Iterator it = doc.getIterator(HTML.Tag.A);
                while (it.isValid()) {
                    URL url;
                    String href;
                    AttributeSet attr = it.getAttributes();
                    if (attr != null && (href = (String)attr.getAttribute(HTML.Attribute.HREF)) != null && href.endsWith("." + this.filetype) && (url = new URL(new URL("http", "www.google.com", "dummy"), href)).getHost().indexOf("google") == -1) {
                        urls.add(url);
                    }
                    it.next();
                }
            }
            finally {
                in.close();
            }
            return urls.toArray(new URL[urls.size()]);
        }
    }
}

