/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.core.Config;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;

public class PrincipalUtils {
    private static final long serialVersionUID = 1L;

    public static Subject getSubject() throws NamingException {
        InitialContext ctx = new InitialContext();
        return (Subject)ctx.lookup("java:comp/env/security/subject");
    }

    public static String getUser() throws NamingException {
        Subject subject = PrincipalUtils.getSubject();
        String user = null;
        for (Principal obj : subject.getPrincipals()) {
            if (obj instanceof Group) continue;
            Principal principal = obj;
            user = principal.getName();
        }
        return user;
    }

    public static Set<String> getRoles() throws NamingException {
        Subject subject = PrincipalUtils.getSubject();
        HashSet<String> roles = new HashSet<String>();
        for (Principal obj : subject.getPrincipals()) {
            if (!(obj instanceof Group)) continue;
            Group group = (Group)obj;
            Enumeration groups = group.members();
            while (groups.hasMoreElements()) {
                Principal rol = (Principal)groups.nextElement();
                roles.add(rol.getName());
            }
        }
        return roles;
    }

    public static boolean hasRole(String role) {
        try {
            Set<String> roles = PrincipalUtils.getRoles();
            if (roles != null) {
                return roles.contains(role);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return false;
    }

    public static void repairPermissions(Map<String, Byte> perms) {
        Byte value;
        if (perms.containsKey("AdminRole")) {
            value = perms.get("AdminRole");
            perms.remove("AdminRole");
            perms.put(Config.DEFAULT_ADMIN_ROLE, value);
        }
        if (perms.containsKey("UserRole")) {
            value = perms.get("UserRole");
            perms.remove("UserRole");
            perms.put(Config.DEFAULT_USER_ROLE, value);
        }
    }
}

