/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import bsh.EvalError;
import bsh.Interpreter;
import com.openkm.bean.form.FormElement;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.LegacyDAO;
import com.openkm.dao.ReportDAO;
import com.openkm.dao.bean.Report;
import com.openkm.util.FormUtils;
import com.openkm.util.SecureStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.io.IOUtils;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUtils {
    private static Logger log = LoggerFactory.getLogger(ReportUtils.class);
    public static Map<String, JasperReport> JasperCharged = new HashMap<String, JasperReport>();
    public static final int OUTPUT_TEXT = 0;
    public static final int OUTPUT_HTML = 1;
    public static final int OUTPUT_PDF = 2;
    public static final int OUTPUT_RTF = 3;
    public static final int OUTPUT_CSV = 4;
    public static final int OUTPUT_ODT = 5;
    public static final int OUTPUT_DOCX = 6;
    public static final String MIME_JASPER = "application/x-jasper";
    public static final String MIME_JRXML = "application/x-jrxml";
    public static final String MIME_REPORT = "application/x-report";
    public static final String MIME_TEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_PDF = "application/pdf";
    public static final String MIME_RTF = "application/rtf";
    public static final String MIME_CSV = "text/csv";
    public static final String MIME_ODT = "application/vnd.oasis.opendocument.text";
    public static final String MIME_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String[] FILE_MIME = new String[]{"text/plain", "text/html", "application/pdf", "application/rtf", "text/csv", "application/vnd.oasis.opendocument.text", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"};
    public static final String[] FILE_EXTENSION = new String[]{".txt", ".html", ".pdf", ".rtf", ".csv", ".odt", ".docx"};

    public static OutputStream generateReport(OutputStream out, String fileReport, Map<String, Object> parameters, int outputType, Collection<Map<String, Object>> list) throws Exception {
        if (!JasperCharged.containsKey(fileReport)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)cl.getResourceAsStream(fileReport));
                JasperCharged.put(fileReport, jasperReport);
            }
            catch (Exception e) {
                throw new Exception("Compiling error: " + e.getMessage());
            }
        }
        try {
            JasperReport jasperReport = JasperCharged.get(fileReport);
            JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)new JRMapCollectionDataSource(list));
            ReportUtils.export(out, outputType, print);
        }
        catch (JRException je) {
            throw new JRException("Error generating report", (Throwable)je);
        }
        return out;
    }

    public static OutputStream generateReport(OutputStream out, InputStream report, Map<String, Object> parameters, int outputType, Collection<Map<String, String>> list) throws JRException {
        JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)report);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)new JRMapCollectionDataSource(list));
        ReportUtils.export(out, outputType, print);
        return out;
    }

    public static OutputStream generateReport(OutputStream out, JasperReport jr, Map<String, Object> parameters, int outputType) throws JRException, EvalError {
        Interpreter bsh;
        JRQuery query = jr.getQuery();
        if (query != null) {
            bsh = new Interpreter(null, System.out, System.err, false);
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                bsh.set(entry.getKey(), entry.getValue());
            }
        } else {
            throw new JRException("Null report query string");
        }
        Collection list = (Collection)bsh.eval(query.getText());
        JasperPrint print = JasperFillManager.fillReport((JasperReport)jr, parameters, (JRDataSource)new JRMapCollectionDataSource(list));
        ReportUtils.export(out, outputType, print);
        return out;
    }

    public static OutputStream generateReport(OutputStream out, String fileReport, Map<String, Object> parameters, int outputType, Connection con) throws Exception {
        if (!JasperCharged.containsKey(fileReport)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)cl.getResourceAsStream(fileReport));
                JasperCharged.put(fileReport, jasperReport);
            }
            catch (Exception e) {
                throw new Exception("Compiling error: " + e.getMessage());
            }
        }
        try {
            JasperReport jasperReport = JasperCharged.get(fileReport);
            JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (Connection)con);
            ReportUtils.export(out, outputType, print);
        }
        catch (JRException je) {
            throw new JRException("Error generating report", (Throwable)je);
        }
        return out;
    }

    public static OutputStream generateReport(OutputStream out, JasperReport jr, Map<String, Object> parameters, int outputType, Connection con) throws JRException {
        JasperPrint print = JasperFillManager.fillReport((JasperReport)jr, parameters, (Connection)con);
        ReportUtils.export(out, outputType, print);
        return out;
    }

    private static void export(OutputStream out, int outputType, JasperPrint print) throws JRException {
        switch (outputType) {
            case 0: {
                JRTextExporter textExp = new JRTextExporter();
                textExp.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)300);
                textExp.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)100);
                textExp.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)80);
                textExp.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
                textExp.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                textExp.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
                textExp.exportReport();
                break;
            }
            case 2: {
                JRPdfExporter pdfExp = new JRPdfExporter();
                pdfExp.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                pdfExp.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
                pdfExp.exportReport();
                break;
            }
            case 1: {
                JRHtmlExporter htmlExp = new JRHtmlExporter();
                htmlExp.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
                htmlExp.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                htmlExp.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
                htmlExp.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
                htmlExp.exportReport();
                break;
            }
            case 3: {
                JRRtfExporter rtfExp = new JRRtfExporter();
                rtfExp.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
                rtfExp.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                rtfExp.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
                rtfExp.exportReport();
                break;
            }
            case 4: {
                JRCsvExporter csvExp = new JRCsvExporter();
                csvExp.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
                csvExp.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                csvExp.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
                csvExp.exportReport();
                break;
            }
            case 5: {
                JROdtExporter odtExp = new JROdtExporter();
                odtExp.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                odtExp.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
                odtExp.exportReport();
                break;
            }
            case 6: {
                JRDocxExporter docxExp = new JRDocxExporter();
                docxExp.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                docxExp.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
                docxExp.exportReport();
            }
        }
    }

    public static List<FormElement> getReportParameters(int rpId) throws ParseException, DatabaseException, IOException {
        log.debug("getReportParameters({})", (Object)rpId);
        ArrayList<FormElement> params = null;
        ByteArrayInputStream bais = null;
        ZipInputStream zis = null;
        try {
            Report rp = ReportDAO.findByPk(rpId);
            bais = new ByteArrayInputStream(SecureStore.b64Decode(rp.getFileContent()));
            zis = new ZipInputStream(bais);
            ZipEntry zi = null;
            while ((zi = zis.getNextEntry()) != null) {
                if (!"params.xml".equals(zi.getName())) continue;
                params = FormUtils.parseReportParameters(zis);
                break;
            }
            if (params == null) {
                params = new ArrayList();
                log.warn("Report '{}' has no params.xml file", (Object)rpId);
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zis);
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)zis);
        IOUtils.closeQuietly((InputStream)bais);
        log.debug("getReportParameters: {}", params);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream execute(Report rp, Map<String, Object> params, int format) throws JRException, IOException, EvalError {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        ZipInputStream zis = null;
        Session dbSession = null;
        Connection con = null;
        try {
            baos = new ByteArrayOutputStream();
            bais = new ByteArrayInputStream(SecureStore.b64Decode(rp.getFileContent()));
            JasperReport jr = null;
            if (MIME_JRXML.equals(rp.getFileMime())) {
                log.debug("Report type: JRXML");
                jr = JasperCompileManager.compileReport((InputStream)bais);
            } else if (MIME_JASPER.equals(rp.getFileMime())) {
                log.debug("Report type: JASPER");
                jr = (JasperReport)JRLoader.loadObject((InputStream)bais);
            } else if (MIME_REPORT.equals(rp.getFileMime())) {
                zis = new ZipInputStream(bais);
                ZipEntry zi = null;
                while ((zi = zis.getNextEntry()) != null) {
                    if (zi.isDirectory()) continue;
                    String mimeType = Config.mimeTypes.getContentType(zi.getName());
                    if (MIME_JRXML.equals(mimeType)) {
                        log.debug("Report type: JRXML inside ARCHIVE");
                        jr = JasperCompileManager.compileReport((InputStream)zis);
                        break;
                    }
                    if (!MIME_JASPER.equals(mimeType)) continue;
                    log.debug("Report type: JASPER inside ARCHIVE");
                    jr = (JasperReport)JRLoader.loadObject((InputStream)zis);
                    break;
                }
            }
            if (jr != null) {
                JRQuery query = jr.getQuery();
                String tq = query.getText().trim();
                if (tq.toUpperCase().startsWith("SELECT")) {
                    log.debug("Report type: DATABASE");
                    dbSession = HibernateUtil.getSessionFactory().openSession();
                    con = dbSession.connection();
                    ReportUtils.generateReport((OutputStream)baos, jr, params, format, con);
                } else {
                    log.debug("Report type: SCRIPTING");
                    ReportUtils.generateReport(baos, jr, params, format);
                }
            }
            byteArrayOutputStream = baos;
        }
        catch (Throwable throwable) {
            LegacyDAO.close(con);
            HibernateUtil.close(dbSession);
            IOUtils.closeQuietly(bais);
            IOUtils.closeQuietly((OutputStream)baos);
            IOUtils.closeQuietly(zis);
            throw throwable;
        }
        LegacyDAO.close(con);
        HibernateUtil.close(dbSession);
        IOUtils.closeQuietly((InputStream)bais);
        IOUtils.closeQuietly((OutputStream)baos);
        IOUtils.closeQuietly((InputStream)zis);
        return byteArrayOutputStream;
    }
}

