/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

public class ScriptingLock {
    private static ScriptingLock instance = new ScriptingLock();
    boolean isLocked = false;
    Thread lockedBy = null;
    int lockedCount = 0;

    public static ScriptingLock getInstance() {
        return instance;
    }

    public synchronized void lock() throws InterruptedException {
        Thread callingThread = Thread.currentThread();
        while (this.isLocked) {
            this.wait();
        }
        this.isLocked = true;
        ++this.lockedCount;
        this.lockedBy = callingThread;
    }

    public synchronized void unlock() {
        if (Thread.currentThread() == this.lockedBy) {
            --this.lockedCount;
            if (this.lockedCount == 0) {
                this.isLocked = false;
                this.notify();
            }
        }
    }
}

