/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class StackTraceUtils {
    public static StackTraceElement whoCalledMe() {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        if (trace.length >= 2) {
            return trace[2];
        }
        return null;
    }

    public static String getTrace() {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        StringBuilder sb = new StringBuilder();
        if (trace.length >= 2) {
            for (int i = 2; i < trace.length; ++i) {
                if (!trace[i].getClassName().startsWith("com.openkm")) continue;
                sb.append(trace[i]);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        IOUtils.closeQuietly((Writer)pw);
        IOUtils.closeQuietly((Writer)sw);
        return sw.toString();
    }
}

