/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.core.Config;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtils {
    private static Logger log = LoggerFactory.getLogger(Config.class);
    private static Configuration cfg = null;

    public static Configuration getConfig() {
        if (cfg == null) {
            try {
                cfg = new Configuration();
                cfg.setDirectoryForTemplateLoading(new File(Config.HOME_DIR));
                cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return cfg;
    }

    public static boolean templateExists(String name) {
        try {
            TemplateUtils.getConfig().getTemplate(name);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String replace(String name, String template, Map<String, Object> model) throws IOException, TemplateException {
        StringReader sr = new StringReader(template);
        Template tpl = new Template(name, (Reader)sr, cfg);
        StringWriter sw = new StringWriter();
        tpl.process(model, (Writer)sw);
        sw.close();
        sr.close();
        return sw.toString();
    }

    public static void replace(String name, InputStream input, Map<String, Object> model, OutputStream out) throws IOException, TemplateException {
        InputStreamReader isr = new InputStreamReader(input);
        Template tpl = new Template(name, (Reader)isr, cfg);
        OutputStreamWriter osw = new OutputStreamWriter(out);
        tpl.process(model, (Writer)osw);
        osw.close();
        isr.close();
    }
}

