/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.ActivityDAO;
import com.openkm.dao.bean.Activity;
import cz.solnet.activityLogger.ActivityProducer;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserActivity {
    private static Logger log = LoggerFactory.getLogger(UserActivity.class);
    private static ActivityProducer activityProducer;

    private static void sendActivityAsync(Activity activity) {
        if (activityProducer == null || !activityProducer.isInitialized()) {
            activityProducer = new ActivityProducer();
            activityProducer.init("ConnectionFactory", Config.ASYNC_ACTIVITY_LOGGING_JNDI_NAME);
        }
        if (activityProducer != null && activityProducer.isInitialized()) {
            activityProducer.send(activity);
        }
    }

    public static void log(String user, String action, String item, String params) {
        if (Config.ACTIVITY_LOGGING_EXCLUDE != null && Config.ACTIVITY_LOGGING_EXCLUDE.contains(action)) {
            return;
        }
        if (user != null && user.equalsIgnoreCase(Config.SILENT_USER)) {
            return;
        }
        try {
            Activity vo = new Activity();
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            vo.setDate(cal);
            vo.setUser(user);
            vo.setAction(action);
            vo.setItem(item);
            vo.setParams(params);
            log.debug(vo.toString());
            if (Config.ASYNC_ACTIVITY_LOGGING) {
                UserActivity.sendActivityAsync(vo);
            } else {
                ActivityDAO.create(vo);
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage());
        }
    }
}

