/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.bean.AppVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarUtils {
    private static Logger log = LoggerFactory.getLogger(WarUtils.class);
    private static AppVersion appVersion = new AppVersion();

    public static AppVersion getAppVersion() {
        return appVersion;
    }

    public static synchronized void setAppVersion(AppVersion newAppVersion) {
        appVersion = newAppVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized void readAppVersion(ServletContext sc) {
        FileInputStream fis;
        block7: {
            String appServerHome = sc.getRealPath("/");
            File manifestFile = new File(appServerHome, "META-INF/MANIFEST.MF");
            fis = null;
            try {
                fis = new FileInputStream(manifestFile);
                Manifest mf = new Manifest();
                mf.read(fis);
                Attributes atts = mf.getMainAttributes();
                String impVersion = atts.getValue("Implementation-Version");
                String impBuild = atts.getValue("Implementation-Build");
                log.info("Implementation-Version: " + impVersion);
                log.info("Implementation-Build: " + impBuild);
                if (impVersion == null || impBuild == null || impVersion.indexOf(46) <= 0) break block7;
                String[] version = impVersion.split("\\.");
                appVersion.setMajor(version[0]);
                appVersion.setMinor(version[1]);
                if (version.length > 2 && version[2] != null && !version[2].equals("")) {
                    appVersion.setMaintenance(version[2]);
                }
                appVersion.setBuild(impBuild);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                IOUtils.closeQuietly((InputStream)fis);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
    }
}

