/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtils {
    private static Logger log = LoggerFactory.getLogger(WebUtils.class);
    public static final String EMPTY_STRING = "";

    public static final String getString(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        String stringValue = EMPTY_STRING;
        if (value != null) {
            try {
                return new String(value.getBytes("ISO-8859-1"), "UTF-8").trim();
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return stringValue;
    }

    public static final String getString(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        String stringValue = defaultValue;
        if (value != null) {
            try {
                return new String(value.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return stringValue;
    }

    public static final List<String> getStringList(HttpServletRequest request, String name) {
        String[] value = request.getParameterValues(name);
        ArrayList<String> stringValue = new ArrayList<String>();
        if (value != null) {
            try {
                for (int i = 0; i < value.length; ++i) {
                    stringValue.add(new String(value[i].getBytes("ISO-8859-1"), "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return stringValue;
    }

    public static final int getInt(HttpServletRequest request, String name) {
        String strValue = request.getParameter(name);
        int intValue = 0;
        if (strValue != null && !EMPTY_STRING.equals(strValue)) {
            try {
                intValue = Integer.parseInt(strValue);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return intValue;
    }

    public static final int getInt(HttpServletRequest request, String name, int defaultValue) {
        String strValue = request.getParameter(name);
        int intValue = defaultValue;
        if (strValue != null && !EMPTY_STRING.equals(strValue)) {
            try {
                intValue = Integer.parseInt(strValue);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return intValue;
    }

    public static final List<Integer> getIntList(HttpServletRequest request, String name) {
        String[] value = request.getParameterValues(name);
        ArrayList<Integer> intValue = new ArrayList<Integer>();
        if (value != null) {
            try {
                for (int i = 0; i < value.length; ++i) {
                    intValue.add(Integer.parseInt(value[i]));
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return intValue;
    }

    public static final long getLong(HttpServletRequest request, String name) {
        String strValue = request.getParameter(name);
        long longValue = 0L;
        if (strValue != null && !EMPTY_STRING.equals(strValue)) {
            try {
                longValue = Long.parseLong(strValue);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return longValue;
    }

    public static final float getFloat(HttpServletRequest request, String name) {
        String strValue = request.getParameter(name);
        float floatValue = 0.0f;
        if (strValue != null && !EMPTY_STRING.equals(strValue)) {
            try {
                floatValue = Float.parseFloat(strValue);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return floatValue;
    }

    public static final boolean getBoolean(HttpServletRequest request, String name) {
        String strValue = request.getParameter(name);
        return strValue != null && !strValue.equals(EMPTY_STRING) && !strValue.equals("false");
    }

    public static final boolean getBoolean(HttpServletRequest request, String name, String trueValue) {
        String strValue = request.getParameter(name);
        return strValue != null && strValue.equals(trueValue);
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, String mimeType, boolean inline, InputStream is) throws IOException {
        log.debug("sendFile({}, {}, {}, {}, {}, {})", new Object[]{request, response, fileName, mimeType, inline, is});
        WebUtils.prepareSendFile(request, response, fileName, mimeType, inline);
        response.setContentLength(is.available());
        log.debug("File: {}, Length: {}", (Object)fileName, (Object)is.available());
        ServletOutputStream sos = response.getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)sos);
        sos.flush();
        sos.close();
    }

    public static void sendFile(HttpServletRequest request, HttpServletResponse response, String fileName, String mimeType, boolean inline, File input) throws IOException {
        log.debug("sendFile({}, {}, {}, {}, {}, {})", new Object[]{request, response, fileName, mimeType, inline, input});
        WebUtils.prepareSendFile(request, response, fileName, mimeType, inline);
        response.setContentLength((int)input.length());
        log.debug("File: {}, Length: {}", (Object)fileName, (Object)input.length());
        ServletOutputStream sos = response.getOutputStream();
        FileUtils.copy(input, (OutputStream)sos);
        sos.flush();
        sos.close();
    }

    private static void prepareSendFile(HttpServletRequest request, HttpServletResponse response, String fileName, String mimeType, boolean inline) throws UnsupportedEncodingException {
        String agent = request.getHeader("USER-AGENT");
        response.setHeader("Expires", "Sat, 6 May 1971 12:00:00 GMT");
        response.setHeader("Cache-Control", "must-revalidate");
        response.addHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType(mimeType);
        if (null != agent && -1 != agent.indexOf("MSIE")) {
            log.debug("Agent: Explorer ({})", (Object)request.getServerPort());
            fileName = URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", " ");
            if (request.getServerPort() == 443) {
                log.debug("HTTPS detected! Apply IE workaround...");
                response.setHeader("Cache-Control", "max-age=1");
                response.setHeader("Pragma", "public");
            }
        } else if (null != agent && -1 != agent.indexOf("Mozilla")) {
            log.debug("Agent: Mozilla");
            fileName = MimeUtility.encodeText((String)fileName, (String)"UTF-8", (String)"B");
        } else {
            log.debug("Agent: Unknown");
        }
        if (inline) {
            response.setHeader("Content-disposition", "inline; filename=\"" + fileName + "\"");
        } else {
            response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
        }
    }
}

