/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util;

import com.openkm.bean.workflow.ProcessInstance;
import com.openkm.bean.workflow.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hibernate.Hibernate;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WorkflowUtils {
    public static com.openkm.bean.workflow.ProcessDefinition copy(ProcessDefinition pd) {
        com.openkm.bean.workflow.ProcessDefinition vo = new com.openkm.bean.workflow.ProcessDefinition();
        vo.setName(pd.getName());
        vo.setDescription(pd.getDescription());
        vo.setId(pd.getId());
        vo.setVersion(pd.getVersion());
        ArrayList<String> al = new ArrayList<String>();
        for (org.jbpm.graph.def.Node n : pd.getNodes()) {
            al.add(n.getName());
        }
        vo.setNodes(al);
        return vo;
    }

    public static ProcessInstance copy(org.jbpm.graph.exe.ProcessInstance pi) {
        ProcessInstance vo = new ProcessInstance();
        if (pi.getStart() != null) {
            Calendar start = Calendar.getInstance();
            start.setTime(pi.getStart());
            vo.setStart(start);
        }
        if (pi.getEnd() != null) {
            Calendar end = Calendar.getInstance();
            end.setTime(pi.getEnd());
            vo.setEnd(end);
        }
        vo.setId(pi.getId());
        vo.setVersion(pi.getVersion());
        vo.setKey(pi.getKey());
        vo.setEnded(pi.hasEnded());
        vo.setSuspended(pi.isSuspended());
        if (pi.getContextInstance().getVariables() != null) {
            vo.setVariables(pi.getContextInstance().getVariables());
            for (String key : vo.getVariables().keySet()) {
                Hibernate.initialize((Object)vo.getVariables().get(key));
            }
        } else {
            vo.setVariables(new HashMap<String, Object>());
        }
        ArrayList<Token> al = new ArrayList<Token>();
        for (org.jbpm.graph.exe.Token tk : pi.findAllTokens()) {
            al.add(WorkflowUtils.copy(tk));
        }
        vo.setAllTokens(al);
        vo.setRootToken(WorkflowUtils.copy(pi.getRootToken()));
        vo.setProcessDefinition(WorkflowUtils.copy(pi.getProcessDefinition()));
        return vo;
    }

    public static com.openkm.bean.workflow.TaskInstance copy(TaskInstance ti) {
        com.openkm.bean.workflow.TaskInstance vo = new com.openkm.bean.workflow.TaskInstance();
        if (ti.getCreate() != null) {
            Calendar create = Calendar.getInstance();
            create.setTime(ti.getCreate());
            vo.setCreate(create);
        }
        if (ti.getStart() != null) {
            Calendar start = Calendar.getInstance();
            start.setTime(ti.getStart());
            vo.setStart(start);
        }
        if (ti.getEnd() != null) {
            Calendar end = Calendar.getInstance();
            end.setTime(ti.getEnd());
            vo.setEnd(end);
        }
        if (ti.getDueDate() != null) {
            Calendar dueDate = Calendar.getInstance();
            dueDate.setTime(ti.getDueDate());
            vo.setDueDate(dueDate);
        }
        vo.setId(ti.getId());
        vo.setName(ti.getName());
        vo.setDescription(ti.getDescription());
        vo.setVariables(ti.getVariables());
        ArrayList<com.openkm.bean.workflow.Comment> al = new ArrayList<com.openkm.bean.workflow.Comment>();
        for (Comment c : ti.getComments()) {
            com.openkm.bean.workflow.Comment tc = new com.openkm.bean.workflow.Comment();
            tc.setActorId(c.getActorId());
            tc.setMessage(c.getMessage());
            Calendar time = Calendar.getInstance();
            time.setTime(c.getTime());
            tc.setTime(time);
            al.add(tc);
        }
        vo.setComments(al);
        vo.setActorId(ti.getActorId());
        vo.setOpen(ti.isOpen());
        vo.setLast(ti.isLast());
        vo.setSuspended(ti.isSuspended());
        vo.setStartTaskInstance(ti.isStartTaskInstance());
        HashSet<String> hs = new HashSet<String>();
        Iterator it = ti.getPooledActors().iterator();
        while (it.hasNext()) {
            hs.add(it.next().toString());
        }
        vo.setPooledActors(hs);
        ArrayList<com.openkm.bean.workflow.Transition> alT = new ArrayList<com.openkm.bean.workflow.Transition>();
        if (ti.getEnd() == null) {
            for (Transition tr : ti.getAvailableTransitions()) {
                alT.add(WorkflowUtils.copy(tr));
            }
        }
        Collections.sort(alT);
        vo.setAvailableTransitions(alT);
        vo.setToken(WorkflowUtils.copy(ti.getToken()));
        vo.setProcessInstance(WorkflowUtils.copy(ti.getProcessInstance()));
        return vo;
    }

    public static Token copy(org.jbpm.graph.exe.Token t) {
        Token vo = null;
        if (t != null) {
            vo = new Token();
            vo.setName(t.getName());
            vo.setId(t.getId());
            vo.setSuspended(t.isSuspended());
            ArrayList<com.openkm.bean.workflow.Comment> alC = new ArrayList<com.openkm.bean.workflow.Comment>();
            if (t.getComments() != null) {
                for (Comment c : t.getComments()) {
                    alC.add(WorkflowUtils.copy(c));
                }
            }
            vo.setComments(alC);
            vo.setParent(WorkflowUtils.copy(t.getParent()));
            if (t.getNode() != null) {
                vo.setNode(t.getNode().getName());
            }
            if (t.getStart() != null) {
                Calendar start = Calendar.getInstance();
                start.setTime(t.getStart());
                vo.setStart(start);
            }
            if (t.getEnd() != null) {
                Calendar end = Calendar.getInstance();
                end.setTime(t.getEnd());
                vo.setEnd(end);
            }
            ArrayList<com.openkm.bean.workflow.Transition> alT = new ArrayList<com.openkm.bean.workflow.Transition>();
            for (Transition tr : t.getAvailableTransitions()) {
                alT.add(WorkflowUtils.copy(tr));
            }
            Collections.sort(alT);
            vo.setAvailableTransitions(alT);
        }
        return vo;
    }

    public static com.openkm.bean.workflow.Comment copy(Comment c) {
        com.openkm.bean.workflow.Comment vo = new com.openkm.bean.workflow.Comment();
        vo.setActorId(c.getActorId());
        vo.setMessage(c.getMessage());
        Calendar time = Calendar.getInstance();
        time.setTime(c.getTime());
        vo.setTime(time);
        return vo;
    }

    public static com.openkm.bean.workflow.Transition copy(Transition t) {
        com.openkm.bean.workflow.Transition vo = new com.openkm.bean.workflow.Transition();
        vo.setId(t.getId());
        vo.setName(t.getName());
        vo.setFrom(t.getFrom().getName());
        vo.setTo(t.getTo().getName());
        return vo;
    }

    public static DiagramInfo getDiagramInfo(InputStream is) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (is != null) {
                Document doc = db.parse(is);
                doc.getDocumentElement().normalize();
                Element processDiagramElement = doc.getDocumentElement();
                String widthString = processDiagramElement.getAttribute("width");
                String heightString = processDiagramElement.getAttribute("height");
                ArrayList<DiagramNodeInfo> diagramNodeInfoList = new ArrayList<DiagramNodeInfo>();
                NodeList nodeNodeList = processDiagramElement.getElementsByTagName("node");
                int nodeNodeListLength = nodeNodeList.getLength();
                for (int i = 0; i < nodeNodeListLength; ++i) {
                    Node nodeNode = nodeNodeList.item(i);
                    if (!(nodeNode instanceof Node) || nodeNode.getParentNode() != processDiagramElement) continue;
                    Element nodeElement = (Element)nodeNode;
                    String nodeName = nodeElement.getAttribute("name");
                    String nodeXString = nodeElement.getAttribute("x");
                    String nodeYString = nodeElement.getAttribute("y");
                    String nodeWidthString = nodeElement.getAttribute("width");
                    String nodeHeightString = nodeElement.getAttribute("height");
                    DiagramNodeInfo nodeInfo = new DiagramNodeInfo(nodeName, Integer.parseInt(nodeXString), Integer.parseInt(nodeYString), Integer.parseInt(nodeWidthString), Integer.parseInt(nodeHeightString));
                    diagramNodeInfoList.add(nodeInfo);
                }
                DiagramInfo diagramInfo = new DiagramInfo(Integer.parseInt(heightString), Integer.parseInt(widthString), diagramNodeInfoList);
                return diagramInfo;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static final class DiagramNodeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public DiagramNodeInfo(String name, int x, int y, int width, int height) {
            this.height = height;
            this.name = name;
            this.width = width;
            this.x = x;
            this.y = y;
        }

        public int getHeight() {
            return this.height;
        }

        public String getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("name=");
            sb.append(this.name);
            sb.append(", x=");
            sb.append(this.x);
            sb.append(", y=");
            sb.append(this.y);
            sb.append(", width=");
            sb.append(this.width);
            sb.append(", height=");
            sb.append(this.height);
            sb.append("}");
            return sb.toString();
        }
    }

    public static final class DiagramInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int width;
        private final int height;
        private final Map<String, DiagramNodeInfo> nodeMap;

        public DiagramInfo(int height, int width, List<DiagramNodeInfo> nodeList) {
            this.height = height;
            this.width = width;
            LinkedHashMap<String, DiagramNodeInfo> map = new LinkedHashMap<String, DiagramNodeInfo>();
            for (DiagramNodeInfo nodeInfo : nodeList) {
                map.put(nodeInfo.getName(), nodeInfo);
            }
            this.nodeMap = Collections.unmodifiableMap(map);
        }

        public int getHeight() {
            return this.height;
        }

        public Map<String, DiagramNodeInfo> getNodeMap() {
            return this.nodeMap;
        }

        public List<DiagramNodeInfo> getNodes() {
            return Collections.unmodifiableList(new ArrayList<DiagramNodeInfo>(this.nodeMap.values()));
        }

        public int getWidth() {
            return this.width;
        }
    }
}

