/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.cl;

import com.openkm.util.cl.MultipleClassLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryClassLoader
extends ClassLoader
implements MultipleClassLoader {
    private static Logger log = LoggerFactory.getLogger(BinaryClassLoader.class);
    private Hashtable<String, Class<?>> classes = new Hashtable();
    private Hashtable<String, byte[]> resources = new Hashtable();
    private String mainClassName = null;

    public BinaryClassLoader(byte[] buf) throws IOException {
        this.createCache(buf);
    }

    public BinaryClassLoader(byte[] buf, ClassLoader parent) throws IOException {
        super(parent);
        this.createCache(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCache(byte[] buf) throws IOException {
        block9: {
            ByteArrayInputStream bais = null;
            JarInputStream jis = null;
            byte[] buffer = new byte[4096];
            try {
                bais = new ByteArrayInputStream(buf);
                jis = new JarInputStream(bais);
                Attributes attr = jis.getManifest().getMainAttributes();
                this.mainClassName = attr != null ? attr.getValue(Attributes.Name.MAIN_CLASS) : null;
                JarEntry entry = null;
                while ((entry = jis.getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    int n = 0;
                    while (-1 != (n = jis.read(buffer))) {
                        byteStream.write(buffer, 0, n);
                    }
                    if (name.endsWith(".class")) {
                        String className = name.substring(0, name.indexOf(46)).replace('/', '.');
                        this.resources.put(className, byteStream.toByteArray());
                    } else {
                        this.resources.put(name, byteStream.toByteArray());
                    }
                    byteStream.close();
                }
                IOUtils.closeQuietly((InputStream)jis);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block9;
            }
            finally {
                IOUtils.closeQuietly(jis);
                IOUtils.closeQuietly((InputStream)bais);
            }
            IOUtils.closeQuietly((InputStream)bais);
        }
    }

    @Override
    public String getMainClassName() throws IOException {
        log.debug("getMainClassName()");
        return this.mainClassName;
    }

    @Override
    public Class<?> findClass(String className) {
        log.debug("findClass({})", (Object)className);
        Class<?> ret = this.classes.get(className);
        if (ret != null) {
            return ret;
        }
        try {
            return this.findSystemClass(className);
        }
        catch (ClassNotFoundException e) {
            byte[] classByte = this.resources.get(className);
            if (classByte != null) {
                ret = this.defineClass(className, classByte, 0, classByte.length, null);
                this.classes.put(className, ret);
                this.resources.remove(className);
                return ret;
            }
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        log.debug("getResourceAsStream({})", (Object)name);
        byte[] bytes = this.resources.get(name);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }
}

