/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.cl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderUtils {
    private static Logger log = LoggerFactory.getLogger(ClassLoaderUtils.class);
    private static final String MAIN = "main";

    public static Object invokeMainMethodFromClass(String className, String[] args, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = classLoader.loadClass(className);
        return ClassLoaderUtils.invokeMainMethodFromClass(c, args);
    }

    public static Object invokeMethodFromClass(String className, String methodName, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = classLoader.loadClass(className);
        return ClassLoaderUtils.invokeMethodFromClass(c, methodName);
    }

    public static Object invokeMethodFromClass(String className, String methodName, Object args, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = classLoader.loadClass(className);
        return ClassLoaderUtils.invokeMethodFromClass(c, methodName, args);
    }

    public static Object invokeMainMethodFromClass(Class<?> c, String[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        log.debug("invokeMainMethodFromClass({}, {})", c, (Object)args);
        Method m = c.getMethod(MAIN, args.getClass());
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException(MAIN);
        }
        try {
            return m.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Object invokeMethodFromClass(Class<?> c, String methodName) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        log.debug("invokeMethodFromClass({}, {})", new Object[]{c, methodName});
        Method m = c.getMethod(methodName, new Class[0]);
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (!Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException(methodName);
        }
        try {
            return m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Object invokeMethodFromClass(Class<?> c, String methodName, Object args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        log.debug("invokeMethodFromClass({}, {}, {})", new Object[]{c, methodName, args});
        Method m = c.getMethod(methodName, args.getClass());
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (!Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException(methodName);
        }
        try {
            return m.invoke(null, args);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

