/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.cl;

import com.openkm.util.cl.MultipleClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemClassLoader
extends ClassLoader
implements MultipleClassLoader {
    private static Logger log = LoggerFactory.getLogger(FilesystemClassLoader.class);
    private File file = null;

    public FilesystemClassLoader(File file) throws IOException {
        this.file = file;
    }

    public FilesystemClassLoader(File file, ClassLoader parent) throws IOException {
        super(parent);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMainClassName() throws IOException {
        FileInputStream fis;
        block2: {
            String string;
            log.debug("getMainClassName()");
            File mf = new File(this.file, "META-INF/MANIFEST.MF");
            fis = null;
            try {
                if (!mf.exists() || !mf.canRead()) break block2;
                fis = new FileInputStream(mf);
                Manifest manif = new Manifest(fis);
                Attributes attr = manif.getMainAttributes();
                string = attr != null ? attr.getValue(Attributes.Name.MAIN_CLASS) : null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return string;
        }
        IOUtils.closeQuietly(fis);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String className) {
        log.info("findClass({})", (Object)className);
        String classFile = className.replace('.', '/').concat(".class");
        File fc = new File(this.file, classFile);
        FileInputStream fis = null;
        try {
            return this.findSystemClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                byte[] classByte;
                if (fc.exists() && fc.canRead() && (classByte = IOUtils.toByteArray((InputStream)(fis = new FileInputStream(fc)))) != null) {
                    Class<?> clazz = this.defineClass(className, classByte, 0, classByte.length, null);
                    IOUtils.closeQuietly((InputStream)fis);
                    return clazz;
                }
                IOUtils.closeQuietly(fis);
            }
            catch (IOException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
            finally {
                IOUtils.closeQuietly(fis);
            }
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        log.debug("getResourceAsStream({})", (Object)name);
        File fr = new File(this.file, name);
        try {
            if (fr.exists() && fr.canRead()) {
                return new FileInputStream(fr);
            }
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

