/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.eliza;

import com.openkm.util.eliza.ElizaComments;
import com.openkm.util.eliza.Replace;
import java.io.IOException;
import java.io.InputStream;

public class Eliza {
    protected String previousInput = "";
    protected ElizaComments elizaComments;

    public Eliza() throws IOException {
        InputStream is = Eliza.class.getResourceAsStream("eliza.dat");
        this.elizaComments = new ElizaComments(is);
        is.close();
    }

    public Eliza(InputStream stream) throws IOException {
        this.elizaComments = new ElizaComments(stream);
    }

    public String getGreetString() {
        return "Hi. I'm Eliza. Tell me your problems!";
    }

    public String getSayGoodByeString() {
        return "Bye Bye. It was interesting to talk with a lower intelligence.";
    }

    protected String getRepeatString() {
        return "Please don't say it again!";
    }

    public String getResponse(String userInput) {
        String retVal;
        String cleanedInput = Eliza.cleanInput(userInput);
        String upperInput = userInput.toUpperCase();
        if (upperInput.equals(this.previousInput)) {
            retVal = this.getRepeatString();
        } else {
            this.previousInput = upperInput;
            retVal = Eliza.cleanOutput(this.elizaComments.getAnswer(cleanedInput));
        }
        return retVal;
    }

    protected static String cleanInput(String input) {
        return Replace.all(Replace.all(Replace.all(Replace.all(Replace.all(Replace.all(Replace.all(Replace.all(" " + input + " ", "*", ""), "#", ""), ".", ""), "!", ""), "?", ""), ",", " # "), "#", " , "), "  ", " ");
    }

    protected static String cleanOutput(String output) {
        return Replace.all(Replace.all(Replace.all(Replace.all(Replace.all(output, " .", "."), " !", "!"), " ?", "?"), " ,", ","), "  ", " ");
    }
}

