/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.eliza;

import com.openkm.util.eliza.AuxVerb;
import com.openkm.util.eliza.Comment;
import com.openkm.util.eliza.Replace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class ElizaComments {
    protected Vector<Comment> comments;
    protected Vector<AuxVerb> auxVerbs;
    protected Comment lameExcuse;

    public ElizaComments(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        this.comments = new Vector();
        this.auxVerbs = new Vector();
        this.lameExcuse = null;
        while ((line = reader.readLine()) != null) {
            if (line.equals("PHRASE")) {
                Comment comment = new Comment(reader);
                this.comments.addElement(comment);
                if (comment.getNumberOfPhrases() != 0) continue;
                this.lameExcuse = comment;
                continue;
            }
            if (!line.equals("AUXVERB")) continue;
            AuxVerb auxVerb = new AuxVerb(reader);
            this.auxVerbs.addElement(auxVerb);
        }
        reader.close();
    }

    public String getAnswer(String input) {
        String upperInput = input.toUpperCase();
        for (int i = 0; i < this.comments.size(); ++i) {
            Comment comment = this.comments.elementAt(i);
            for (int j = 0; j < comment.getNumberOfPhrases(); ++j) {
                String phrase = comment.getPhrase(j);
                int index = upperInput.indexOf(" " + phrase + " ");
                if (index == -1) continue;
                String inputPhrase = this.adaptAuxVerbs(input.substring(index + 2 + phrase.length()));
                return Replace.all(comment.getAnswer(), "*", inputPhrase);
            }
        }
        return Replace.all(this.lameExcuse.getAnswer(), "*", this.adaptAuxVerbs(input));
    }

    public String adaptAuxVerbs(String input) {
        String retVal = input;
        for (int i = 0; i < this.auxVerbs.size(); ++i) {
            AuxVerb auxVerb = this.auxVerbs.elementAt(i);
            retVal = Replace.all(retVal, " " + auxVerb.getOriginal() + " ", " " + auxVerb.getSwitched() + "# ");
            retVal = Replace.all(retVal, " " + auxVerb.getSwitched() + " ", " " + auxVerb.getOriginal() + "# ");
        }
        return Replace.all(retVal, "#", "");
    }
}

