/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.impexp;

import com.openkm.util.impexp.InfoDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLInfoDecorator
implements InfoDecorator {
    private static Logger log = LoggerFactory.getLogger(HTMLInfoDecorator.class);
    private int idx;
    private int total;
    private int oldPerCent = -1;

    public HTMLInfoDecorator(int total) {
        this.total = total;
    }

    @Override
    public String print(String path, long size, String error) {
        log.debug("print({}, {}, {})", new Object[]{path, size, error});
        StringBuffer sb = new StringBuffer();
        int perCent = ++this.idx * 100 / this.total;
        if (perCent > this.oldPerCent) {
            sb.append(" (");
            sb.append(perCent);
            sb.append("%)");
            this.oldPerCent = perCent;
        }
        if (error != null) {
            sb.append("<div class=\"warn\">");
            sb.append(path);
            sb.append(" -> ");
            sb.append(error);
            sb.append("</div>");
        }
        log.debug("print: {}", (Object)sb.toString());
        return sb.toString();
    }
}

