/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.impexp;

import com.openkm.bean.Document;
import com.openkm.bean.Version;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.DocumentModule;
import com.openkm.module.ModuleManager;
import com.openkm.util.impexp.ImpExpStats;
import com.openkm.util.impexp.InfoDecorator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryChecker {
    private static Logger log = LoggerFactory.getLogger(RepositoryChecker.class);

    private RepositoryChecker() {
    }

    public static ImpExpStats checkDocuments(String token, String fldPath, boolean versions, Writer out, InfoDecorator deco) throws PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException {
        log.debug("checkDocuments({}, {}, {}, {}, {})", new Object[]{token, fldPath, versions, out, deco});
        Session session = null;
        ImpExpStats stats = new ImpExpStats();
        try {
            session = token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(token);
            Node baseNode = session.getRootNode().getNode(fldPath.substring(1));
            stats = RepositoryChecker.checkDocumentsHelper(token, baseNode, versions, out, deco);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            stats.setOk(false);
            throw e;
        }
        catch (AccessDeniedException e) {
            log.error(e.getMessage(), (Throwable)e);
            stats.setOk(false);
            throw e;
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            stats.setOk(false);
            throw e;
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            stats.setOk(false);
            throw e;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            stats.setOk(false);
            throw e;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            stats.setOk(false);
            throw e;
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            stats.setOk(false);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("checkDocuments: {}", (Object)stats);
        return stats;
    }

    private static ImpExpStats checkDocumentsHelper(String token, Node baseNode, boolean versions, Writer out, InfoDecorator deco) throws FileNotFoundException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, javax.jcr.PathNotFoundException, javax.jcr.RepositoryException {
        log.debug("checkDocumentsHelper({}, {}, {}, {}, {})", new Object[]{token, baseNode, versions, out, deco});
        ImpExpStats stats = new ImpExpStats();
        NodeIterator ni = baseNode.getNodes();
        while (ni.hasNext()) {
            ImpExpStats tmp;
            Node child = ni.nextNode();
            if (child.isNodeType("okm:document")) {
                tmp = RepositoryChecker.readDocument(token, child.getPath(), versions, out, deco);
                stats.setDocuments(stats.getDocuments() + tmp.getDocuments());
                stats.setFolders(stats.getFolders() + tmp.getFolders());
                stats.setSize(stats.getSize() + tmp.getSize());
                stats.setOk(stats.isOk() && tmp.isOk());
                continue;
            }
            if (child.isNodeType("okm:folder")) {
                tmp = RepositoryChecker.readFolder(token, child, versions, out, deco);
                stats.setDocuments(stats.getDocuments() + tmp.getDocuments());
                stats.setFolders(stats.getFolders() + tmp.getFolders());
                stats.setSize(stats.getSize() + tmp.getSize());
                stats.setOk(stats.isOk() && tmp.isOk());
                continue;
            }
            if (child.isNodeType("okm:mail")) {
                tmp = RepositoryChecker.readFolder(token, child, versions, out, deco);
                stats.setDocuments(stats.getDocuments() + tmp.getDocuments());
                stats.setFolders(stats.getFolders() + tmp.getFolders());
                stats.setSize(stats.getSize() + tmp.getSize());
                stats.setOk(stats.isOk() && tmp.isOk());
                continue;
            }
            if (child.isNodeType("okm:notes")) continue;
            log.error("Unknown node type: {} ({})", (Object)child.getPrimaryNodeType().getName(), (Object)child.getPath());
            stats.setOk(false);
            out.write(deco.print(child.getPath(), 0L, "Unknown node type: " + child.getPrimaryNodeType().getName()));
            out.flush();
        }
        log.debug("checkDocumentsHelper: {}", (Object)stats);
        return stats;
    }

    private static ImpExpStats readDocument(String token, String docPath, boolean versions, Writer out, InfoDecorator deco) throws PathNotFoundException, RepositoryException, DatabaseException, IOException {
        log.debug("readDocument({})", (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        File fsPath = new File(Config.NULL_DEVICE);
        ImpExpStats stats = new ImpExpStats();
        Document doc = dm.getProperties(token, docPath);
        try {
            FileOutputStream fos = new FileOutputStream(fsPath);
            InputStream is = dm.getContent(token, docPath, false);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            is.close();
            if (versions) {
                for (Version ver : dm.getVersionHistory(token, docPath)) {
                    is = dm.getContentByVersion(token, docPath, ver.getName());
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                    is.close();
                }
            }
            fos.close();
            out.write(deco.print(docPath, doc.getActualVersion().getSize(), null));
            out.flush();
            stats.setSize(stats.getSize() + doc.getActualVersion().getSize());
            stats.setDocuments(stats.getDocuments() + 1L);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            stats.setOk(false);
            out.write(deco.print(docPath, doc.getActualVersion().getSize(), e.getMessage()));
            out.flush();
        }
        return stats;
    }

    private static ImpExpStats readFolder(String token, Node baseNode, boolean versions, Writer out, InfoDecorator deco) throws FileNotFoundException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, javax.jcr.PathNotFoundException, javax.jcr.RepositoryException {
        log.debug("readFolder({})", (Object)baseNode.getPath());
        ImpExpStats stats = RepositoryChecker.checkDocumentsHelper(token, baseNode, versions, out, deco);
        stats.setFolders(stats.getFolders() + 1L);
        return stats;
    }
}

