/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.impexp;

import com.google.gson.Gson;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.DocumentModule;
import com.openkm.module.FolderModule;
import com.openkm.module.ModuleManager;
import com.openkm.util.impexp.ImpExpStats;
import com.openkm.util.impexp.InfoDecorator;
import com.openkm.util.impexp.metadata.DocumentMetadata;
import com.openkm.util.impexp.metadata.FolderMetadata;
import com.openkm.util.impexp.metadata.MetadataAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryExporter {
    private static Logger log = LoggerFactory.getLogger(RepositoryExporter.class);
    private static boolean firstTime = true;

    private RepositoryExporter() {
    }

    public static ImpExpStats exportDocuments(String token, String fldPath, File fs, boolean metadata, Writer out, InfoDecorator deco) throws PathNotFoundException, AccessDeniedException, RepositoryException, FileNotFoundException, IOException, DatabaseException {
        ImpExpStats stats;
        log.debug("exportDocuments({}, {}, {}, {}, {}, {})", new Object[]{token, fldPath, fs, metadata, out, deco});
        try {
            if (!fs.exists()) {
                throw new FileNotFoundException(fs.getPath());
            }
            firstTime = true;
            stats = RepositoryExporter.exportDocumentsHelper(token, fldPath, fs, metadata, out, deco);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (AccessDeniedException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        log.debug("exportDocuments: {}", (Object)stats);
        return stats;
    }

    private static ImpExpStats exportDocumentsHelper(String token, String fldPath, File fs, boolean metadata, Writer out, InfoDecorator deco) throws FileNotFoundException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException {
        log.debug("exportDocumentsHelper({}, {}, {}, {}, {}, {})", new Object[]{token, fldPath, fs, metadata, out, deco});
        ImpExpStats stats = new ImpExpStats();
        DocumentModule dm = ModuleManager.getDocumentModule();
        FolderModule fm = ModuleManager.getFolderModule();
        MetadataAdapter ma = MetadataAdapter.getInstance(token);
        Gson gson = new Gson();
        String path = null;
        File fsPath = null;
        if (firstTime) {
            path = fs.getPath();
            fsPath = new File(path);
            firstTime = false;
        } else {
            path = fs.getPath() + File.separator + JCRUtils.getName(fldPath).replace(':', '_');
            fsPath = new File(path);
            fsPath.mkdirs();
            out.write(deco.print(fldPath, 0L, null));
            out.flush();
        }
        for (Document docChild : dm.getChilds(token, fldPath)) {
            path = fsPath.getPath() + File.separator + JCRUtils.getName(docChild.getPath()).replace(':', '_');
            FileOutputStream fos = new FileOutputStream(path);
            InputStream is = dm.getContent(token, docChild.getPath(), false);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            is.close();
            fos.close();
            out.write(deco.print(docChild.getPath(), docChild.getActualVersion().getSize(), null));
            out.flush();
            if (metadata) {
                DocumentMetadata dmd = ma.getMetadata(docChild);
                String json = gson.toJson((Object)dmd);
                fos = new FileOutputStream(path + Config.EXPORT_METADATA_EXT);
                IOUtils.write((String)json, (OutputStream)fos);
                fos.close();
            }
            stats.setSize(stats.getSize() + docChild.getActualVersion().getSize());
            stats.setDocuments(stats.getDocuments() + 1L);
        }
        for (Folder fldChild : fm.getChilds(token, fldPath)) {
            ImpExpStats tmp = RepositoryExporter.exportDocumentsHelper(token, fldChild.getPath(), fsPath, metadata, out, deco);
            path = fsPath.getPath() + File.separator + JCRUtils.getName(fldChild.getPath()).replace(':', '_');
            if (metadata) {
                FolderMetadata fmd = ma.getMetadata(fldChild);
                String json = gson.toJson((Object)fmd);
                FileOutputStream fos = new FileOutputStream(path + Config.EXPORT_METADATA_EXT);
                IOUtils.write((String)json, (OutputStream)fos);
                fos.close();
            }
            stats.setSize(stats.getSize() + tmp.getSize());
            stats.setDocuments(stats.getDocuments() + tmp.getDocuments());
            stats.setFolders(stats.getFolders() + tmp.getFolders() + 1L);
            stats.setOk(stats.isOk() && tmp.isOk());
        }
        log.debug("exportDocumentsHelper: {}", (Object)stats);
        return stats;
    }
}

