/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.impexp;

import com.google.gson.Gson;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.FileSizeExceededException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UnsupportedMimeTypeException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VirusDetectedException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.module.DocumentModule;
import com.openkm.module.FolderModule;
import com.openkm.module.ModuleManager;
import com.openkm.util.FileLogger;
import com.openkm.util.impexp.ImpExpStats;
import com.openkm.util.impexp.InfoDecorator;
import com.openkm.util.impexp.metadata.DocumentMetadata;
import com.openkm.util.impexp.metadata.FolderMetadata;
import com.openkm.util.impexp.metadata.MetadataAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryImporter {
    private static Logger log = LoggerFactory.getLogger(RepositoryImporter.class);
    private static final String baseName = RepositoryImporter.class.getSimpleName();

    private RepositoryImporter() {
    }

    public static ImpExpStats importDocuments(String token, File fs, String fldPath, boolean metadata, boolean uuid, Writer out, InfoDecorator deco) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, FileNotFoundException, IOException, DatabaseException, ExtensionException {
        ImpExpStats stats;
        log.debug("importDocuments({}, {}, {}, {}, {}, {}, {})", new Object[]{token, fs, fldPath, metadata, uuid, out, deco});
        try {
            FileLogger.info(baseName, "Start repository import from ''{0}'' to ''{1}''", fs.getPath(), fldPath);
            if (!fs.exists()) {
                throw new FileNotFoundException(fs.getPath());
            }
            stats = RepositoryImporter.importDocumentsHelper(token, fs, fldPath, metadata, uuid, out, deco);
            FileLogger.info(baseName, "Repository import finalized", new Object[0]);
        }
        catch (PathNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            FileLogger.error(baseName, "PathNotFoundException ''{0}''", e.getMessage());
            throw e;
        }
        catch (AccessDeniedException e) {
            log.error(e.getMessage(), (Throwable)e);
            FileLogger.error(baseName, "AccessDeniedException ''{0}''", e.getMessage());
            throw e;
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            FileLogger.error(baseName, "FileNotFoundException ''{0}''", e.getMessage());
            throw e;
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            FileLogger.error(baseName, "RepositoryException ''{0}''", e.getMessage());
            throw e;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            FileLogger.error(baseName, "IOException ''{0}''", e.getMessage());
            throw e;
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
            FileLogger.error(baseName, "DatabaseException ''{0}''", e.getMessage());
            throw e;
        }
        log.debug("importDocuments: {}", (Object)stats);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImpExpStats importDocumentsHelper(String token, File fs, String fldPath, boolean metadata, boolean uuid, Writer out, InfoDecorator deco) throws FileNotFoundException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.debug("importDocumentsHelper({}, {}, {}, {}, {}, {}, {})", new Object[]{token, fs, fldPath, metadata, uuid, out, deco});
        File[] files = fs.listFiles();
        ImpExpStats stats = new ImpExpStats();
        DocumentModule dm = ModuleManager.getDocumentModule();
        FolderModule fm = ModuleManager.getFolderModule();
        MetadataAdapter ma = MetadataAdapter.getInstance(token);
        ma.setRestoreUuid(uuid);
        Gson gson = new Gson();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getName();
            if (fileName.endsWith(Config.EXPORT_METADATA_EXT)) continue;
            if (files[i].isDirectory()) {
                Folder fld = new Folder();
                boolean api = false;
                int importedFolder = 0;
                try {
                    if (metadata) {
                        File jsFile = new File(files[i].getPath() + Config.EXPORT_METADATA_EXT);
                        if (jsFile.exists() && jsFile.canRead()) {
                            FileReader fr = new FileReader(jsFile);
                            FolderMetadata fmd = (FolderMetadata)gson.fromJson((Reader)fr, FolderMetadata.class);
                            fr.close();
                            fld.setPath(fldPath + "/" + fileName);
                            fmd.setPath(fld.getPath());
                            ma.importWithMetadata(fmd);
                            out.write(deco.print(files[i].getPath(), files[i].length(), null));
                            out.flush();
                        } else {
                            api = true;
                        }
                    } else {
                        api = true;
                    }
                    if (api) {
                        fld.setPath(fldPath + "/" + fileName);
                        fm.create(token, fld);
                        FileLogger.info(baseName, "Created folder ''{0}''", fld.getPath());
                        out.write(deco.print(files[i].getPath(), files[i].length(), null));
                        out.flush();
                    }
                    importedFolder = 1;
                }
                catch (ItemExistsException e) {
                    log.warn("ItemExistsException: {}", (Object)e.getMessage());
                    out.write(deco.print(files[i].getPath(), files[i].length(), "ItemExists"));
                    out.flush();
                    stats.setOk(false);
                    FileLogger.error(baseName, "ItemExistsException ''{0}''", fld.getPath());
                }
                ImpExpStats tmp = RepositoryImporter.importDocumentsHelper(token, files[i], fld.getPath(), metadata, uuid, out, deco);
                stats.setOk(stats.isOk() && tmp.isOk());
                stats.setSize(stats.getSize() + tmp.getSize());
                stats.setDocuments(stats.getDocuments() + tmp.getDocuments());
                stats.setFolders(stats.getFolders() + tmp.getFolders() + (long)importedFolder);
                continue;
            }
            FileInputStream fisContent = new FileInputStream(files[i]);
            int size = fisContent.available();
            Document doc = new Document();
            boolean api = false;
            try {
                if (metadata) {
                    File jsFile = new File(files[i].getPath() + Config.EXPORT_METADATA_EXT);
                    if (jsFile.exists() && jsFile.canRead()) {
                        FileReader fr = new FileReader(jsFile);
                        DocumentMetadata dmd = (DocumentMetadata)gson.fromJson((Reader)fr, DocumentMetadata.class);
                        fr.close();
                        doc.setPath(fldPath + "/" + fileName);
                        dmd.setPath(doc.getPath());
                        ma.importWithMetadata(dmd, fisContent);
                        out.write(deco.print(files[i].getPath(), files[i].length(), null));
                        out.flush();
                    } else {
                        api = true;
                    }
                } else {
                    api = true;
                }
                if (api) {
                    doc.setPath(fldPath + "/" + fileName);
                    dm.create(token, doc, fisContent);
                    FileLogger.info(baseName, "Created document ''{0}''", doc.getPath());
                    out.write(deco.print(files[i].getPath(), files[i].length(), null));
                    out.flush();
                }
                stats.setSize(stats.getSize() + (long)size);
                stats.setDocuments(stats.getDocuments() + 1L);
                continue;
            }
            catch (UnsupportedMimeTypeException e) {
                log.warn("UnsupportedMimeTypeException: {}", (Object)e.getMessage());
                out.write(deco.print(files[i].getPath(), files[i].length(), "UnsupportedMimeType"));
                out.flush();
                stats.setOk(false);
                FileLogger.error(baseName, "UnsupportedMimeTypeException ''{0}''", doc.getPath());
                continue;
            }
            catch (FileSizeExceededException e) {
                log.warn("FileSizeExceededException: {}", (Object)e.getMessage());
                out.write(deco.print(files[i].getPath(), files[i].length(), "FileSizeExceeded"));
                out.flush();
                stats.setOk(false);
                FileLogger.error(baseName, "FileSizeExceededException ''{0}''", doc.getPath());
                continue;
            }
            catch (UserQuotaExceededException e) {
                log.warn("UserQuotaExceededException: {}", (Object)e.getMessage());
                out.write(deco.print(files[i].getPath(), files[i].length(), "UserQuotaExceeded"));
                out.flush();
                stats.setOk(false);
                FileLogger.error(baseName, "UserQuotaExceededException ''{0}''", doc.getPath());
                continue;
            }
            catch (VirusDetectedException e) {
                log.warn("VirusWarningException: {}", (Object)e.getMessage());
                out.write(deco.print(files[i].getPath(), files[i].length(), "VirusWarningException"));
                out.flush();
                stats.setOk(false);
                FileLogger.error(baseName, "VirusWarningException ''{0}''", doc.getPath());
                continue;
            }
            catch (ItemExistsException e) {
                log.warn("ItemExistsException: {}", (Object)e.getMessage());
                out.write(deco.print(files[i].getPath(), files[i].length(), "ItemExists"));
                out.flush();
                stats.setOk(false);
                FileLogger.error(baseName, "ItemExistsException ''{0}''", doc.getPath());
                continue;
            }
            finally {
                fisContent.close();
            }
        }
        log.debug("importDocumentsHelper: {}", (Object)stats);
        return stats;
    }
}

