/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.impexp.metadata;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.util.impexp.metadata.CategoryMetadata;
import com.openkm.util.impexp.metadata.DocumentMetadata;
import com.openkm.util.impexp.metadata.FolderMetadata;
import com.openkm.util.impexp.metadata.MetadataAdapter;
import com.openkm.util.impexp.metadata.NoteMetadata;
import com.openkm.util.impexp.metadata.PropertyGroupMetadata;
import com.openkm.util.impexp.metadata.PropertyMetadata;
import com.openkm.util.impexp.metadata.VersionMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.core.NodeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrMetadataAdapter
extends MetadataAdapter {
    private static Logger log = LoggerFactory.getLogger(JcrMetadataAdapter.class);

    public JcrMetadataAdapter(String token) {
        this.token = token;
    }

    @Override
    protected List<PropertyGroupMetadata> getPropertyGroupsMetada(String path) throws RepositoryException, DatabaseException {
        log.debug("getPropertyGroupsMetada({})", (Object)path);
        ArrayList<PropertyGroupMetadata> ret = new ArrayList<PropertyGroupMetadata>();
        Session session = null;
        try {
            session = this.token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(this.token);
            Node node = session.getRootNode().getNode(path.substring(1));
            for (NodeType nt : node.getMixinNodeTypes()) {
                if (!nt.getName().startsWith("okg:")) continue;
                PropertyGroupMetadata pgmd = new PropertyGroupMetadata();
                ArrayList<PropertyMetadata> pmds = new ArrayList<PropertyMetadata>();
                pgmd.setName(nt.getName());
                for (PropertyDefinition pd : nt.getDeclaredPropertyDefinitions()) {
                    Property prop = node.getProperty(pd.getName());
                    PropertyMetadata pmd = new PropertyMetadata();
                    pmd.setName(prop.getName());
                    pmd.setType(prop.getType());
                    if (pd.isMultiple()) {
                        Value[] popValues = prop.getValues();
                        ArrayList<String> values = new ArrayList<String>();
                        for (Value val : popValues) {
                            values.add(val.getString());
                        }
                        pmd.setValues(values);
                        pmd.setMultiValue(true);
                    } else {
                        Value popValue = prop.getValue();
                        pmd.setValue(popValue.getString());
                        pmd.setMultiValue(false);
                    }
                    pmds.add(pmd);
                }
                pgmd.setProperties(pmds);
                ret.add(pgmd);
            }
        }
        catch (LoginException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (this.token == null) {
                JCRUtils.logout(session);
            }
        }
        log.debug("getPropertyGroupsMetada: {}", ret);
        return ret;
    }

    @Override
    public void importWithMetadata(DocumentMetadata dmd, InputStream is) throws com.openkm.core.ItemExistsException, RepositoryException, DatabaseException, IOException {
        Session session = null;
        Node parentNode = null;
        try {
            VersionMetadata vmd;
            session = this.token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(this.token);
            String parent = JCRUtils.getParent(dmd.getPath());
            String name = JCRUtils.getName(dmd.getPath());
            parentNode = session.getRootNode().getNode(parent.substring(1));
            Node documentNode = null;
            documentNode = this.uuid && dmd.getUuid() != null && !dmd.getUuid().equals("") ? ((NodeImpl)parentNode).addNodeWithUuid(name, "okm:document", dmd.getUuid()) : parentNode.addNode(name, "okm:document");
            if (dmd.getAuthor() != null && !dmd.getAuthor().equals("")) {
                documentNode.setProperty("okm:author", dmd.getAuthor());
            } else {
                documentNode.setProperty("okm:author", session.getUserID());
            }
            if (dmd.getName() != null && !dmd.getName().equals("")) {
                documentNode.setProperty("okm:name", dmd.getName());
            } else {
                documentNode.setProperty("okm:name", name);
            }
            if (dmd.getCreated() != null) {
                documentNode.setProperty("jcr:created", dmd.getCreated());
            } else {
                documentNode.setProperty("jcr:created", Calendar.getInstance());
            }
            documentNode.setProperty("okm:keywords", this.getValues((Collection<String>)dmd.getKeywords()));
            documentNode.setProperty("okm:categories", this.getValues(dmd.getCategories()));
            if (!dmd.getSubscriptors().isEmpty()) {
                documentNode.addMixin("mix:notification");
                documentNode.setProperty("okm:subscriptors", this.getValues((Collection<String>)dmd.getSubscriptors()));
            }
            if (dmd.getCipherName() != null && !dmd.getCipherName().equals("")) {
                documentNode.addMixin("mix:encryption");
                documentNode.setProperty("okm:cipherName", dmd.getCipherName());
            }
            if (!dmd.getNotes().isEmpty()) {
                documentNode.addMixin("mix:notes");
                Node notesNode = documentNode.getNode("okm:notes");
                for (NoteMetadata nmd : dmd.getNotes()) {
                    String noteName = JCRUtils.getName(nmd.getPath());
                    Node noteNode = notesNode.addNode(noteName, "okm:note");
                    noteNode.setProperty("okm:date", nmd.getDate());
                    noteNode.setProperty("okm:user", nmd.getUser());
                    noteNode.setProperty("okm:text", nmd.getText());
                }
            }
            if ((vmd = dmd.getVersion()) == null) {
                vmd = new VersionMetadata();
            }
            Node contentNode = documentNode.addNode("okm:content", "okm:resource");
            if (vmd.getSize() > 0L) {
                contentNode.setProperty("okm:size", vmd.getSize());
            } else {
                contentNode.setProperty("okm:size", (long)is.available());
            }
            if (vmd.getAuthor() != null && !vmd.getAuthor().equals("")) {
                contentNode.setProperty("okm:author", vmd.getAuthor());
            } else {
                contentNode.setProperty("okm:author", session.getUserID());
            }
            if (vmd.getComment() != null && !vmd.getComment().equals("")) {
                contentNode.setProperty("okm:versionComment", vmd.getComment());
            } else {
                contentNode.setProperty("okm:versionComment", "Imported by " + session.getUserID());
            }
            if (vmd.getCreated() != null) {
                contentNode.setProperty("jcr:lastModified", vmd.getCreated());
            } else {
                contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            }
            contentNode.setProperty("jcr:data", is);
            if (vmd.getMimeType() != null && !vmd.getMimeType().equals("")) {
                contentNode.setProperty("jcr:mimeType", vmd.getMimeType());
            } else {
                contentNode.setProperty("jcr:mimeType", Config.mimeTypes.getContentType(name.toLowerCase()));
            }
            if (dmd.getGrantedUsers() == null || dmd.getGrantedUsers().isEmpty()) {
                dmd.setGrantedUsers(this.getGrantedUsers(parentNode));
            }
            documentNode.setProperty("okm:authUsersRead", this.getPermissions(dmd.getGrantedUsers(), 1));
            documentNode.setProperty("okm:authUsersWrite", this.getPermissions(dmd.getGrantedUsers(), 2));
            documentNode.setProperty("okm:authUsersDelete", this.getPermissions(dmd.getGrantedUsers(), 4));
            documentNode.setProperty("okm:authUsersSecurity", this.getPermissions(dmd.getGrantedUsers(), 8));
            if (dmd.getGrantedRoles() == null || dmd.getGrantedRoles().isEmpty()) {
                dmd.setGrantedRoles(this.getGrantedRoles(parentNode));
            }
            documentNode.setProperty("okm:authRolesRead", this.getPermissions(dmd.getGrantedRoles(), 1));
            documentNode.setProperty("okm:authRolesWrite", this.getPermissions(dmd.getGrantedRoles(), 2));
            documentNode.setProperty("okm:authRolesDelete", this.getPermissions(dmd.getGrantedRoles(), 4));
            documentNode.setProperty("okm:authRolesSecurity", this.getPermissions(dmd.getGrantedRoles(), 8));
            for (PropertyGroupMetadata pgmd : dmd.getPropertyGroups()) {
                documentNode.addMixin(pgmd.getName());
                for (PropertyMetadata pmd : pgmd.getProperties()) {
                    if (pmd.isMultiValue()) {
                        documentNode.setProperty(pmd.getName(), this.getValues(pmd.getValues()));
                        continue;
                    }
                    documentNode.setProperty(pmd.getName(), pmd.getValue());
                }
            }
            parentNode.save();
            ((NodeImpl)contentNode).checkin(vmd.getCreated());
        }
        catch (LoginException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (this.token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    @Override
    public void importWithMetadata(FolderMetadata fmd) throws com.openkm.core.ItemExistsException, RepositoryException, DatabaseException {
        Session session = null;
        Node parentNode = null;
        try {
            session = this.token == null ? JCRUtils.getSession() : JcrSessionManager.getInstance().get(this.token);
            String parent = JCRUtils.getParent(fmd.getPath());
            String name = JCRUtils.getName(fmd.getPath());
            parentNode = session.getRootNode().getNode(parent.substring(1));
            Node folderNode = null;
            folderNode = this.uuid && fmd.getUuid() != null && !fmd.getUuid().equals("") ? ((NodeImpl)parentNode).addNodeWithUuid(name, "okm:folder", fmd.getUuid()) : parentNode.addNode(name, "okm:folder");
            if (fmd.getAuthor() != null && !fmd.getAuthor().equals("")) {
                folderNode.setProperty("okm:author", fmd.getAuthor());
            } else {
                folderNode.setProperty("okm:author", session.getUserID());
            }
            if (fmd.getName() != null && !fmd.getName().equals("")) {
                folderNode.setProperty("okm:name", fmd.getName());
            } else {
                folderNode.setProperty("okm:name", name);
            }
            if (fmd.getCreated() != null) {
                folderNode.setProperty("jcr:created", fmd.getCreated());
            } else {
                folderNode.setProperty("jcr:created", Calendar.getInstance());
            }
            if (!fmd.getSubscriptors().isEmpty()) {
                folderNode.addMixin("mix:notification");
                folderNode.setProperty("okm:subscriptors", this.getValues((Collection<String>)fmd.getSubscriptors()));
            }
            if (!fmd.getNotes().isEmpty()) {
                folderNode.addMixin("mix:notes");
                Node notesNode = folderNode.getNode("okm:notes");
                for (NoteMetadata nmd : fmd.getNotes()) {
                    String noteName = JCRUtils.getName(nmd.getPath());
                    Node noteNode = notesNode.addNode(noteName, "okm:note");
                    noteNode.setProperty("okm:date", nmd.getDate());
                    noteNode.setProperty("okm:user", nmd.getUser());
                    noteNode.setProperty("okm:text", nmd.getText());
                }
            }
            if (fmd.getGrantedUsers() == null || fmd.getGrantedUsers().isEmpty()) {
                fmd.setGrantedUsers(this.getGrantedUsers(parentNode));
            }
            folderNode.setProperty("okm:authUsersRead", this.getPermissions(fmd.getGrantedUsers(), 1));
            folderNode.setProperty("okm:authUsersWrite", this.getPermissions(fmd.getGrantedUsers(), 2));
            folderNode.setProperty("okm:authUsersDelete", this.getPermissions(fmd.getGrantedUsers(), 4));
            folderNode.setProperty("okm:authUsersSecurity", this.getPermissions(fmd.getGrantedUsers(), 8));
            if (fmd.getGrantedRoles() == null || fmd.getGrantedRoles().isEmpty()) {
                fmd.setGrantedRoles(this.getGrantedRoles(parentNode));
            }
            folderNode.setProperty("okm:authRolesRead", this.getPermissions(fmd.getGrantedRoles(), 1));
            folderNode.setProperty("okm:authRolesWrite", this.getPermissions(fmd.getGrantedRoles(), 2));
            folderNode.setProperty("okm:authRolesDelete", this.getPermissions(fmd.getGrantedRoles(), 4));
            folderNode.setProperty("okm:authRolesSecurity", this.getPermissions(fmd.getGrantedRoles(), 8));
            for (PropertyGroupMetadata pgmd : fmd.getPropertyGroups()) {
                folderNode.addMixin(pgmd.getName());
                for (PropertyMetadata pmd : pgmd.getProperties()) {
                    if (pmd.isMultiValue()) {
                        folderNode.setProperty(pmd.getName(), this.getValues(pmd.getValues()));
                        continue;
                    }
                    folderNode.setProperty(pmd.getName(), pmd.getValue());
                }
            }
            parentNode.save();
        }
        catch (LoginException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (ItemExistsException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw new com.openkm.core.ItemExistsException(e.getMessage(), e);
        }
        catch (javax.jcr.RepositoryException e) {
            JCRUtils.discardsPendingChanges(parentNode);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            if (this.token == null) {
                JCRUtils.logout(session);
            }
        }
    }

    private String[] getPermissions(Map<String, Byte> grants, int perm) {
        ArrayList<String> principals = new ArrayList<String>();
        for (Map.Entry<String, Byte> grant : grants.entrySet()) {
            if ((grant.getValue() & perm) == 0) continue;
            principals.add(grant.getKey());
        }
        return principals.toArray(new String[principals.size()]);
    }

    private String[] getValues(Collection<String> values) {
        String[] ret = new String[values.size()];
        int i = 0;
        for (String val : values) {
            ret[i++] = val;
        }
        return ret;
    }

    private String[] getValues(Set<CategoryMetadata> categories) {
        String[] ret = new String[categories.size()];
        int i = 0;
        for (CategoryMetadata cmd : categories) {
            ret[i++] = cmd.getUuid();
        }
        return ret;
    }

    private Map<String, Byte> getGrantedUsers(Node parentNode) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        HashMap<String, Byte> ret = new HashMap<String, Byte>();
        for (Value userRead : parentNode.getProperty("okm:authUsersRead").getValues()) {
            ret.put(userRead.getString(), (byte)1);
        }
        for (Value userWrite : parentNode.getProperty("okm:authUsersWrite").getValues()) {
            if (ret.get(userWrite.getString()) == null) {
                ret.put(userWrite.getString(), (byte)2);
                continue;
            }
            ret.put(userWrite.getString(), (byte)((Byte)ret.get(userWrite.getString()) | 2));
        }
        for (Value userDelete : parentNode.getProperty("okm:authUsersDelete").getValues()) {
            if (ret.get(userDelete.getString()) == null) {
                ret.put(userDelete.getString(), (byte)4);
                continue;
            }
            ret.put(userDelete.getString(), (byte)((Byte)ret.get(userDelete.getString()) | 4));
        }
        for (Value userSecurity : parentNode.getProperty("okm:authUsersSecurity").getValues()) {
            if (ret.get(userSecurity.getString()) == null) {
                ret.put(userSecurity.getString(), (byte)8);
                continue;
            }
            ret.put(userSecurity.getString(), (byte)((Byte)ret.get(userSecurity.getString()) | 8));
        }
        return ret;
    }

    private Map<String, Byte> getGrantedRoles(Node parentNode) throws ValueFormatException, PathNotFoundException, javax.jcr.RepositoryException {
        HashMap<String, Byte> ret = new HashMap<String, Byte>();
        for (Value roleRead : parentNode.getProperty("okm:authRolesRead").getValues()) {
            ret.put(roleRead.getString(), (byte)1);
        }
        for (Value roleWrite : parentNode.getProperty("okm:authRolesWrite").getValues()) {
            if (ret.get(roleWrite.getString()) == null) {
                ret.put(roleWrite.getString(), (byte)2);
                continue;
            }
            ret.put(roleWrite.getString(), (byte)((Byte)ret.get(roleWrite.getString()) | 2));
        }
        for (Value roleDelete : parentNode.getProperty("okm:authRolesDelete").getValues()) {
            if (ret.get(roleDelete.getString()) == null) {
                ret.put(roleDelete.getString(), (byte)4);
                continue;
            }
            ret.put(roleDelete.getString(), (byte)((Byte)ret.get(roleDelete.getString()) | 4));
        }
        for (Value roleSecurity : parentNode.getProperty("okm:authRolesSecurity").getValues()) {
            if (ret.get(roleSecurity.getString()) == null) {
                ret.put(roleSecurity.getString(), (byte)8);
                continue;
            }
            ret.put(roleSecurity.getString(), (byte)((Byte)ret.get(roleSecurity.getString()) | 8));
        }
        return ret;
    }
}

