/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.impexp.metadata;

import com.openkm.api.OKMAuth;
import com.openkm.api.OKMScripting;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.bean.Mail;
import com.openkm.bean.Note;
import com.openkm.bean.Version;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.util.impexp.metadata.CategoryMetadata;
import com.openkm.util.impexp.metadata.DocumentMetadata;
import com.openkm.util.impexp.metadata.FolderMetadata;
import com.openkm.util.impexp.metadata.JcrMetadataAdapter;
import com.openkm.util.impexp.metadata.MailMetadata;
import com.openkm.util.impexp.metadata.NoteMetadata;
import com.openkm.util.impexp.metadata.PropertyGroupMetadata;
import com.openkm.util.impexp.metadata.VersionMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetadataAdapter {
    private static Logger log = LoggerFactory.getLogger(MetadataAdapter.class);
    protected String token = null;
    protected boolean uuid = false;

    protected MetadataAdapter() {
    }

    public static MetadataAdapter getInstance(String token) {
        return new JcrMetadataAdapter(token);
    }

    public void setRestoreUuid(boolean uuid) {
        this.uuid = uuid;
    }

    public DocumentMetadata getMetadata(Document doc) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getMetadata({})", new Object[]{doc});
        DocumentMetadata dmd = new DocumentMetadata();
        dmd.setUuid(doc.getUuid());
        dmd.setAuthor(doc.getAuthor());
        dmd.setName(JCRUtils.getName(doc.getPath()));
        dmd.setPath(doc.getPath());
        dmd.setLanguage(doc.getLanguage());
        dmd.setCreated(doc.getCreated());
        dmd.setLastModified(doc.getLastModified());
        dmd.setCipherName(doc.getCipherName());
        dmd.setKeywords(doc.getKeywords());
        dmd.setSubscriptors(doc.getSubscriptors());
        dmd.setVersion(this.getMetadata(doc.getActualVersion(), doc.getMimeType()));
        for (Folder cat : doc.getCategories()) {
            CategoryMetadata cmd = new CategoryMetadata();
            cmd.setUuid(cat.getUuid());
            cmd.setPath(cat.getPath());
            dmd.getCategories().add(cmd);
        }
        for (Note nt : doc.getNotes()) {
            dmd.getNotes().add(this.getMetadata(nt));
        }
        OKMScripting okmScripting = OKMScripting.getInstance();
        dmd.setScripting(okmScripting.getScript(this.token, doc.getPath()));
        OKMAuth okmAuth = OKMAuth.getInstance();
        dmd.setGrantedUsers(okmAuth.getGrantedUsers(this.token, doc.getPath()));
        dmd.setGrantedRoles(okmAuth.getGrantedRoles(this.token, doc.getPath()));
        dmd.setPropertyGroups(this.getPropertyGroupsMetada(doc.getPath()));
        log.debug("getMetadata: {}", (Object)dmd);
        return dmd;
    }

    public FolderMetadata getMetadata(Folder fld) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getMetadata({})", new Object[]{fld});
        FolderMetadata fmd = new FolderMetadata();
        fmd.setUuid(fld.getUuid());
        fmd.setAuthor(fld.getAuthor());
        fmd.setName(JCRUtils.getName(fld.getPath()));
        fmd.setPath(fld.getPath());
        fmd.setCreated(fld.getCreated());
        fmd.setSubscriptors(fld.getSubscriptors());
        for (Note nt : fld.getNotes()) {
            fmd.getNotes().add(this.getMetadata(nt));
        }
        OKMScripting okmScripting = OKMScripting.getInstance();
        fmd.setScripting(okmScripting.getScript(this.token, fld.getPath()));
        OKMAuth okmAuth = OKMAuth.getInstance();
        fmd.setGrantedUsers(okmAuth.getGrantedUsers(this.token, fld.getPath()));
        fmd.setGrantedRoles(okmAuth.getGrantedRoles(this.token, fld.getPath()));
        fmd.setPropertyGroups(this.getPropertyGroupsMetada(fld.getPath()));
        log.debug("getMetadata: {}", (Object)fmd);
        return fmd;
    }

    public MailMetadata getMetadata(Mail mail) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getMetadata({})", new Object[]{mail});
        MailMetadata mmd = new MailMetadata();
        mmd.setUuid(mail.getUuid());
        mmd.setPath(mail.getPath());
        mmd.setSize(mail.getSize());
        mmd.setFrom(mail.getFrom());
        mmd.setReply(this.getValues(mail.getReply()));
        mmd.setTo(this.getValues(mail.getTo()));
        mmd.setCc(this.getValues(mail.getCc()));
        mmd.setBcc(this.getValues(mail.getBcc()));
        mmd.setSentDate(mail.getSentDate());
        mmd.setReceivedDate(mail.getReceivedDate());
        mmd.setSubject(mail.getSubject());
        mmd.setContent(mail.getContent());
        mmd.setMimeType(mail.getMimeType());
        OKMScripting okmScripting = OKMScripting.getInstance();
        mmd.setScripting(okmScripting.getScript(this.token, mail.getPath()));
        OKMAuth okmAuth = OKMAuth.getInstance();
        mmd.setGrantedUsers(okmAuth.getGrantedUsers(this.token, mail.getPath()));
        mmd.setGrantedRoles(okmAuth.getGrantedRoles(this.token, mail.getPath()));
        mmd.setPropertyGroups(this.getPropertyGroupsMetada(mail.getPath()));
        log.debug("getMetadata: {}", (Object)mmd);
        return mmd;
    }

    private VersionMetadata getMetadata(Version ver, String mimeType) {
        log.debug("getMetadata({})", new Object[]{ver});
        VersionMetadata vmd = new VersionMetadata();
        vmd.setAuthor(ver.getAuthor());
        vmd.setName(ver.getName());
        vmd.setCreated(ver.getCreated());
        vmd.setSize(ver.getSize());
        vmd.setComment(ver.getComment());
        vmd.setMimeType(mimeType);
        log.debug("getMetadata: {}", (Object)vmd);
        return vmd;
    }

    private NoteMetadata getMetadata(Note nt) {
        log.debug("getMetadata({})", new Object[]{nt});
        NoteMetadata nmd = new NoteMetadata();
        nmd.setUser(nt.getUser());
        nmd.setDate(nt.getDate());
        nmd.setText(nt.getText());
        nmd.setPath(nt.getPath());
        log.debug("getMetadata: {}", (Object)nmd);
        return nmd;
    }

    private List<String> getValues(String[] values) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String val : values) {
            ret.add(val);
        }
        return ret;
    }

    protected abstract List<PropertyGroupMetadata> getPropertyGroupsMetada(String var1) throws RepositoryException, DatabaseException;

    public abstract void importWithMetadata(DocumentMetadata var1, InputStream var2) throws ItemExistsException, RepositoryException, DatabaseException, IOException;

    public abstract void importWithMetadata(FolderMetadata var1) throws ItemExistsException, RepositoryException, DatabaseException;
}

