/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.markov;

import java.util.InputMismatchException;

class CharQueue {
    private int length;
    private char[] queue;
    private int count;

    public CharQueue(int length) {
        this.length = length;
        this.queue = new char[length];
        this.count = 0;
    }

    public void set(String s) throws InputMismatchException {
        if (s.length() != this.length) {
            throw new InputMismatchException("Lengths don't match");
        }
        this.queue = s.toCharArray();
        this.count = this.length;
    }

    public void put(char c) {
        if (this.count == this.length) {
            System.arraycopy(this.queue, 1, this.queue, 0, this.length - 1);
            --this.count;
        }
        this.queue[this.count++] = c;
    }

    public String toString() {
        return new String(this.queue);
    }
}

