/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.markov;

import com.openkm.util.markov.CharQueue;
import com.openkm.util.markov.Markov;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.InputMismatchException;
import java.util.Random;

public class Generator {
    private static final int DEFAULT_PREFIX_LENGTH = 4;
    private static final int LINE_WIDTH = 80;
    private static final int TOTAL_CHARACTERS = 300;
    private int prefixLength;
    private Markov markov;

    public Generator(InputStream in, int prefixLength) throws IOException {
        this.markov = new Markov(new InputStreamReader(in), prefixLength);
        this.prefixLength = prefixLength;
    }

    public Generator(InputStream in) throws IOException {
        this.markov = new Markov(new InputStreamReader(in), 4);
        this.prefixLength = 4;
    }

    public void generateText(int paragraphs, OutputStream out) throws Exception {
        this.generateText(paragraphs, 80, 300, out);
    }

    public void generateText(int paragraphs, int lineWidth, int totalCharacters, OutputStream out) throws InputMismatchException, IOException {
        for (int i = 0; i < paragraphs; ++i) {
            this.generateParagraph(lineWidth, totalCharacters, out);
            out.write("\n\n".getBytes());
        }
    }

    public void generateParagraph(OutputStream out) throws InputMismatchException, IOException {
        this.generateParagraph(80, 300, out);
    }

    public void generateParagraph(int lineWidth, int totalCharacters, OutputStream out) throws InputMismatchException, IOException {
        String prefix;
        int c;
        Random random = new Random();
        CharQueue queue = new CharQueue(this.prefixLength);
        float weight = 0.0f;
        int width = this.prefixLength;
        queue.set(this.markov.getBootstrapPrefix());
        out.write(queue.toString().getBytes());
        while ((c = this.markov.get(prefix = queue.toString(), random)) != -1) {
            out.write((char)c);
            queue.put((char)c);
            if (c == 32 && ++width > lineWidth) {
                out.write("\n".getBytes());
                width = 0;
            }
            if ((weight = (float)((double)weight + 1.0 / (double)totalCharacters)) < 1.0f || c != 46) continue;
        }
    }
}

