/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.util.markov;

import com.openkm.util.markov.CharQueue;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Markov {
    private Map<String, Chain> map = new HashMap<String, Chain>();
    private String bootstrapPrefix;

    public Markov(Reader in, int length) throws IOException {
        int c;
        CharQueue queue = new CharQueue(length);
        for (int i = 0; i < length; ++i) {
            c = in.read();
            if (c == -1) {
                System.out.println("Input is too short");
                return;
            }
            queue.put((char)c);
        }
        this.bootstrapPrefix = queue.toString();
        boolean wasWhitespace = false;
        while ((c = in.read()) != -1) {
            if (Character.isWhitespace((char)c)) {
                if (wasWhitespace) continue;
                c = 32;
                wasWhitespace = true;
            } else {
                wasWhitespace = false;
            }
            String prefix = queue.toString();
            Chain chain = this.map.get(prefix);
            if (chain == null) {
                chain = new Chain(prefix);
                this.map.put(prefix, chain);
            }
            chain.add((char)c);
            queue.put((char)c);
        }
    }

    public String getBootstrapPrefix() {
        return this.bootstrapPrefix;
    }

    public int get(String prefix, Random random) {
        Chain chain = this.map.get(prefix);
        if (chain == null) {
            return -1;
        }
        int index = random.nextInt(chain.getTotal());
        return chain.get(index);
    }

    public void dump() {
        for (Chain chain : this.map.values()) {
            chain.dump();
        }
    }

    private static class Chain {
        private String prefix;
        private int total;
        private List<Link> list;

        public Chain(String prefix) {
            this.prefix = prefix;
            this.total = 0;
            this.list = new LinkedList<Link>();
        }

        public int getTotal() {
            return this.total;
        }

        public char get(int index) {
            for (Link link : this.list) {
                int count = link.getCount();
                if (index < count) {
                    return link.getChar();
                }
                index -= count;
            }
            return '@';
        }

        public void add(char c) {
            boolean found = false;
            for (Link link : this.list) {
                if (c != link.getChar()) continue;
                link.increment();
                found = true;
                break;
            }
            if (!found) {
                Link link = new Link(c);
                this.list.add(link);
            }
            ++this.total;
        }

        public void dump() {
            System.out.println(this.prefix + ": (" + this.total + ")");
            for (Link link : this.list) {
                System.out.println("    " + link.getChar() + " (" + link.getCount() + ")");
            }
        }

        private static class Link {
            private char c;
            private int count;

            public Link(char c) {
                this.c = c;
                this.count = 1;
            }

            public void increment() {
                ++this.count;
            }

            public int getCount() {
                return this.count;
            }

            public char getChar() {
                return this.c;
            }
        }
    }
}

